/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.transformers.MixinClassWriter;
import org.spongepowered.asm.transformers.TreeTransformer;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2;

class MixinPostProcessor
extends TreeTransformer
implements MixinConfig.IListener {
    private final Set<String> syntheticInnerClasses = new HashSet<String>();
    private final Map<String, MixinInfo> accessorMixins = new HashMap<String, MixinInfo>();
    private final Set<String> loadable = new HashSet<String>();

    MixinPostProcessor() {
    }

    @Override
    public void onInit(MixinInfo mixinInfo) {
        for (String string : mixinInfo.getSyntheticInnerClasses()) {
            this.registerSyntheticInner(string.replace((char)(0xC2FBD27E ^ 0xC2FBD251), (char)(0x756EF6A2 ^ 0x756EF68C)));
        }
    }

    @Override
    public void onPrepare(MixinInfo mixinInfo) {
        String string = mixinInfo.getClassName();
        if (mixinInfo.isLoadable()) {
            this.registerLoadable(string);
        }
        if (mixinInfo.isAccessor()) {
            this.registerAccessor(mixinInfo);
        }
    }

    void registerSyntheticInner(String string) {
        this.syntheticInnerClasses.add(string);
    }

    void registerLoadable(String string) {
        this.loadable.add(string);
    }

    void registerAccessor(MixinInfo mixinInfo) {
        this.registerLoadable(mixinInfo.getClassName());
        this.accessorMixins.put(mixinInfo.getClassName(), mixinInfo);
    }

    boolean canTransform(String string) {
        return (this.syntheticInnerClasses.contains(string) || this.loadable.contains(string) ? 0x2907F691 ^ 0x2907F690 : 0x2E83FCEF ^ 0x2E83FCEF) != 0;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean isDelegationExcluded() {
        return (0x8F99FBC2 ^ 0x8F99FBC3) != 0;
    }

    @Override
    public byte[] transformClassBytes(String string, String string2, byte[] byArray) {
        if (this.syntheticInnerClasses.contains(string2)) {
            return this.processSyntheticInner(byArray);
        }
        if (this.accessorMixins.containsKey(string2)) {
            MixinInfo mixinInfo = this.accessorMixins.get(string2);
            return this.processAccessor(byArray, mixinInfo);
        }
        return byArray;
    }

    private byte[] processSyntheticInner(byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        MixinClassWriter mixinClassWriter = new MixinClassWriter(classReader, 0x8255B346 ^ 0x8255B346);
        ClassVisitor classVisitor = new ClassVisitor(0x2F650E0F ^ 0x2F600E0F, mixinClassWriter){

            @Override
            public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
                super.visit(n, n2 | 0x6B4D763A ^ 0x6B4D763B, string, string2, string3, stringArray);
            }

            @Override
            public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
                if ((n & (0x6D12CAB1 ^ 0x6D12CAB7)) == 0) {
                    n |= 0xD5A0B7CE ^ 0xD5A0B7CF;
                }
                return super.visitField(n, string, string2, string3, object);
            }

            @Override
            public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
                if ((n & (0x89AD615C ^ 0x89AD615A)) == 0) {
                    n |= 0xA4E16CF4 ^ 0xA4E16CF5;
                }
                return super.visitMethod(n, string, string2, string3, stringArray);
            }
        };
        classReader.accept(classVisitor, 0x23E06F46 ^ 0x23E06F4E);
        return mixinClassWriter.toByteArray();
    }

    private byte[] processAccessor(byte[] byArray, MixinInfo mixinInfo) {
        if (!MixinEnvironment.getCompatibilityLevel().isAtLeast(MixinEnvironment.CompatibilityLevel.JAVA_8)) {
            return byArray;
        }
        int n = 0x4C25B30E ^ 0x4C25B30E;
        MixinInfo.MixinClassNode mixinClassNode = mixinInfo.getClassNode(0x826F5778 ^ 0x826F5778);
        ClassInfo classInfo = mixinInfo.getTargets().get(0x64DBACC3 ^ 0x64DBACC3);
        for (MixinInfo.MixinMethodNode mixinMethodNode : mixinClassNode.mixinMethods) {
            if (!Bytecode.hasFlag(mixinMethodNode, 0x8B7286E5 ^ 0x8B7286ED)) continue;
            AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(Accessor.class);
            AnnotationNode annotationNode2 = mixinMethodNode.getVisibleAnnotation(Invoker.class);
            if (annotationNode == null && annotationNode2 == null) continue;
            ClassInfo.Method method = MixinPostProcessor.getAccessorMethod(mixinInfo, mixinMethodNode, classInfo);
            MixinPostProcessor.createProxy(mixinMethodNode, classInfo, method);
            n = 0x1C092392 ^ 0x1C092393;
        }
        if (n != 0) {
            return this.writeClass(mixinClassNode);
        }
        return byArray;
    }

    private static ClassInfo.Method getAccessorMethod(MixinInfo mixinInfo, MethodNode methodNode, ClassInfo classInfo) throws MixinTransformerError {
        ClassInfo.Method method = mixinInfo.getClassInfo().findMethod(methodNode, 0xD0B63585 ^ 0xD0B6358F);
        if (!method.isRenamed()) {
            throw new MixinTransformerError(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7f5\ua4a1\ua070\ua911\u7d73\u8e10\u243a") + mixinInfo + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ea\ua4ba\ua070\ua901\u7d73\u8e4e\u243a\u8b35\u3472t\ua7e9\ua4a7\ua074\ua945") + classInfo + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7f1\ua4b4\ua062\ua945\u7d75\u8e45\u2474\u8b31\u3478`\ua7eb\ua4b0\ua075"));
        }
        return method;
    }

    private static void createProxy(MethodNode methodNode, ClassInfo classInfo, ClassInfo.Method method) {
        methodNode.instructions.clear();
        Type[] typeArray = Type.getArgumentTypes(methodNode.desc);
        Type type = Type.getReturnType(methodNode.desc);
        Bytecode.loadArgs(typeArray, methodNode.instructions, 0xB3B86DF1 ^ 0xB3B86DF1);
        methodNode.instructions.add(new MethodInsnNode(0x72500D77 ^ 0x72500DCF, classInfo.getName(), method.getName(), methodNode.desc, (0x1BEFDB3B ^ 0x1BEFDB3B) != 0));
        methodNode.instructions.add(new InsnNode(type.getOpcode(0x8167F3DE ^ 0x8167F372)));
        methodNode.maxStack = Bytecode.getFirstNonArgLocalIndex(typeArray, (0xF5E8B7CF ^ 0xF5E8B7CF) != 0);
        methodNode.maxLocals = 0xF069F285 ^ 0xF069F285;
    }
}

