/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.gen.throwables.InvalidAccessorException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.MethodMapper;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.perf.Profiler;
import org.spongepowered.asm.util.throwables.SyntheticBridgeException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2;

class MixinPreProcessorStandard {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    protected final MixinInfo mixin;
    protected final MixinInfo.MixinClassNode classNode;
    protected final MixinEnvironment env;
    protected final Profiler profiler = MixinEnvironment.getProfiler();
    private final boolean verboseLogging;
    private final boolean strictUnique;
    private boolean prepared;
    private boolean attached;

    MixinPreProcessorStandard(MixinInfo mixinInfo, MixinInfo.MixinClassNode mixinClassNode) {
        this.mixin = mixinInfo;
        this.classNode = mixinClassNode;
        this.env = mixinInfo.getParent().getEnvironment();
        this.verboseLogging = this.env.getOption(MixinEnvironment.Option.DEBUG_VERBOSE);
        this.strictUnique = this.env.getOption(MixinEnvironment.Option.DEBUG_UNIQUE);
    }

    final MixinPreProcessorStandard prepare() {
        if (this.prepared) {
            return this;
        }
        this.prepared = 0x74F08CEC ^ 0x74F08CED;
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("b\ua7f4\ua4b0\ua061\ua904\u7d64\u8e4f"));
        for (MixinInfo.MixinMethodNode object : this.classNode.mixinMethods) {
            ClassInfo.Method method = this.mixin.getClassInfo().findMethod(object);
            this.prepareMethod(object, method);
        }
        for (FieldNode fieldNode : this.classNode.fields) {
            this.prepareField(fieldNode);
        }
        section.end();
        return this;
    }

    protected void prepareMethod(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        this.prepareShadow(mixinMethodNode, method);
        this.prepareSoftImplements(mixinMethodNode, method);
    }

    protected void prepareShadow(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        AnnotationNode annotationNode = Annotations.getVisible(mixinMethodNode, Shadow.class);
        if (annotationNode == null) {
            return;
        }
        String string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("b\ua7f4\ua4b0\ua077\ua90c\u7d6e"), Shadow.class);
        if (mixinMethodNode.name.startsWith(string)) {
            Object[] objectArray = new Object[0xF2E8E371 ^ 0xF2E8E373];
            objectArray[0x50DB0087 ^ 0x50DB0087] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("}\ua7f4\ua4bc\ua076\ua90c\u7d78\u8e4b\u2476\u8b19\u3476\u007f\ua7e3");
            objectArray[0xD83679D2 ^ 0xD83679D3] = mixinMethodNode.name;
            Annotations.setVisible(mixinMethodNode, MixinRenamed.class, objectArray);
            String string2 = mixinMethodNode.name.substring(string.length());
            mixinMethodNode.name = method.renameTo(string2);
        }
    }

    protected void prepareSoftImplements(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        for (InterfaceInfo interfaceInfo : this.mixin.getSoftImplements()) {
            if (!interfaceInfo.renameMethod(mixinMethodNode)) continue;
            method.renameTo(mixinMethodNode.name);
        }
    }

    protected void prepareField(FieldNode fieldNode) {
    }

    final MixinPreProcessorStandard conform(TargetClassContext targetClassContext) {
        return this.conform(targetClassContext.getClassInfo());
    }

    final MixinPreProcessorStandard conform(ClassInfo classInfo) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("q\ua7e9\ua4bb\ua077\ua90a\u7d64\u8e47"));
        for (MixinInfo.MixinMethodNode mixinMethodNode : this.classNode.mixinMethods) {
            if (!mixinMethodNode.isInjector()) continue;
            ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0x8060F652 ^ 0x8060F658);
            this.conformInjector(classInfo, mixinMethodNode, method);
        }
        section.end();
        return this;
    }

    private void conformInjector(ClassInfo classInfo, MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        MethodMapper methodMapper = classInfo.getMethodMapper();
        methodMapper.remapHandlerMethod(this.mixin, mixinMethodNode, method);
    }

    MixinTargetContext createContextFor(TargetClassContext targetClassContext) {
        MixinTargetContext mixinTargetContext = new MixinTargetContext(this.mixin, this.classNode, targetClassContext);
        this.conform(targetClassContext);
        this.attach(mixinTargetContext);
        return mixinTargetContext;
    }

    final MixinPreProcessorStandard attach(MixinTargetContext mixinTargetContext) {
        if (this.attached) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("B\ua7f4\ua4b0\ua061\ua917\u7d79\u8e49\u247f\u8b24\u3464}\ua7f4\ua4f5\ua066\ua904\u7d65\u8e0a\u247b\u8b3b\u3465w\ua7e7\ua4b1\ua068\ua945\u7d77\u8e5e\u246e\u8b36\u3474z\ua7e3\ua4b1"));
        }
        this.attached = 0x649F7E3D ^ 0x649F7E3C;
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("s\ua7f2\ua4a1\ua070\ua906\u7d7e"));
        Profiler.Section section2 = this.profiler.begin(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e59"));
        this.attachMethods(mixinTargetContext);
        section2 = section2.next(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("t\ua7ef\ua4b0\ua07d\ua901\u7d65"));
        this.attachFields(mixinTargetContext);
        section2 = section2.next(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("f\ua7f4\ua4b4\ua07f\ua916\u7d70\u8e45\u2468\u8b3a"));
        this.transform(mixinTargetContext);
        section2.end();
        section.end();
        return this;
    }

    protected void attachMethods(MixinTargetContext mixinTargetContext) {
        Iterator<MixinInfo.MixinMethodNode> iterator = this.classNode.mixinMethods.iterator();
        while (iterator.hasNext()) {
            MixinInfo.MixinMethodNode mixinMethodNode = iterator.next();
            if (!this.validateMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            if (this.attachInjectorMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addMixinMethod(mixinMethodNode);
                continue;
            }
            if (this.attachAccessorMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            if (this.attachShadowMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addShadowMethod(mixinMethodNode);
                iterator.remove();
                continue;
            }
            if (this.attachOverwriteMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addMixinMethod(mixinMethodNode);
                continue;
            }
            if (this.attachUniqueMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            this.attachMethod(mixinTargetContext, mixinMethodNode);
            mixinTargetContext.addMixinMethod(mixinMethodNode);
        }
    }

    protected boolean validateMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return (0xD30C4056 ^ 0xD30C4057) != 0;
    }

    protected boolean attachInjectorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return mixinMethodNode.isInjector();
    }

    protected boolean attachAccessorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return (this.attachAccessorMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.ACCESSOR) || this.attachAccessorMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.INVOKER) ? 0xE7632B6D ^ 0xE7632B6C : 0xD167CB3E ^ 0xD167CB3E) != 0;
    }

    protected boolean attachAccessorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(specialMethod.annotation);
        if (annotationNode == null) {
            return (0x3B6F2391 ^ 0x3B6F2391) != 0;
        }
        String string = (Object)((Object)specialMethod) + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a") + mixinMethodNode.name;
        ClassInfo.Method method = this.getSpecialMethod(mixinMethodNode, specialMethod);
        if (MixinEnvironment.getCompatibilityLevel().isAtLeast(MixinEnvironment.CompatibilityLevel.JAVA_8) && method.isStatic()) {
            if (this.mixin.getTargets().size() > (0x73B85BF5 ^ 0x73B85BF4)) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ef\ua4bb\ua031\ua908\u7d63\u8e46\u246e\u8b3e\u343af\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2477\u8b3e\u346f{\ua7e8\ua4f5\ua078\ua916\u7d36\u8e43\u2474\u8b21\u3476~\ua7ef\ua4b1\ua03f\ua945\u7d5b\u8e43\u2462\u8b3e\u34792\ua7eb\ua4a0\ua062\ua911\u7d36\u8e42\u247b\u8b21\u34722\ua7e3\ua4ad\ua070\ua906\u7d62\u8e46\u2463\u8b77\u34262\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u2434"));
            }
            String string2 = mixinTargetContext.getUniqueName(mixinMethodNode, (0x937972D6 ^ 0x937972D7) != 0);
            Object[] objectArray = new Object[0x815EB3F8 ^ 0x815EB3FC];
            objectArray[0x8C921EE0 ^ 0x8C921EE0] = mixinMethodNode.name;
            objectArray[0xCEDBAADF ^ 0xCEDBAADE] = mixinMethodNode.desc;
            objectArray[0x7A2E6BF0 ^ 0x7A2E6BF2] = string2;
            objectArray[0xB917523B ^ 0xB9175238] = this.mixin;
            logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e51\u2467\u8b77\u3463}\ua7a6\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a"), objectArray);
            mixinMethodNode.name = method.renameTo(string2);
        } else {
            if (!method.isAbstract()) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b36\u3475a\ua7f2\ua4a7\ua070\ua906\u7d62"));
            }
            if (method.isStatic()) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7e5\ua4b4\ua07f\ua90b\u7d79\u8e5e\u243a\u8b35\u34722\ua7f5\ua4a1\ua070\ua911\u7d7f\u8e49"));
            }
        }
        mixinTargetContext.addAccessorMethod(mixinMethodNode, specialMethod.annotation);
        return (0x308DE3FA ^ 0x308DE3FB) != 0;
    }

    protected boolean attachShadowMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return this.attachSpecialMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.SHADOW);
    }

    protected boolean attachOverwriteMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return this.attachSpecialMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.OVERWRITE);
    }

    protected boolean attachSpecialMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(specialMethod.annotation);
        if (annotationNode == null) {
            return (0x42819223 ^ 0x42819223) != 0;
        }
        if (specialMethod.isOverwrite) {
            this.checkMixinNotUnique(mixinMethodNode, specialMethod);
        }
        ClassInfo.Method method = this.getSpecialMethod(mixinMethodNode, specialMethod);
        MethodNode methodNode = mixinTargetContext.findMethod(mixinMethodNode, annotationNode);
        if (methodNode == null) {
            if (specialMethod.isOverwrite) {
                return (0x7CE46FB4 ^ 0x7CE46FB4) != 0;
            }
            methodNode = mixinTargetContext.findRemappedMethod(mixinMethodNode);
            if (methodNode == null) {
                Object[] objectArray = new Object[0x1BE17EE2 ^ 0x1BE17EE4];
                objectArray[0xACB91ACD ^ 0xACB91ACD] = specialMethod;
                objectArray[0x169CD3DA ^ 0x169CD3DB] = mixinMethodNode.name;
                objectArray[0x17C1DE89 ^ 0x17C1DE8B] = this.mixin;
                objectArray[0x27B14105 ^ 0x27B14106] = mixinTargetContext.getTarget();
                objectArray[0xD98E8559 ^ 0xD98E855D] = mixinTargetContext.getReferenceMapper().getStatus();
                objectArray[0x44B9D724 ^ 0x44B9D721] = MixinPreProcessorStandard.getDynamicInfo(mixinMethodNode);
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3460s\ua7f5\ua4f5\ua07f\ua90a\u7d62\u8e0a\u2476\u8b38\u3474s\ua7f2\ua4b0\ua075\ua945\u7d7f\u8e44\u243a\u8b23\u347fw\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u3474~\ua7e7\ua4a6\ua062\ua945\u7d33\u8e59\u2434\u8b77\u3432a\ua7a3\ua4a6"), objectArray));
            }
            mixinMethodNode.name = method.renameTo(methodNode.name);
        }
        if (\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name)) {
            Object[] objectArray = new Object[0x211AC000 ^ 0x211AC002];
            objectArray[0x796563CF ^ 0x796563CF] = mixinMethodNode.name;
            objectArray[0x3A6377DF ^ 0x3A6377DE] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\\\ua7ef\ua4b6\ua074\ua945\u7d62\u8e58\u2463\u8b76\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e4b\u2476\u8b3e\u3476a\ua7a6\ua4b4\ua031\ua906\u7d79\u8e44\u2469\u8b23\u3465g\ua7e5\ua4a1\ua07e\ua917"), objectArray));
        }
        if (!Bytecode.compareFlags(mixinMethodNode, methodNode, 0x8A2EEDE9 ^ 0x8A2EEDE1)) {
            Object[] objectArray = new Object[0xA9F0CF72 ^ 0xA9F0CF71];
            objectArray[0xD62A0138 ^ 0xD62A0138] = specialMethod;
            objectArray[0x77F803F9 ^ 0x77F803F8] = mixinMethodNode.name;
            objectArray[0x819D8C10 ^ 0x819D8C12] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("A\ua7d2\ua494\ua045\ua92c\u7d55\u8e0a\u2477\u8b38\u3473{\ua7e0\ua4bc\ua074\ua917\u7d36\u8e45\u247c\u8b77\u3432a\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3432a\ua7a6\ua4bc\ua07f\ua945\u7d33\u8e59\u243a\u8b33\u3478w\ua7f5\ua4f5\ua07f\ua90a\u7d62\u8e0a\u2477\u8b36\u3463q\ua7ee\ua4f5\ua065\ua90d\u7d73\u8e0a\u246e\u8b36\u3465u\ua7e3\ua4a1"), objectArray));
        }
        this.conformVisibility(mixinTargetContext, mixinMethodNode, specialMethod, methodNode);
        if (!methodNode.name.equals(mixinMethodNode.name)) {
            if (specialMethod.isOverwrite) {
                if ((methodNode.access & (0x1861002B ^ 0x18610029)) == 0) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\\\ua7e9\ua4bb\ua03c\ua915\u7d64\u8e43\u246c\u8b36\u3463w\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3476~\ua7ef\ua4b4\ua062\ua900\u7d72\u8e04\u243a\u8b11\u3478g\ua7e8\ua4b1\ua031") + methodNode.name);
                }
            }
            mixinMethodNode.name = method.renameTo(methodNode.name);
        }
        return (0x926AB619 ^ 0x926AB618) != 0;
    }

    private void conformVisibility(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod, MethodNode methodNode) {
        Bytecode.Visibility visibility = Bytecode.getVisibility(methodNode);
        Bytecode.Visibility visibility2 = Bytecode.getVisibility(mixinMethodNode);
        if (visibility2.ordinal() >= visibility.ordinal()) {
            if (visibility == Bytecode.Visibility.PRIVATE && visibility2.ordinal() > Bytecode.Visibility.PRIVATE.ordinal()) {
                mixinTargetContext.getTarget().addUpgradedMethod(methodNode);
            }
            return;
        }
        Object[] objectArray = new Object[0xB4CF644C ^ 0xB4CF6449];
        objectArray[0xAE28C4A5 ^ 0xAE28C4A5] = visibility2;
        objectArray[0x8FD716F6 ^ 0x8FD716F7] = specialMethod;
        objectArray[0xCB9FEE7A ^ 0xCB9FEE78] = mixinMethodNode.name;
        objectArray[0xB484DF17 ^ 0xB484DF14] = this.mixin;
        objectArray[0x52E6B5AD ^ 0x52E6B5A9] = visibility;
        String string = String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4f5\ua034\ua916\u7d36\u8e47\u247f\u8b23\u347f}\ua7e2\ua4f5\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b6\ua070\ua90b\u7d78\u8e45\u246e\u8b77\u3465w\ua7e2\ua4a0\ua072\ua900\u7d36\u8e5c\u2473\u8b24\u347ep\ua7ef\ua4b9\ua078\ua91c\u7d36\u8e45\u247c\u8b77\u3432a\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901"), objectArray);
        if (specialMethod.isOverwrite && !this.mixin.getParent().conformOverwriteVisibility()) {
            throw new InvalidMixinException((IMixinInfo)this.mixin, string);
        }
        if (visibility2 == Bytecode.Visibility.PRIVATE) {
            if (specialMethod.isOverwrite) {
                Object[] objectArray2 = new Object[0x77068471 ^ 0x77068470];
                objectArray2[0xE70D9C46 ^ 0xE70D9C46] = string;
                logger.warn(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("A\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u2478\u8b3e\u3479v\ua7ef\ua4bb\ua076\ua945\u7d60\u8e43\u2475\u8b3b\u3476f\ua7ef\ua4ba\ua07f\ua95f\u7d36\u8e51\u2467\u8b7b\u3437d\ua7ef\ua4a6\ua078\ua907\u7d7f\u8e46\u2473\u8b23\u346e2\ua7f1\ua4bc\ua07d\ua909\u7d36\u8e48\u247f\u8b77\u3462b\ua7e1\ua4a7\ua070\ua901\u7d73\u8e4e\u2434"), objectArray2);
            }
            mixinTargetContext.addUpgradedMethod(mixinMethodNode);
            Bytecode.setVisibility((MethodNode)mixinMethodNode, visibility);
        }
    }

    protected ClassInfo.Method getSpecialMethod(MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0xF4E8590C ^ 0xF4E85906);
        this.checkMethodNotUnique(method, specialMethod);
        return method;
    }

    protected void checkMethodNotUnique(ClassInfo.Method method, SpecialMethod specialMethod) {
        if (method.isUnique()) {
            Object[] objectArray = new Object[0xF6AEF005 ^ 0xF6AEF006];
            objectArray[0xB850C036 ^ 0xB850C036] = specialMethod;
            objectArray[0x2D4C8571 ^ 0x2D4C8570] = method.getName();
            objectArray[0xD4DD6FC6 ^ 0xD4DD6FC4] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73"), objectArray));
        }
    }

    protected void checkMixinNotUnique(MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        if (this.mixin.isUnique()) {
            Object[] objectArray = new Object[0x987F83E7 ^ 0x987F83E4];
            objectArray[0xE2712D81 ^ 0xE2712D81] = specialMethod;
            objectArray[0xBC451E7F ^ 0xBC451E7E] = mixinMethodNode.name;
            objectArray[0x9F7CFC7F ^ 0x9F7CFC7D] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b77\u347e|\ua7a6\ua4b4\ua031\ua925\u7d43\u8e44\u2473\u8b26\u3462w\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b72\u3464"), objectArray));
        }
    }

    protected boolean attachUniqueMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        String string;
        MethodNode methodNode;
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0xFAF40C4C ^ 0xFAF40C46);
        if (method == null || !method.isUnique() && !this.mixin.isUnique() && !method.isSynthetic()) {
            return (0x91A2BF91 ^ 0x91A2BF91) != 0;
        }
        if (method.isSynthetic()) {
            mixinTargetContext.transformDescriptor(mixinMethodNode);
            method.remapTo(mixinMethodNode.desc);
        }
        if ((methodNode = mixinTargetContext.findMethod(mixinMethodNode, null)) == null) {
            return (0x37224D74 ^ 0x37224D74) != 0;
        }
        String string2 = string = method.isSynthetic() ? \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("a\ua7ff\ua4bb\ua065\ua90d\u7d73\u8e5e\u2473\u8b34") : \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("R\ua7d3\ua4bb\ua078\ua914\u7d63\u8e4f");
        if (Bytecode.getVisibility(mixinMethodNode).ordinal() < Bytecode.Visibility.PUBLIC.ordinal()) {
            String string3 = mixinTargetContext.getUniqueName(mixinMethodNode, (0x1939859 ^ 0x1939859) != 0);
            Object[] objectArray = new Object[0x73207172 ^ 0x73207177];
            objectArray[0xBD56AE7A ^ 0xBD56AE7A] = string;
            objectArray[0x5380C322 ^ 0x5380C323] = mixinMethodNode.name;
            objectArray[0x8D8B1D1C ^ 0x8D8B1D1E] = mixinMethodNode.desc;
            objectArray[0xB5CD5357 ^ 0xB5CD5354] = string3;
            objectArray[0x9DA33A14 ^ 0x9DA33A10] = this.mixin;
            logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u346co\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u346co\ua7fd\ua4a8\ua031\ua911\u7d79\u8e0a\u2461\u8b2a\u3437{\ua7e8\ua4f5\ua06a\ua918"), objectArray);
            mixinMethodNode.name = method.renameTo(string3);
            return (0x436B9AB1 ^ 0x436B9AB1) != 0;
        }
        if (this.strictUnique) {
            Object[] objectArray = new Object[0xE9D1821F ^ 0xE9D18219];
            objectArray[0x27D2407E ^ 0x27D2407E] = string;
            objectArray[0xF3152059 ^ 0xF3152058] = mixinMethodNode.name;
            objectArray[0x61D06B5B ^ 0x61D06B59] = this.mixin;
            objectArray[0x32B59A55 ^ 0x32B59A56] = methodNode.name;
            objectArray[0xF66A012D ^ 0xF66A0129] = methodNode.desc;
            objectArray[0x11CD0E8F ^ 0x11CD0E8A] = mixinTargetContext.getTarget();
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d3a\u8e0a\u243f\u8b24\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u243f\u8b24\u3437{\ua7e8\ua4f5\ua034\ua916\u7d36\u8e49\u247b\u8b39\u3479}\ua7f2\ua4f5\ua07e\ua913\u7d73\u8e58\u246d\u8b25\u347ef\ua7e3\ua4f5\ua034\ua916\u7d33\u8e59\u243a\u8b3e\u34792\ua7a3\ua4a6"), objectArray));
        }
        AnnotationNode annotationNode = Annotations.getVisible(mixinMethodNode, Unique.class);
        if (annotationNode == null || !Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("a\ua7ef\ua4b9\ua074\ua90b\u7d62"), Boolean.FALSE).booleanValue()) {
            if (Bytecode.hasFlag(mixinMethodNode, 0x60FCFB7A ^ 0x60FCFB3A)) {
                try {
                    Bytecode.compareBridgeMethods(methodNode, mixinMethodNode);
                    Object[] objectArray = new Object[0x8A0E3885 ^ 0x8A0E3881];
                    objectArray[0xA38CCBC2 ^ 0xA38CCBC2] = string;
                    objectArray[0xF814A047 ^ 0xF814A046] = mixinMethodNode.name;
                    objectArray[0xB5006528 ^ 0xB500652A] = this.mixin;
                    objectArray[0xAAB1629E ^ 0xAAB1629D] = mixinTargetContext.getTarget();
                    logger.debug(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7f5\ua4ac\ua065\ua90d\u7d73\u8e5e\u2473\u8b34\u3437p\ua7f4\ua4bc\ua075\ua902\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua073\ua900\u7d75\u8e4b\u246f\u8b24\u34722\ua7e3\ua4ad\ua078\ua916\u7d62\u8e43\u2474\u8b30\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua078\ua916\u7d36\u8e49\u2475\u8b3a\u3467s\ua7f2\ua4bc\ua073\ua909\u7d73"), objectArray);
                    return (0xE7DB069B ^ 0xE7DB069A) != 0;
                }
                catch (SyntheticBridgeException syntheticBridgeException) {
                    if (this.verboseLogging || this.env.getOption(MixinEnvironment.Option.DEBUG_VERIFY)) {
                        syntheticBridgeException.printAnalysis(mixinTargetContext, methodNode, mixinMethodNode);
                    }
                    throw new InvalidMixinException((IMixinInfo)this.mixin, syntheticBridgeException.getMessage());
                }
            }
            Object[] objectArray = new Object[0x8546FBB2 ^ 0x8546FBB6];
            objectArray[0x476CF875 ^ 0x476CF875] = string;
            objectArray[0xA13ACDBD ^ 0xA13ACDBC] = mixinMethodNode.name;
            objectArray[0xEF2119BC ^ 0xEF2119BE] = this.mixin;
            objectArray[0x4849290B ^ 0x48492908] = mixinTargetContext.getTarget();
            logger.warn(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7fd\ua4a8\ua031\ua915\u7d63\u8e48\u2476\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b2c\u346a2\ua7ef\ua4bb\ua031\ua91e\u7d6b\u8e0a\u2478\u8b32\u3474s\ua7f3\ua4a6\ua074\ua945\u7d7f\u8e5e\u243a\u8b36\u347b`\ua7e3\ua4b4\ua075\ua91c\u7d36\u8e4f\u2462\u8b3e\u3464f\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e51\u2467"), objectArray);
            return (0x9FA7A74C ^ 0x9FA7A74D) != 0;
        }
        mixinTargetContext.addMixinMethod(mixinMethodNode);
        return (0x2C61CEA8 ^ 0x2C61CEA9) != 0;
    }

    protected void attachMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        MethodNode methodNode;
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode);
        if (method == null) {
            return;
        }
        ClassInfo.Method method2 = this.mixin.getClassInfo().findMethodInHierarchy(mixinMethodNode, ClassInfo.SearchType.SUPER_CLASSES_ONLY);
        if (method2 != null && method2.isRenamed()) {
            mixinMethodNode.name = method.renameTo(method2.getName());
        }
        if ((methodNode = mixinTargetContext.findMethod(mixinMethodNode, null)) != null) {
            this.conformVisibility(mixinTargetContext, mixinMethodNode, SpecialMethod.MERGE, methodNode);
        }
    }

    protected void attachFields(MixinTargetContext mixinTargetContext) {
        Iterator iterator = this.classNode.fields.iterator();
        while (iterator.hasNext()) {
            int n;
            FieldNode fieldNode = (FieldNode)iterator.next();
            AnnotationNode annotationNode = Annotations.getVisible(fieldNode, Shadow.class);
            int n2 = annotationNode != null ? 0x4C1385A3 ^ 0x4C1385A2 : (n = 0xD358E145 ^ 0xD358E145);
            if (!this.validateField(mixinTargetContext, fieldNode, annotationNode)) {
                iterator.remove();
                continue;
            }
            ClassInfo.Field field = this.mixin.getClassInfo().findField(fieldNode);
            mixinTargetContext.transformDescriptor(fieldNode);
            field.remapTo(fieldNode.desc);
            if (field.isUnique() && n != 0) {
                Object[] objectArray = new Object[0xF560BD4C ^ 0xF560BD4D];
                objectArray[0xA6EE0C3D ^ 0xA6EE0C3D] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua940\u7d65\u8e0a\u2479\u8b36\u3479|\ua7e9\ua4a1\ua031\ua907\u7d73\u8e0a\u245a\u8b02\u3479{\ua7f7\ua4a0\ua074"), objectArray));
            }
            FieldNode fieldNode2 = mixinTargetContext.findField(fieldNode, annotationNode);
            if (fieldNode2 == null) {
                if (annotationNode == null) continue;
                fieldNode2 = mixinTargetContext.findRemappedField(fieldNode);
                if (fieldNode2 == null) {
                    Object[] objectArray = new Object[0x6691B00C ^ 0x6691B008];
                    objectArray[0xEA27DA19 ^ 0xEA27DA19] = fieldNode.name;
                    objectArray[0xDA642DBF ^ 0xDA642DBE] = mixinTargetContext.getTarget();
                    objectArray[0x6FAF7A8A ^ 0x6FAF7A88] = mixinTargetContext.getReferenceMapper().getStatus();
                    objectArray[0x26702CC4 ^ 0x26702CC7] = MixinPreProcessorStandard.getDynamicInfo(fieldNode);
                    throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("A\ua7ee\ua4b4\ua075\ua90a\u7d61\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d36\u8e5d\u247b\u8b24\u3437|\ua7e9\ua4a1\ua031\ua909\u7d79\u8e49\u247b\u8b23\u3472v\ua7a6\ua4bc\ua07f\ua945\u7d62\u8e42\u247f\u8b77\u3463s\ua7f4\ua4b2\ua074\ua911\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4f0\ua062\ua94b\u7d36\u8e0f\u2469\u8b72\u3464"), objectArray));
                }
                fieldNode.name = field.renameTo(fieldNode2.name);
            }
            if (!Bytecode.compareFlags(fieldNode, fieldNode2, 0x23658F92 ^ 0x23658F9A)) {
                Object[] objectArray = new Object[0xC69C705D ^ 0xC69C705F];
                objectArray[0xC7BE705E ^ 0xC7BE705E] = fieldNode.name;
                objectArray[0x7CF31882 ^ 0x7CF31883] = this.mixin;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("A\ua7d2\ua494\ua045\ua92c\u7d55\u8e0a\u2477\u8b38\u3473{\ua7e0\ua4bc\ua074\ua917\u7d36\u8e45\u247c\u8b77\u3457A\ua7ee\ua4b4\ua075\ua90a\u7d61\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b1\ua07e\ua900\u7d65\u8e0a\u2474\u8b38\u34632\ua7eb\ua4b4\ua065\ua906\u7d7e\u8e0a\u246e\u8b3f\u34722\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e"), objectArray));
            }
            if (field.isUnique()) {
                if ((fieldNode.access & (0xB06955BC ^ 0xB06955BA)) != 0) {
                    String string = mixinTargetContext.getUniqueName(fieldNode);
                    Object[] objectArray = new Object[0xDF8F17B6 ^ 0xDF8F17B2];
                    objectArray[0x9189576C ^ 0x9189576C] = fieldNode.name;
                    objectArray[0x3F573B0B ^ 0x3F573B0A] = fieldNode.desc;
                    objectArray[0x840D4F3C ^ 0x840D4F3E] = string;
                    objectArray[0xB330713 ^ 0xB330710] = this.mixin;
                    logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua06a\ua918\u7d6d\u8e57\u243a\u8b23\u34782\ua7fd\ua4a8\ua031\ua90c\u7d78\u8e0a\u2461\u8b2a"), objectArray);
                    fieldNode.name = field.renameTo(string);
                    continue;
                }
                if (this.strictUnique) {
                    Object[] objectArray = new Object[0x73A0693E ^ 0x73A0693B];
                    objectArray[0x626D6875 ^ 0x626D6875] = fieldNode.name;
                    objectArray[0x5D734A63 ^ 0x5D734A62] = this.mixin;
                    objectArray[0xF483CF75 ^ 0xF483CF77] = fieldNode2.name;
                    objectArray[0x8E4339C0 ^ 0x8E4339C3] = fieldNode2.desc;
                    objectArray[0xE27492B9 ^ 0xE27492BD] = mixinTargetContext.getTarget();
                    throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("T\ua7ef\ua4b0\ua07d\ua901\u7d36\u8e49\u2475\u8b39\u3471~\ua7ef\ua4b6\ua065\ua949\u7d36\u8e6a\u244f\u8b39\u347ec\ua7f3\ua4b0\ua031\ua903\u7d7f\u8e4f\u2476\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e45\u246c\u8b32\u3465e\ua7f4\ua4bc\ua065\ua900\u7d36\u8e0f\u2469\u8b72\u34642\ua7ef\ua4bb\ua031\ua940\u7d65"), objectArray));
                }
                Object[] objectArray = new Object[0x4287D839 ^ 0x4287D83A];
                objectArray[0xFF263E3E ^ 0xFF263E3E] = fieldNode.name;
                objectArray[0x67292153 ^ 0x67292152] = this.mixin;
                objectArray[0x352F22E ^ 0x352F22C] = mixinTargetContext.getTarget();
                logger.warn(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7c6\ua480\ua07f\ua90c\u7d67\u8e5f\u247f\u8b77\u3467g\ua7e4\ua4b9\ua078\ua906\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a2\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u347ef\ua7a6\ua4b4\ua07d\ua917\u7d73\u8e4b\u247e\u8b2e\u3437w\ua7fe\ua4bc\ua062\ua911\u7d65\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4fb\ua031\ua92b\u7d79\u8e5e\u247f\u8b77\u3463z\ua7e7\ua4a1\ua031\ua901\u7d73\u8e49\u2476\u8b36\u3465w\ua7e2\ua4f5\ua057\ua92c\u7d53\u8e66\u245e\u8b77\u345e\\\ua7cf\ua481\ua058\ua924\u7d5a\u8e63\u2449\u8b12\u3445A\ua7a6\ua4a2\ua078\ua909\u7d7a\u8e0a\u2454\u8b18\u34432\ua7e4\ua4b0\ua031\ua917\u7d73\u8e47\u2475\u8b21\u3472v\ua7a7"), objectArray);
                iterator.remove();
                continue;
            }
            if (!fieldNode2.desc.equals(fieldNode.desc)) {
                Object[] objectArray = new Object[0x6DB4AF63 ^ 0x6DB4AF62];
                objectArray[0xEA33E022 ^ 0xEA33E022] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("F\ua7ee\ua4b0\ua031\ua903\u7d7f\u8e4f\u2476\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e5e\u2472\u8b32\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4f5\ua079\ua904\u7d65\u8e0a\u247b\u8b77\u3474}\ua7e8\ua4b3\ua07d\ua90c\u7d75\u8e5e\u2473\u8b39\u34702\ua7f5\ua4bc\ua076\ua90b\u7d77\u8e5e\u246f\u8b25\u3472"), objectArray));
            }
            if (!fieldNode2.name.equals(fieldNode.name)) {
                if ((fieldNode2.access & (0x15057689 ^ 0x1505768B)) == 0) {
                    if ((fieldNode2.access & (0x4F34CB37 ^ 0x4F34DB37)) == 0) {
                        throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\\\ua7e9\ua4bb\ua03c\ua915\u7d64\u8e43\u246c\u8b36\u3463w\ua7a6\ua4b3\ua078\ua900\u7d7a\u8e4e\u243a\u8b34\u3476|\ua7e8\ua4ba\ua065\ua945\u7d74\u8e4f\u243a\u8b36\u347b{\ua7e7\ua4a6\ua074\ua901\u7d38\u8e0a\u245c\u8b38\u3462|\ua7e2\ua4f5") + fieldNode2.name);
                    }
                }
                fieldNode.name = field.renameTo(fieldNode2.name);
            }
            iterator.remove();
            if (n == 0) continue;
            boolean bl = field.isDecoratedFinal();
            if (this.verboseLogging) {
                if (Bytecode.hasFlag(fieldNode2, 0xEE9E0045 ^ 0xEE9E0055) != bl) {
                    String string = bl ? \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua91e\u7d6b\u8e10\u2420\u8b2c\u346a2\ua7ef\ua4a6\ua031\ua901\u7d73\u8e49\u2475\u8b25\u3476f\ua7e3\ua4b1\ua031\ua912\u7d7f\u8e5e\u2472\u8b77\u3457T\ua7ef\ua4bb\ua070\ua909\u7d36\u8e48\u246f\u8b23\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2473\u8b24\u3437|\ua7e9\ua4a1\ua031\ua903\u7d7f\u8e44\u247b\u8b3b") : \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b23\u3476`\ua7e1\ua4b0\ua065\ua945\u7d6d\u8e57\u2420\u8b6d\u346co\ua7a6\ua4bc\ua062\ua945\u7d70\u8e43\u2474\u8b36\u347b2\ua7e4\ua4a0\ua065\ua945\u7d65\u8e42\u247b\u8b33\u3478e\ua7a6\ua4bc\ua062\ua945\u7d78\u8e45\u246e\u8b77\u3473w\ua7e5\ua4ba\ua063\ua904\u7d62\u8e4f\u247e\u8b77\u3460{\ua7f2\ua4bd\ua031\ua925\u7d50\u8e43\u2474\u8b36\u347b");
                    Object[] objectArray = new Object[0xCB12DEA1 ^ 0xCB12DEA3];
                    objectArray[0xE8FCAA9A ^ 0xE8FCAA9A] = this.mixin;
                    objectArray[0x52B2ED15 ^ 0x52B2ED14] = fieldNode.name;
                    logger.warn(string, objectArray);
                }
            }
            mixinTargetContext.addShadowField(fieldNode, field);
        }
    }

    protected boolean validateField(MixinTargetContext mixinTargetContext, FieldNode fieldNode, AnnotationNode annotationNode) {
        String string;
        if (Bytecode.hasFlag(fieldNode, 0x55695427 ^ 0x5569542F)) {
            if (!Bytecode.hasFlag(fieldNode, 0xD0DEA4B4 ^ 0xD0DEA4B6)) {
                if (!Bytecode.hasFlag(fieldNode, 0xCF28F691 ^ 0xCF28E691) && annotationNode == null) {
                    Object[] objectArray = new Object[0x53337246 ^ 0x53337245];
                    objectArray[0x8705C265 ^ 0x8705C265] = mixinTargetContext;
                    objectArray[0xD0A861A8 ^ 0xD0A861A9] = fieldNode.name;
                    objectArray[0xCE99A98 ^ 0xCE99A9A] = fieldNode.desc;
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474}\ua7e8\ua4a1\ua070\ua90c\u7d78\u8e59\u243a\u8b39\u3478|\ua7ab\ua4a5\ua063\ua90c\u7d60\u8e4b\u246e\u8b32\u3437a\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d2c\u8e0f\u2469"), objectArray));
                }
            }
        }
        if (fieldNode.name.startsWith(string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("b\ua7f4\ua4b0\ua077\ua90c\u7d6e"), Shadow.class))) {
            Object[] objectArray = new Object[0x6CD92FA ^ 0x6CD92F8];
            objectArray[0x5D63A543 ^ 0x5D63A543] = mixinTargetContext;
            objectArray[0xF965766A ^ 0xF965766B] = fieldNode.name;
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua940\u7d65\u8e04\u243f\u8b24\u3437z\ua7e7\ua4a6\ua031\ua904\u7d36\u8e59\u2472\u8b36\u3473}\ua7f1\ua4f5\ua061\ua917\u7d73\u8e4c\u2473\u8b2f\u34392\ua7d2\ua4bd\ua078\ua916\u7d36\u8e43\u2469\u8b77\u3479}\ua7f2\ua4f5\ua070\ua909\u7d7a\u8e45\u246d\u8b32\u3473<"), objectArray));
        }
        if (\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("a\ua7f3\ua4a5\ua074\ua917\u7d32").equals(fieldNode.name)) {
            if (fieldNode.access != (0x59628C4C ^ 0x59628C4E)) {
                Object[] objectArray = new Object[0xEADCE159 ^ 0xEADCE15B];
                objectArray[0xB9858040 ^ 0xB9858040] = mixinTargetContext;
                objectArray[0x6513889C ^ 0x6513889D] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7eb\ua4b4\ua076\ua90c\u7d78\u8e4b\u2468\u8b2e\u3437a\ua7f3\ua4a5\ua074\ua917\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4f0\ua062\ua94b\u7d33\u8e59\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua073\ua900\u7d36\u8e5a\u2468\u8b3e\u3461s\ua7f2\ua4b0\ua031\ua904\u7d78\u8e4e\u243a\u8b39\u3478|\ua7ab\ua4b3\ua078\ua90b\u7d77\u8e46"), objectArray));
            }
            if (!fieldNode.desc.equals(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("^") + this.mixin.getClassRef() + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(")"))) {
                Object[] objectArray = new Object[0xFDF089CB ^ 0xFDF089C8];
                objectArray[0xFE078985 ^ 0xFE078985] = mixinTargetContext;
                objectArray[0x6F4785D4 ^ 0x6F4785D5] = fieldNode.name;
                objectArray[0x438EBFBE ^ 0x438EBFBC] = this.mixin.getClassName();
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7eb\ua4b4\ua076\ua90c\u7d78\u8e4b\u2468\u8b2e\u3437a\ua7f3\ua4a5\ua074\ua917\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4f0\ua062\ua94b\u7d33\u8e59\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua079\ua904\u7d60\u8e4f\u243a\u8b23\u347fw\ua7a6\ua4a6\ua070\ua908\u7d73\u8e0a\u246e\u8b2e\u3467w\ua7a6\ua4b4\ua062\ua945\u7d62\u8e42\u247f\u8b77\u3467s\ua7f4\ua4b0\ua07f\ua911\u7d36\u8e47\u2473\u8b2f\u347e|\ua7a6\ua4fd\ua034\ua916\u7d3f"), objectArray));
            }
            return (0x267F9D68 ^ 0x267F9D68) != 0;
        }
        return (0xC324ECE0 ^ 0xC324ECE1) != 0;
    }

    protected void transform(MixinTargetContext mixinTargetContext) {
        for (MethodNode methodNode : this.classNode.methods) {
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (abstractInsnNode instanceof MethodInsnNode) {
                    this.transformMethod((MethodInsnNode)abstractInsnNode);
                    continue;
                }
                if (!(abstractInsnNode instanceof FieldInsnNode)) continue;
                this.transformField((FieldInsnNode)abstractInsnNode);
            }
        }
    }

    protected void transformMethod(MethodInsnNode methodInsnNode) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\u007f\ua7e3\ua4a1\ua070"));
        ClassInfo classInfo = ClassInfo.forName(methodInsnNode.owner);
        if (classInfo == null) {
            throw new RuntimeException(new ClassNotFoundException(methodInsnNode.owner.replace((char)(0x19221310 ^ 0x1922133F), (char)(0xF7AD6158 ^ 0xF7AD6176))));
        }
        ClassInfo.Method method = classInfo.findMethodInHierarchy(methodInsnNode, ClassInfo.SearchType.ALL_CLASSES, 0xE6FBAD6 ^ 0xE6FBAD4);
        section.end();
        if (method != null && method.isRenamed()) {
            methodInsnNode.name = method.getName();
        }
    }

    protected void transformField(FieldInsnNode fieldInsnNode) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\u007f\ua7e3\ua4a1\ua070"));
        ClassInfo classInfo = ClassInfo.forName(fieldInsnNode.owner);
        if (classInfo == null) {
            throw new RuntimeException(new ClassNotFoundException(fieldInsnNode.owner.replace((char)(0x3CC52AE2 ^ 0x3CC52ACD), (char)(0xF9B4CC48 ^ 0xF9B4CC66))));
        }
        ClassInfo.Field field = classInfo.findField(fieldInsnNode, 0x52598B04 ^ 0x52598B06);
        section.end();
        if (field != null && field.isRenamed()) {
            fieldInsnNode.name = field.getName();
        }
    }

    protected static String getDynamicInfo(MethodNode methodNode) {
        return MixinPreProcessorStandard.getDynamicInfo(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("_\ua7e3\ua4a1\ua079\ua90a\u7d72"), Annotations.getInvisible(methodNode, Dynamic.class));
    }

    protected static String getDynamicInfo(FieldNode fieldNode) {
        return MixinPreProcessorStandard.getDynamicInfo(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("T\ua7ef\ua4b0\ua07d\ua901"), Annotations.getInvisible(fieldNode, Dynamic.class));
    }

    private static String getDynamicInfo(String string, AnnotationNode annotationNode) {
        String string2;
        String string3 = Strings.nullToEmpty((String)((String)Annotations.getValue(annotationNode)));
        Type type = (Type)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        if (type != null) {
            Object[] objectArray = new Object[0xA2CC6AA0 ^ 0xA2CC6AA2];
            objectArray[0x809C3A89 ^ 0x809C3A89] = type.getClassName();
            objectArray[0x8CF8C1E6 ^ 0x8CF8C1E7] = string3;
            string3 = String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("i\ua7a3\ua4a6\ua06c\ua945\u7d33\u8e59"), objectArray).trim();
        }
        if (string3.length() > 0) {
            Object[] objectArray = new Object[0x4A697094 ^ 0x4A697096];
            objectArray[0xCBAE5C7F ^ 0xCBAE5C7F] = string;
            objectArray[0x9EC05212 ^ 0x9EC05213] = string3;
            string2 = String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7a3\ua4a6\ua031\ua90c\u7d65\u8e0a\u245a\u8b13\u346e|\ua7e7\ua4b8\ua078\ua906\u7d3e\u8e0f\u2469\u8b7e"), objectArray);
        } else {
            string2 = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("");
        }
        return string2;
    }

    static final class SpecialMethod
    extends Enum<SpecialMethod> {
        public static final /* enum */ SpecialMethod MERGE = new SpecialMethod((0xA4F2A6E3 ^ 0xA4F2A6E2) != 0);
        public static final /* enum */ SpecialMethod OVERWRITE = new SpecialMethod((0xC9668D61 ^ 0xC9668D60) != 0, Overwrite.class);
        public static final /* enum */ SpecialMethod SHADOW = new SpecialMethod((0xA3A0D054 ^ 0xA3A0D054) != 0, Shadow.class);
        public static final /* enum */ SpecialMethod ACCESSOR = new SpecialMethod((0xD3FAEB2F ^ 0xD3FAEB2F) != 0, Accessor.class);
        public static final /* enum */ SpecialMethod INVOKER = new SpecialMethod((0x30E83C93 ^ 0x30E83C93) != 0, Invoker.class);
        final boolean isOverwrite;
        final Class<? extends Annotation> annotation;
        final String description;
        private static final /* synthetic */ SpecialMethod[] $VALUES;

        public static SpecialMethod[] values() {
            return (SpecialMethod[])$VALUES.clone();
        }

        public static SpecialMethod valueOf(String string) {
            return Enum.valueOf(SpecialMethod.class, string);
        }

        private SpecialMethod(boolean bl, Class<? extends Annotation> clazz) {
            this.isOverwrite = bl;
            this.annotation = clazz;
            this.description = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("R") + Bytecode.getSimpleName(clazz);
        }

        private SpecialMethod(boolean bl) {
            this.isOverwrite = bl;
            this.annotation = null;
            this.description = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("}\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32");
        }

        public String toString() {
            return this.description;
        }

        static {
            SpecialMethod[] specialMethodArray = new SpecialMethod[0xF641D3A ^ 0xF641D3F];
            specialMethodArray[0x523512C3 ^ 0x523512C3] = MERGE;
            specialMethodArray[0x3E39479E ^ 0x3E39479F] = OVERWRITE;
            specialMethodArray[0xD3413EB9 ^ 0xD3413EBB] = SHADOW;
            specialMethodArray[0x38E19A89 ^ 0x38E19A8A] = ACCESSOR;
            specialMethodArray[0xD02EFCEC ^ 0xD02EFCE8] = INVOKER;
            $VALUES = specialMethodArray;
        }
    }
}

