/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Joiner;
import com.google.common.primitives.Ints;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.IntInsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.lib.util.CheckClassAdapter;
import org.spongepowered.asm.lib.util.TraceClassVisitor;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.util.Constants;
import org.spongepowered.asm.util.throwables.SyntheticBridgeException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2;

public final class Bytecode {
    public static final int[] CONSTANTS_INT;
    public static final int[] CONSTANTS_FLOAT;
    public static final int[] CONSTANTS_DOUBLE;
    public static final int[] CONSTANTS_LONG;
    public static final int[] CONSTANTS_ALL;
    private static final Object[] CONSTANTS_VALUES;
    private static final String[] CONSTANTS_TYPES;
    private static final String[] BOXING_TYPES;
    private static final String[] UNBOXING_METHODS;
    private static final Class<?>[] MERGEABLE_MIXIN_ANNOTATIONS;
    private static Pattern mergeableAnnotationPattern;
    private static final Logger logger;

    private Bytecode() {
    }

    public static MethodNode findMethod(ClassNode classNode, String string, String string2) {
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(string) || !methodNode.desc.equals(string2)) continue;
            return methodNode;
        }
        return null;
    }

    public static AbstractInsnNode findInsn(MethodNode methodNode, int n) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode.getOpcode() != n) continue;
            return abstractInsnNode;
        }
        return null;
    }

    public static MethodInsnNode findSuperInit(MethodNode methodNode, String string) {
        if (!\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name)) {
            return null;
        }
        int n = 0x9235D618 ^ 0x9235D618;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode instanceof TypeInsnNode) {
                if (abstractInsnNode.getOpcode() == (0x3AF518AF ^ 0x3AF51814)) {
                    ++n;
                    continue;
                }
            }
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            if (abstractInsnNode.getOpcode() != (0x931418F9 ^ 0x9314184E)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodInsnNode.name)) continue;
            if (n > 0) {
                --n;
                continue;
            }
            if (!methodInsnNode.owner.equals(string)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public static void textify(ClassNode classNode, OutputStream outputStream) {
        classNode.accept(new TraceClassVisitor(new PrintWriter(outputStream)));
    }

    public static void textify(MethodNode methodNode, OutputStream outputStream) {
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(new PrintWriter(outputStream));
        MethodVisitor methodVisitor = traceClassVisitor.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0x8B4C295E ^ 0x8B4C295E]));
        methodNode.accept(methodVisitor);
        traceClassVisitor.visitEnd();
    }

    public static void dumpClass(ClassNode classNode) {
        ClassWriter classWriter = new ClassWriter(0x36DAF5B2 ^ 0x36DAF5B1);
        classNode.accept(classWriter);
        Bytecode.dumpClass(classWriter.toByteArray());
    }

    public static void dumpClass(byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        CheckClassAdapter.verify(classReader, (0x2CF52034 ^ 0x2CF52035) != 0, new PrintWriter(System.out));
    }

    public static void printMethodWithOpcodeIndices(MethodNode methodNode) {
        Object[] objectArray = new Object[0xF980BC5 ^ 0xF980BC7];
        objectArray[0x90129C91 ^ 0x90129C91] = methodNode.name;
        objectArray[0x1E11E53D ^ 0x1E11E53C] = methodNode.desc;
        System.err.printf(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4f0\ua062\ua96f"), objectArray);
        int n = 0x63CEEC3B ^ 0x63CEEC3B;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            Object[] objectArray2 = new Object[0x9ED26958 ^ 0x9ED2695A];
            objectArray2[0x536DA893 ^ 0x536DA893] = n++;
            objectArray2[0x43A720A3 ^ 0x43A720A2] = Bytecode.describeNode((AbstractInsnNode)listIterator.next());
            System.err.printf(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("I\ua7a3\ua4e1\ua075\ua938\u7d36\u8e0f\u2469\u8b5d"), objectArray2);
        }
    }

    public static void printMethod(MethodNode methodNode) {
        Object[] objectArray = new Object[0x652E7E8F ^ 0x652E7E8D];
        objectArray[0x257F4744 ^ 0x257F4744] = methodNode.name;
        objectArray[0xEEEDD7E9 ^ 0xEEEDD7E8] = methodNode.desc;
        System.err.printf(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4f0\ua062\ua96f"), objectArray);
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            System.err.print(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7a6"));
            Bytecode.printNode((AbstractInsnNode)listIterator.next());
        }
    }

    public static void printNode(AbstractInsnNode abstractInsnNode) {
        Object[] objectArray = new Object[0x77307A27 ^ 0x77307A26];
        objectArray[0x80D13EB8 ^ 0x80D13EB8] = Bytecode.describeNode(abstractInsnNode);
        System.err.printf(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("7\ua7f5\ua4df"), objectArray);
    }

    public static String describeNode(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            Object[] objectArray = new Object[0x404597F5 ^ 0x404597F4];
            objectArray[0x8D85C039 ^ 0x8D85C039] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("|\ua7f3\ua4b9\ua07d");
            return String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7a6\ua4f5\ua034\ua948\u7d27\u8e1e\u2469\u8b77"), objectArray);
        }
        if (abstractInsnNode instanceof LabelNode) {
            Object[] objectArray = new Object[0xF45AF5C4 ^ 0xF45AF5C5];
            objectArray[0xCF5BC8E4 ^ 0xCF5BC8E4] = ((LabelNode)abstractInsnNode).getLabel();
            return String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("I\ua7a3\ua4a6\ua04c"), objectArray);
        }
        Object[] objectArray = new Object[0x4051DE9F ^ 0x4051DE9E];
        objectArray[0x6028C526 ^ 0x6028C526] = abstractInsnNode.getClass().getSimpleName().replace(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\\\ua7e9\ua4b1\ua074"), \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(""));
        String string = String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7a6\ua4f5\ua034\ua948\u7d27\u8e1e\u2469\u8b77"), objectArray);
        if (abstractInsnNode instanceof JumpInsnNode) {
            Object[] objectArray2 = new Object[0xBFE019FD ^ 0xBFE019FF];
            objectArray2[0x44D67F07 ^ 0x44D67F07] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray2[0x58C61286 ^ 0x58C61287] = ((JumpInsnNode)abstractInsnNode).label.getLabel();
            string = string + String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("I\ua7a3\ua4a6\ua04c\ua945\u7d4d\u8e0f\u2469\u8b0a"), objectArray2);
        } else if (abstractInsnNode instanceof VarInsnNode) {
            Object[] objectArray3 = new Object[0xD9439DEC ^ 0xD9439DEE];
            objectArray3[0x55B6BA07 ^ 0x55B6BA07] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray3[0xA653887F ^ 0xA653887E] = ((VarInsnNode)abstractInsnNode).var;
            string = string + String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e4e"), objectArray3);
        } else if (abstractInsnNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            Object[] objectArray4 = new Object[0x7D0FDC08 ^ 0x7D0FDC0C];
            objectArray4[0x17F36691 ^ 0x17F36691] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray4[0xB8ECB984 ^ 0xB8ECB985] = methodInsnNode.owner;
            objectArray4[0x8EE4F345 ^ 0x8EE4F347] = methodInsnNode.name;
            objectArray4[0x8DCBF5C1 ^ 0x8DCBF5C2] = methodInsnNode.desc;
            string = string + String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e59\u243a\u8b72\u34642\ua7a3\ua4a6"), objectArray4);
        } else if (abstractInsnNode instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
            Object[] objectArray5 = new Object[0xE1254C5 ^ 0xE1254C1];
            objectArray5[0x4A89C743 ^ 0x4A89C743] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray5[0xAF651515 ^ 0xAF651514] = fieldInsnNode.owner;
            objectArray5[0xCCF42E51 ^ 0xCCF42E53] = fieldInsnNode.name;
            objectArray5[0x9E5478AC ^ 0x9E5478AF] = fieldInsnNode.desc;
            string = string + String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e59\u243a\u8b72\u34642\ua7a3\ua4a6"), objectArray5);
        } else if (abstractInsnNode instanceof LineNumberNode) {
            LineNumberNode lineNumberNode = (LineNumberNode)abstractInsnNode;
            Object[] objectArray6 = new Object[0xA71E683E ^ 0xA71E683C];
            objectArray6[0x8C07C245 ^ 0x8C07C245] = lineNumberNode.line;
            objectArray6[0xC05508D1 ^ 0xC05508D0] = lineNumberNode.start.getLabel();
            string = string + String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("^\ua7cf\ua49b\ua054\ua958\u7d4d\u8e0f\u247e\u8b0a\u3437^\ua7c7\ua497\ua054\ua929\u7d2b\u8e71\u243f\u8b24\u344a"), objectArray6);
        } else if (abstractInsnNode instanceof LdcInsnNode) {
            string = string + ((LdcInsnNode)abstractInsnNode).cst;
        } else if (abstractInsnNode instanceof IntInsnNode) {
            string = string + ((IntInsnNode)abstractInsnNode).operand;
        } else if (abstractInsnNode instanceof FrameNode) {
            Object[] objectArray7 = new Object[0x44A06C05 ^ 0x44A06C04];
            objectArray7[0x3ED22292 ^ 0x3ED22292] = Bytecode.getOpcodeName(((FrameNode)abstractInsnNode).type, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("Z\ua7d9\ua49c\ua05f\ua933\u7d59\u8e61\u245f\u8b1e\u3459F\ua7c3\ua487\ua057\ua924\u7d55\u8e6f"), 0xEB7DBD79 ^ 0x14824286);
            string = string + String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("I\ua7a3\ua4a6\ua04c\ua945"), objectArray7);
        } else {
            Object[] objectArray8 = new Object[0x4E065E65 ^ 0x4E065E64];
            objectArray8[0xCA49F64 ^ 0xCA49F64] = Bytecode.getOpcodeName(abstractInsnNode);
            string = string + String.format(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("I\ua7a3\ua4a6\ua04c\ua945"), objectArray8);
        }
        return string;
    }

    public static String getOpcodeName(AbstractInsnNode abstractInsnNode) {
        return abstractInsnNode != null ? Bytecode.getOpcodeName(abstractInsnNode.getOpcode()) : \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("");
    }

    public static String getOpcodeName(int n) {
        return Bytecode.getOpcodeName(n, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("G\ua7c8\ua49c\ua05f\ua92c\u7d42\u8e63\u245b\u8b1b\u345eH\ua7c3\ua491\ua04e\ua931\u7d5e\u8e63\u2449"), 0x4919FF4A ^ 0x4919FF4B);
    }

    private static String getOpcodeName(int n, String string, int n2) {
        if (n >= n2) {
            int n3 = 0x56853A84 ^ 0x56853A84;
            try {
                Field[] fieldArray = Opcodes.class.getDeclaredFields();
                int n4 = fieldArray.length;
                for (int i = 0x1D476EF7 ^ 0x1D476EF7; i < n4; ++i) {
                    Field field = fieldArray[i];
                    if (n3 == 0 && !field.getName().equals(string)) continue;
                    n3 = 0x2D64DE8A ^ 0x2D64DE8B;
                    if (field.getType() != Integer.TYPE || field.getInt(null) != n) continue;
                    return field.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n >= 0 ? String.valueOf(n) : \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("G\ua7c8\ua49e\ua05f\ua92a\u7d41\u8e64");
    }

    public static boolean methodHasLineNumbers(MethodNode methodNode) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            if (!(listIterator.next() instanceof LineNumberNode)) continue;
            return (0x7C34F71F ^ 0x7C34F71E) != 0;
        }
        return (0xBE05FF71 ^ 0xBE05FF71) != 0;
    }

    public static boolean methodIsStatic(MethodNode methodNode) {
        return ((methodNode.access & (0x4F582A88 ^ 0x4F582A80)) == (0x956133D ^ 0x9561335) ? 0x805DBF2D ^ 0x805DBF2C : 0x9AAE2849 ^ 0x9AAE2849) != 0;
    }

    public static boolean fieldIsStatic(FieldNode fieldNode) {
        return ((fieldNode.access & (0xBCA6C3CE ^ 0xBCA6C3C6)) == (0x6CB98F4B ^ 0x6CB98F43) ? 0x57BEEDFF ^ 0x57BEEDFE : 0x850E6C1B ^ 0x850E6C1B) != 0;
    }

    public static int getFirstNonArgLocalIndex(MethodNode methodNode) {
        return Bytecode.getFirstNonArgLocalIndex(Type.getArgumentTypes(methodNode.desc), ((methodNode.access & (0x6DE10197 ^ 0x6DE1019F)) == 0 ? 0xDC0DC48F ^ 0xDC0DC48E : 0xD9566F61 ^ 0xD9566F61) != 0);
    }

    public static int getFirstNonArgLocalIndex(Type[] typeArray, boolean bl) {
        return Bytecode.getArgsSize(typeArray) + (bl ? 0x5DA75FBF ^ 0x5DA75FBE : 0x589F918F ^ 0x589F918F);
    }

    public static int getArgsSize(Type[] typeArray) {
        int n = 0xCC89AB93 ^ 0xCC89AB93;
        Type[] typeArray2 = typeArray;
        int n2 = typeArray2.length;
        for (int i = 0xEDF0DAE5 ^ 0xEDF0DAE5; i < n2; ++i) {
            Type type = typeArray2[i];
            n += type.getSize();
        }
        return n;
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n) {
        Bytecode.loadArgs(typeArray, insnList, n, 0xD3769F08 ^ 0x2C8960F7);
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n, int n2) {
        Bytecode.loadArgs(typeArray, insnList, n, n2, null);
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n, int n2, Type[] typeArray2) {
        int n3 = n;
        int n4 = 0xB815C4FE ^ 0xB815C4FE;
        Type[] typeArray3 = typeArray;
        int n5 = typeArray3.length;
        for (int i = 0x52633D9F ^ 0x52633D9F; i < n5; ++i) {
            Type type = typeArray3[i];
            insnList.add(new VarInsnNode(type.getOpcode(0x3FEDF8BB ^ 0x3FEDF8AE), n3));
            if (typeArray2 != null && n4 < typeArray2.length && typeArray2[n4] != null) {
                insnList.add(new TypeInsnNode(0xA715E230 ^ 0xA715E2F0, typeArray2[n4].getInternalName()));
            }
            if (n2 >= n && (n3 += type.getSize()) >= n2) {
                return;
            }
            ++n4;
        }
    }

    public static Map<LabelNode, LabelNode> cloneLabels(InsnList insnList) {
        HashMap<LabelNode, LabelNode> hashMap = new HashMap<LabelNode, LabelNode>();
        ListIterator<AbstractInsnNode> listIterator = insnList.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof LabelNode)) continue;
            hashMap.put((LabelNode)abstractInsnNode, new LabelNode(((LabelNode)abstractInsnNode).getLabel()));
        }
        return hashMap;
    }

    public static String generateDescriptor(Object object, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder().append((char)(0x56B5DAF8 ^ 0x56B5DAD0));
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0x4375246E ^ 0x4375246E; i < n; ++i) {
            Object object2 = objectArray2[i];
            stringBuilder.append(Bytecode.toDescriptor(object2));
        }
        return stringBuilder.append((char)(0xDA38C51D ^ 0xDA38C534)).append(object != null ? Bytecode.toDescriptor(object) : \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("D")).toString();
    }

    private static String toDescriptor(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Type) {
            return object.toString();
        }
        if (object instanceof Class) {
            return Type.getDescriptor((Class)object);
        }
        return object == null ? \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("") : object.toString();
    }

    public static String getDescriptor(Type[] typeArray) {
        return \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(":") + Joiner.on((String)\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("")).join((Object[])typeArray) + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(";");
    }

    public static String getDescriptor(Type[] typeArray, Type type) {
        return Bytecode.getDescriptor(typeArray) + type.toString();
    }

    public static String changeDescriptorReturnType(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        return string.substring(0x7CC15795 ^ 0x7CC15795, string.lastIndexOf(0x73F3883A ^ 0x73F38813) + (0x84E85023 ^ 0x84E85022)) + string2;
    }

    public static String getSimpleName(Class<? extends Annotation> clazz) {
        return clazz.getSimpleName();
    }

    public static String getSimpleName(AnnotationNode annotationNode) {
        return Bytecode.getSimpleName(annotationNode.desc);
    }

    public static String getSimpleName(String string) {
        int n = Math.max(string.lastIndexOf(0xC205FDE6 ^ 0xC205FDC9), 0x2DFFAECD ^ 0x2DFFAECD);
        return string.substring(n + (0x128975A0 ^ 0x128975A1)).replace(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(")"), \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(""));
    }

    public static boolean isConstant(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            return (0x81D18B6E ^ 0x81D18B6E) != 0;
        }
        return Ints.contains((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
    }

    public static Object getConstant(AbstractInsnNode abstractInsnNode) {
        block5: {
            block7: {
                int n;
                block6: {
                    if (abstractInsnNode == null) {
                        return null;
                    }
                    if (abstractInsnNode instanceof LdcInsnNode) {
                        return ((LdcInsnNode)abstractInsnNode).cst;
                    }
                    if (!(abstractInsnNode instanceof IntInsnNode)) break block5;
                    n = ((IntInsnNode)abstractInsnNode).operand;
                    if (abstractInsnNode.getOpcode() == (0x2912C27E ^ 0x2912C26E)) break block6;
                    if (abstractInsnNode.getOpcode() != (0x677106E6 ^ 0x677106F7)) break block7;
                }
                return n;
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7e8\ua4a1\ua058\ua90b\u7d65\u8e44\u2454\u8b38\u3473w\ua7a6\ua4a2\ua078\ua911\u7d7e\u8e0a\u2473\u8b39\u3461s\ua7ea\ua4bc\ua075\ua945\u7d79\u8e5a\u2479\u8b38\u3473w\ua7a6") + abstractInsnNode.getOpcode() + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ef\ua4bb\ua031\ua902\u7d73\u8e5e\u2459\u8b38\u3479a\ua7f2\ua4b4\ua07f\ua911"));
        }
        int n = Ints.indexOf((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
        return n < 0 ? null : CONSTANTS_VALUES[n];
    }

    public static Type getConstantType(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            return null;
        }
        if (abstractInsnNode instanceof LdcInsnNode) {
            Object object = ((LdcInsnNode)abstractInsnNode).cst;
            if (object instanceof Integer) {
                return Type.getType(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("["));
            }
            if (object instanceof Float) {
                return Type.getType(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("T"));
            }
            if (object instanceof Long) {
                return Type.getType(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("X"));
            }
            if (object instanceof Double) {
                return Type.getType(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("V"));
            }
            if (object instanceof String) {
                return Type.getType(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("^\ua7ec\ua4b4\ua067\ua904\u7d39\u8e46\u247b\u8b39\u3470=\ua7d5\ua4a1\ua063\ua90c\u7d78\u8e4d\u2421"));
            }
            if (object instanceof Type) {
                return Type.getType(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("^\ua7ec\ua4b4\ua067\ua904\u7d39\u8e46\u247b\u8b39\u3470=\ua7c5\ua4b9\ua070\ua916\u7d65\u8e11"));
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("^\ua7e2\ua4b6\ua058\ua90b\u7d65\u8e44\u2454\u8b38\u3473w\ua7a6\ua4a2\ua078\ua911\u7d7e\u8e0a\u2473\u8b39\u3461s\ua7ea\ua4bc\ua075\ua945\u7d66\u8e4b\u2463\u8b3b\u3478s\ua7e2\ua4f5\ua065\ua91c\u7d66\u8e4f\u243a") + object.getClass() + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ef\ua4bb\ua031\ua902\u7d73\u8e5e\u2459\u8b38\u3479a\ua7f2\ua4b4\ua07f\ua911"));
        }
        int n = Ints.indexOf((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
        return n < 0 ? null : Type.getType(CONSTANTS_TYPES[n]);
    }

    public static boolean hasFlag(ClassNode classNode, int n) {
        return ((classNode.access & n) == n ? 0x2858D0C0 ^ 0x2858D0C1 : 0xD41F803D ^ 0xD41F803D) != 0;
    }

    public static boolean hasFlag(MethodNode methodNode, int n) {
        return ((methodNode.access & n) == n ? 0x9E074A4C ^ 0x9E074A4D : 0x1DBF8CEB ^ 0x1DBF8CEB) != 0;
    }

    public static boolean hasFlag(FieldNode fieldNode, int n) {
        return ((fieldNode.access & n) == n ? 0xDB5C7AF6 ^ 0xDB5C7AF7 : 0xDE7B2767 ^ 0xDE7B2767) != 0;
    }

    public static boolean compareFlags(MethodNode methodNode, MethodNode methodNode2, int n) {
        return (Bytecode.hasFlag(methodNode, n) == Bytecode.hasFlag(methodNode2, n) ? 0x8290B423 ^ 0x8290B422 : 0xE506A8C6 ^ 0xE506A8C6) != 0;
    }

    public static boolean compareFlags(FieldNode fieldNode, FieldNode fieldNode2, int n) {
        return (Bytecode.hasFlag(fieldNode, n) == Bytecode.hasFlag(fieldNode2, n) ? 0x327CBC16 ^ 0x327CBC17 : 0x726EC830 ^ 0x726EC830) != 0;
    }

    public static Visibility getVisibility(MethodNode methodNode) {
        return Bytecode.getVisibility(methodNode.access & (0x68C80AFC ^ 0x68C80AFB));
    }

    public static Visibility getVisibility(FieldNode fieldNode) {
        return Bytecode.getVisibility(fieldNode.access & (0x31335431 ^ 0x31335436));
    }

    private static Visibility getVisibility(int n) {
        if ((n & (0x36A2FC27 ^ 0x36A2FC23)) != 0) {
            return Visibility.PROTECTED;
        }
        if ((n & (0xA6F6336B ^ 0xA6F63369)) != 0) {
            return Visibility.PRIVATE;
        }
        if ((n & (0x5B51018A ^ 0x5B51018B)) != 0) {
            return Visibility.PUBLIC;
        }
        return Visibility.PACKAGE;
    }

    public static void setVisibility(MethodNode methodNode, Visibility visibility) {
        methodNode.access = Bytecode.setVisibility(methodNode.access, visibility.access);
    }

    public static void setVisibility(FieldNode fieldNode, Visibility visibility) {
        fieldNode.access = Bytecode.setVisibility(fieldNode.access, visibility.access);
    }

    public static void setVisibility(MethodNode methodNode, int n) {
        methodNode.access = Bytecode.setVisibility(methodNode.access, n);
    }

    public static void setVisibility(FieldNode fieldNode, int n) {
        fieldNode.access = Bytecode.setVisibility(fieldNode.access, n);
    }

    private static int setVisibility(int n, int n2) {
        return n & (0x16A2CD3A ^ 0xE95D32C2) | n2 & (0x4A0A4578 ^ 0x4A0A457F);
    }

    public static int getMaxLineNumber(ClassNode classNode, int n, int n2) {
        int n3 = 0xB1F00038 ^ 0xB1F00038;
        for (MethodNode methodNode : classNode.methods) {
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (!(abstractInsnNode instanceof LineNumberNode)) continue;
                n3 = Math.max(n3, ((LineNumberNode)abstractInsnNode).line);
            }
        }
        return Math.max(n, n3 + n2);
    }

    public static String getBoxingType(Type type) {
        return type == null ? null : BOXING_TYPES[type.getSort()];
    }

    public static String getUnboxingMethod(Type type) {
        return type == null ? null : UNBOXING_METHODS[type.getSort()];
    }

    public static void mergeAnnotations(ClassNode classNode, ClassNode classNode2) {
        classNode2.visibleAnnotations = Bytecode.mergeAnnotations(classNode.visibleAnnotations, classNode2.visibleAnnotations, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("q\ua7ea\ua4b4\ua062\ua916"), classNode.name);
        classNode2.invisibleAnnotations = Bytecode.mergeAnnotations(classNode.invisibleAnnotations, classNode2.invisibleAnnotations, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("q\ua7ea\ua4b4\ua062\ua916"), classNode.name);
    }

    public static void mergeAnnotations(MethodNode methodNode, MethodNode methodNode2) {
        methodNode2.visibleAnnotations = Bytecode.mergeAnnotations(methodNode.visibleAnnotations, methodNode2.visibleAnnotations, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72"), methodNode.name);
        methodNode2.invisibleAnnotations = Bytecode.mergeAnnotations(methodNode.invisibleAnnotations, methodNode2.invisibleAnnotations, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72"), methodNode.name);
    }

    public static void mergeAnnotations(FieldNode fieldNode, FieldNode fieldNode2) {
        fieldNode2.visibleAnnotations = Bytecode.mergeAnnotations(fieldNode.visibleAnnotations, fieldNode2.visibleAnnotations, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("t\ua7ef\ua4b0\ua07d\ua901"), fieldNode.name);
        fieldNode2.invisibleAnnotations = Bytecode.mergeAnnotations(fieldNode.invisibleAnnotations, fieldNode2.invisibleAnnotations, \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("t\ua7ef\ua4b0\ua07d\ua901"), fieldNode.name);
    }

    private static List<AnnotationNode> mergeAnnotations(List<AnnotationNode> list, List<AnnotationNode> list2, String string, String string2) {
        try {
            if (list == null) {
                return list2;
            }
            if (list2 == null) {
                list2 = new ArrayList<AnnotationNode>();
            }
            for (AnnotationNode annotationNode : list) {
                if (!Bytecode.isMergeableAnnotation(annotationNode)) continue;
                Iterator<AnnotationNode> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().desc.equals(annotationNode.desc)) continue;
                    iterator.remove();
                    break;
                }
                list2.add(annotationNode);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[0xB8F489E8 ^ 0xB8F489EA];
            objectArray[0xC9CF177A ^ 0xC9CF177A] = string;
            objectArray[0xF7F14A5A ^ 0xF7F14A5B] = string2;
            logger.warn(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("W\ua7fe\ua4b6\ua074\ua915\u7d62\u8e43\u2475\u8b39\u3437w\ua7e8\ua4b6\ua07e\ua910\u7d78\u8e5e\u247f\u8b25\u3472v\ua7a6\ua4a2\ua079\ua90c\u7d7a\u8e59\u246e\u8b77\u347aw\ua7f4\ua4b2\ua078\ua90b\u7d71\u8e0a\u247b\u8b39\u3479}\ua7f2\ua4b4\ua065\ua90c\u7d79\u8e44\u2469\u8b77\u3471}\ua7f4\ua4f5\ua06a\ua918\u7d36\u8e51\u2467"), objectArray);
        }
        return list2;
    }

    private static boolean isMergeableAnnotation(AnnotationNode annotationNode) {
        if (annotationNode.desc.startsWith(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("^") + Constants.MIXIN_PACKAGE_REF)) {
            return mergeableAnnotationPattern.matcher(annotationNode.desc).matches();
        }
        return (0xC7AA3F1B ^ 0xC7AA3F1A) != 0;
    }

    private static Pattern getMergeableAnnotationPattern() {
        StringBuilder stringBuilder = new StringBuilder(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("L\ua7ca\ua4fd"));
        for (int i = 0x5CC2CEAD ^ 0x5CC2CEAD; i < MERGEABLE_MIXIN_ANNOTATIONS.length; ++i) {
            if (i > 0) {
                stringBuilder.append((char)(0xBF175A65 ^ 0xBF175A19));
            }
            stringBuilder.append(MERGEABLE_MIXIN_ANNOTATIONS[i].getName().replace((char)(0xC72ED65E ^ 0xC72ED670), (char)(0xF9DFE1FD ^ 0xF9DFE1D2)));
        }
        return Pattern.compile(stringBuilder.append(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(";\ua7bd\ua4f1")).toString());
    }

    public static void compareBridgeMethods(MethodNode methodNode, MethodNode methodNode2) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        ListIterator<AbstractInsnNode> listIterator2 = methodNode2.instructions.iterator();
        int n = 0x511CF0F5 ^ 0x511CF0F5;
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            AbstractInsnNode abstractInsnNode = listIterator.next();
            AbstractInsnNode abstractInsnNode2 = listIterator2.next();
            if (!(abstractInsnNode instanceof LabelNode)) {
                AbstractInsnNode abstractInsnNode3;
                AbstractInsnNode abstractInsnNode4;
                if (abstractInsnNode instanceof MethodInsnNode) {
                    abstractInsnNode4 = (MethodInsnNode)abstractInsnNode;
                    abstractInsnNode3 = (MethodInsnNode)abstractInsnNode2;
                    if (!((MethodInsnNode)abstractInsnNode4).name.equals(abstractInsnNode3.name)) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INVOKE_NAME, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                    if (!((MethodInsnNode)abstractInsnNode4).desc.equals(abstractInsnNode3.desc)) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INVOKE_DESC, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                } else {
                    if (abstractInsnNode.getOpcode() != abstractInsnNode2.getOpcode()) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INSN, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                    if (abstractInsnNode instanceof VarInsnNode) {
                        abstractInsnNode4 = (VarInsnNode)abstractInsnNode;
                        abstractInsnNode3 = (VarInsnNode)abstractInsnNode2;
                        if (((VarInsnNode)abstractInsnNode4).var != ((VarInsnNode)abstractInsnNode3).var) {
                            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_LOAD, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                        }
                    } else if (abstractInsnNode instanceof TypeInsnNode) {
                        abstractInsnNode4 = (TypeInsnNode)abstractInsnNode;
                        abstractInsnNode3 = (TypeInsnNode)abstractInsnNode2;
                        if (abstractInsnNode4.getOpcode() == (0x181512D0 ^ 0x18151210) && !((TypeInsnNode)abstractInsnNode4).desc.equals(((TypeInsnNode)abstractInsnNode3).desc)) {
                            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_CAST, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                        }
                    }
                }
            }
            ++n;
        }
        if (listIterator.hasNext() || listIterator2.hasNext()) {
            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_LENGTH, methodNode.name, methodNode.desc, n, null, null);
        }
    }

    static {
        int[] nArray = new int[0xBF20AA01 ^ 0xBF20AA06];
        nArray[0x68FEDBC8 ^ 0x68FEDBC8] = 0x3C5BD52 ^ 0x3C5BD50;
        nArray[0x4A85DF0C ^ 0x4A85DF0D] = 0xBE313214 ^ 0xBE313217;
        nArray[0x5B65F18E ^ 0x5B65F18C] = 0x7CF9598C ^ 0x7CF95988;
        nArray[0x4153822E ^ 0x4153822D] = 0x8A19FA37 ^ 0x8A19FA32;
        nArray[0xFC5FEB24 ^ 0xFC5FEB20] = 0x6023B9B8 ^ 0x6023B9BE;
        nArray[0xFAB7ACCF ^ 0xFAB7ACCA] = 0x8367B6F6 ^ 0x8367B6F1;
        nArray[0x5A9F60D9 ^ 0x5A9F60DF] = 0x8AC2D75F ^ 0x8AC2D757;
        CONSTANTS_INT = nArray;
        int[] nArray2 = new int[0x7DB04BB0 ^ 0x7DB04BB3];
        nArray2[0x98C3976D ^ 0x98C3976D] = 0x9FA0236F ^ 0x9FA02364;
        nArray2[0x8C6D78D3 ^ 0x8C6D78D2] = 0x74DA06FC ^ 0x74DA06F0;
        nArray2[0xE15CB32 ^ 0xE15CB30] = 0x7049328A ^ 0x70493287;
        CONSTANTS_FLOAT = nArray2;
        int[] nArray3 = new int[0xFF46D0BD ^ 0xFF46D0BF];
        nArray3[0xD9228235 ^ 0xD9228235] = 0x776AA9A5 ^ 0x776AA9AB;
        nArray3[0x7981B916 ^ 0x7981B917] = 0x1E4008D6 ^ 0x1E4008D9;
        CONSTANTS_DOUBLE = nArray3;
        int[] nArray4 = new int[0x1A3A332D ^ 0x1A3A332F];
        nArray4[0x45ADD31D ^ 0x45ADD31D] = 0x67AA6416 ^ 0x67AA641F;
        nArray4[0x9B717542 ^ 0x9B717543] = 0x7671388F ^ 0x76713885;
        CONSTANTS_LONG = nArray4;
        int[] nArray5 = new int[0x4A680FC ^ 0x4A680EE];
        nArray5[0x104F4039 ^ 0x104F4039] = 0xCC0A52EB ^ 0xCC0A52EA;
        nArray5[0x904EF5E1 ^ 0x904EF5E0] = 0x7CEEE744 ^ 0x7CEEE746;
        nArray5[0x80C6F335 ^ 0x80C6F337] = 0x53CE3580 ^ 0x53CE3583;
        nArray5[0x847AF38B ^ 0x847AF388] = 0xD96F476 ^ 0xD96F472;
        nArray5[0x77ABED79 ^ 0x77ABED7D] = 0xDCB9C077 ^ 0xDCB9C072;
        nArray5[0x2C5FD71A ^ 0x2C5FD71F] = 0xEBE964CC ^ 0xEBE964CA;
        nArray5[0x2B69B68 ^ 0x2B69B6E] = 0xEF02156D ^ 0xEF02156A;
        nArray5[0x239EC897 ^ 0x239EC890] = 0x38D6124F ^ 0x38D61247;
        nArray5[0x8FC42CDE ^ 0x8FC42CD6] = 0x420FAD44 ^ 0x420FAD4D;
        nArray5[0x4DA1D1DB ^ 0x4DA1D1D2] = 0x1F2D5A01 ^ 0x1F2D5A0B;
        nArray5[0x3D45E412 ^ 0x3D45E418] = 0xC780A6BC ^ 0xC780A6B7;
        nArray5[0x7723D9D4 ^ 0x7723D9DF] = 0x288A2598 ^ 0x288A2594;
        nArray5[0xCE170FCB ^ 0xCE170FC7] = 0x3C50262 ^ 0x3C5026F;
        nArray5[0xC8DAADCF ^ 0xC8DAADC2] = 0x1A440AED ^ 0x1A440AE3;
        nArray5[0xA443E82 ^ 0xA443E8C] = 0xBD9FAD55 ^ 0xBD9FAD5A;
        nArray5[0xBB331E9F ^ 0xBB331E90] = 0x1BF39C69 ^ 0x1BF39C79;
        nArray5[0xBB2031DF ^ 0xBB2031CF] = 0x6B534994 ^ 0x6B534985;
        nArray5[0xCE5F8A3B ^ 0xCE5F8A2A] = 0x1F3D4B8D ^ 0x1F3D4B9F;
        CONSTANTS_ALL = nArray5;
        Object[] objectArray = new Object[0x98D669B6 ^ 0x98D669B9];
        objectArray[0x7BB4809F ^ 0x7BB4809F] = null;
        objectArray[0xB6626083 ^ 0xB6626082] = 0x6450BFAB ^ 0x9BAF4054;
        objectArray[0xD144DF29 ^ 0xD144DF2B] = 0xDC81A19A ^ 0xDC81A19A;
        objectArray[0xD34AE434 ^ 0xD34AE437] = 0xAA67E863 ^ 0xAA67E862;
        objectArray[0xD29079AA ^ 0xD29079AE] = 0x9678E536 ^ 0x9678E534;
        objectArray[0xD72D0697 ^ 0xD72D0692] = 0xD29C5A06 ^ 0xD29C5A05;
        objectArray[0x609665AD ^ 0x609665AB] = 0x261C0AC6 ^ 0x261C0AC2;
        objectArray[0x7944C1E4 ^ 0x7944C1E3] = 0x45178025 ^ 0x45178020;
        objectArray[0x5EA82047 ^ 0x5EA8204F] = 0xC1897CB8687CE0E7L ^ 0xC1897CB8687CE0E7L;
        objectArray[0x38E78F55 ^ 0x38E78F5C] = 0x4EFCEB3A7D03ACA5L ^ 0x4EFCEB3A7D03ACA4L;
        objectArray[0xAF07456B ^ 0xAF074561] = Float.valueOf(0.0f);
        objectArray[0x5BD4DD85 ^ 0x5BD4DD8E] = Float.valueOf(1.0f);
        objectArray[0x1E8CD0D9 ^ 0x1E8CD0D5] = Float.valueOf(2.0f);
        objectArray[0x8EE556C0 ^ 0x8EE556CD] = 0.0;
        objectArray[0xA6249132 ^ 0xA624913C] = 1.0;
        CONSTANTS_VALUES = objectArray;
        String[] stringArray = new String[0xE18360A2 ^ 0xE18360B3];
        stringArray[0x6C70D7AC ^ 0x6C70D7AC] = null;
        stringArray[0x47FDFA7C ^ 0x47FDFA7D] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[");
        stringArray[0x5A2BE929 ^ 0x5A2BE92B] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[");
        stringArray[0x7D25895D ^ 0x7D25895E] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[");
        stringArray[0xF97B89BB ^ 0xF97B89BF] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[");
        stringArray[0xA363F99E ^ 0xA363F99B] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[");
        stringArray[0x56F77BD2 ^ 0x56F77BD4] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[");
        stringArray[0x84591259 ^ 0x8459125E] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[");
        stringArray[0xA31ECD37 ^ 0xA31ECD3F] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("X");
        stringArray[0x74EF3835 ^ 0x74EF383C] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("X");
        stringArray[0xB9EA415 ^ 0xB9EA41F] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("T");
        stringArray[0xBC5B58BB ^ 0xBC5B58B0] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("T");
        stringArray[0x3A6CD03E ^ 0x3A6CD032] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("T");
        stringArray[0xF7472110 ^ 0xF747211D] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("V");
        stringArray[0x384E5FF ^ 0x384E5F1] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("V");
        stringArray[0x6216CA46 ^ 0x6216CA49] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[");
        stringArray[0xD398CD8A ^ 0xD398CD9A] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[");
        CONSTANTS_TYPES = stringArray;
        String[] stringArray2 = new String[0xD4407C22 ^ 0xD4407C2E];
        stringArray2[0x3BC7573B ^ 0x3BC7573B] = null;
        stringArray2[0xC45F8E32 ^ 0xC45F8E33] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438P\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44");
        stringArray2[0x3388467 ^ 0x3388465] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438Q\ua7ee\ua4b4\ua063\ua904\u7d75\u8e5e\u247f\u8b25");
        stringArray2[0xC032CD12 ^ 0xC032CD11] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438P\ua7ff\ua4a1\ua074");
        stringArray2[0x1A08496C ^ 0x1A084968] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438A\ua7ee\ua4ba\ua063\ua911");
        stringArray2[0xC14AF45D ^ 0xC14AF458] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438[\ua7e8\ua4a1\ua074\ua902\u7d73\u8e58");
        stringArray2[0x8A786556 ^ 0x8A786550] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438T\ua7ea\ua4ba\ua070\ua911");
        stringArray2[0xD4C258D1 ^ 0xD4C258D6] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438^\ua7e9\ua4bb\ua076");
        stringArray2[0x31E396FF ^ 0x31E396F7] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438V\ua7e9\ua4a0\ua073\ua909\u7d73");
        stringArray2[0x41ED909E ^ 0x41ED9097] = null;
        stringArray2[0x15662F0C ^ 0x15662F06] = null;
        stringArray2[0xE5C27282 ^ 0xE5C27289] = null;
        BOXING_TYPES = stringArray2;
        String[] stringArray3 = new String[0xFB5F7035 ^ 0xFB5F7039];
        stringArray3[0xC9C078C2 ^ 0xC9C078C2] = null;
        stringArray3[0x1685FD6 ^ 0x1685FD7] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("p\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44\u244c\u8b36\u347bg\ua7e3");
        stringArray3[0xAA6FA50D ^ 0xAA6FA50F] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("q\ua7ee\ua4b4\ua063\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0xBA499756 ^ 0xBA499755] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("p\ua7ff\ua4a1\ua074\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0xFBBAB12A ^ 0xFBBAB12E] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("a\ua7ee\ua4ba\ua063\ua911\u7d40\u8e4b\u2476\u8b22\u3472");
        stringArray3[0x14C5118C ^ 0x14C51189] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("{\ua7e8\ua4a1\ua047\ua904\u7d7a\u8e5f\u247f");
        stringArray3[0x6C4038AE ^ 0x6C4038A8] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("t\ua7ea\ua4ba\ua070\ua911\u7d40\u8e4b\u2476\u8b22\u3472");
        stringArray3[0xE1245A8B ^ 0xE1245A8C] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("~\ua7e9\ua4bb\ua076\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0x5A59FB3F ^ 0x5A59FB37] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("v\ua7e9\ua4a0\ua073\ua909\u7d73\u8e7c\u247b\u8b3b\u3462w");
        stringArray3[0xCB362A75 ^ 0xCB362A7C] = null;
        stringArray3[0xE67672B9 ^ 0xE67672B3] = null;
        stringArray3[0x1B993501 ^ 0x1B99350A] = null;
        UNBOXING_METHODS = stringArray3;
        Class[] classArray = new Class[0x855661FD ^ 0x855661F9];
        classArray[0x92D2D5DD ^ 0x92D2D5DD] = Overwrite.class;
        classArray[0x6660C0E0 ^ 0x6660C0E1] = Intrinsic.class;
        classArray[0x66740F5 ^ 0x66740F7] = Final.class;
        classArray[0xD167542F ^ 0xD167542C] = Debug.class;
        MERGEABLE_MIXIN_ANNOTATIONS = classArray;
        mergeableAnnotationPattern = Bytecode.getMergeableAnnotationPattern();
        logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    }

    public static final class Visibility
    extends Enum<Visibility> {
        public static final /* enum */ Visibility PRIVATE = new Visibility(0x48AA6BA0 ^ 0x48AA6BA2);
        public static final /* enum */ Visibility PROTECTED = new Visibility(0xAB62286D ^ 0xAB622869);
        public static final /* enum */ Visibility PACKAGE = new Visibility(0x751EFFF6 ^ 0x751EFFF6);
        public static final /* enum */ Visibility PUBLIC = new Visibility(0x828121C3 ^ 0x828121C2);
        static final int MASK = 7;
        final int access;
        private static final /* synthetic */ Visibility[] $VALUES;

        public static Visibility[] values() {
            return (Visibility[])$VALUES.clone();
        }

        public static Visibility valueOf(String string) {
            return Enum.valueOf(Visibility.class, string);
        }

        private Visibility(int n2) {
            this.access = n2;
        }

        static {
            Visibility[] visibilityArray = new Visibility[0x2E66E11A ^ 0x2E66E11E];
            visibilityArray[0x93A7C4CE ^ 0x93A7C4CE] = PRIVATE;
            visibilityArray[0x98B88BB1 ^ 0x98B88BB0] = PROTECTED;
            visibilityArray[0x98E89C53 ^ 0x98E89C51] = PACKAGE;
            visibilityArray[0x7608AB43 ^ 0x7608AB40] = PUBLIC;
            $VALUES = visibilityArray;
        }
    }
}

