/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util.perf;

import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.spongepowered.asm.util.PrettyPrinter;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2;

public final class Profiler {
    public static final int ROOT = 1;
    public static final int FINE = 2;
    private final Map<String, Section> sections = new TreeMap<String, Section>();
    private final List<String> phases = new ArrayList<String>();
    private final Deque<Section> stack = new LinkedList<Section>();
    private boolean active;

    public Profiler() {
        this.phases.add(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46"));
    }

    public void setActive(boolean bl) {
        if (!this.active && bl || !bl) {
            this.reset();
        }
        this.active = bl;
    }

    public void reset() {
        for (Section section : this.sections.values()) {
            section.invalidate();
        }
        this.sections.clear();
        this.phases.clear();
        this.phases.add(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46"));
        this.stack.clear();
    }

    public Section get(String string) {
        Section section = this.sections.get(string);
        if (section == null) {
            section = this.active ? new LiveSection(string, this.phases.size() - (0x6E352BDC ^ 0x6E352BDD)) : new Section(string);
            this.sections.put(string, section);
        }
        return section;
    }

    private Section getSubSection(String string, String string2, Section section) {
        Section section2 = this.sections.get(string);
        if (section2 == null) {
            section2 = new SubSection(string, this.phases.size() - (0xF3B2C42 ^ 0xF3B2C43), string2, section);
            this.sections.put(string, section2);
        }
        return section2;
    }

    boolean isHead(Section section) {
        return (this.stack.peek() == section ? 0x3CB10BE0 ^ 0x3CB10BE1 : 0x39BE09FB ^ 0x39BE09FB) != 0;
    }

    public Section begin(String ... stringArray) {
        return this.begin(0x4C419675 ^ 0x4C419675, stringArray);
    }

    public Section begin(int n, String ... stringArray) {
        return this.begin(n, Joiner.on((char)(0x91922044 ^ 0x9192206A)).join((Object[])stringArray));
    }

    public Section begin(String string) {
        return this.begin(0x1EFAA9EC ^ 0x1EFAA9EC, string);
    }

    public Section begin(int n, String string) {
        int n2 = (n & (0x655937DC ^ 0x655937DD)) != 0 ? 0xC9D3BE5C ^ 0xC9D3BE5D : 0xF7E5EC80 ^ 0xF7E5EC80;
        int n3 = (n & (0xD0EC35E2 ^ 0xD0EC35E0)) != 0 ? 0x4CD38774 ^ 0x4CD38775 : 0xF1596F0F ^ 0xF1596F0F;
        String string2 = string;
        Section section = this.stack.peek();
        if (section != null) {
            string2 = section.getName() + (n2 != 0 ? \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ab\ua4eb\ua031") : \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("<")) + string2;
            if (section.isRoot() && n2 == 0) {
                int n4 = section.getName().lastIndexOf(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7ab\ua4eb\ua031"));
                string = (n4 > (0x8AD0A3B7 ^ 0x752F5C48) ? section.getName().substring(n4 + (0xAC0EABFD ^ 0xAC0EABF9)) : section.getName()) + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("<") + string;
                n2 = 0x2C8902C9 ^ 0x2C8902C8;
            }
        }
        Section section2 = this.get(n2 != 0 ? string : string2);
        if (n2 != 0 && section != null && this.active) {
            section2 = this.getSubSection(string2, section.getName(), section2);
        }
        section2.setFine(n3 != 0).setRoot(n2 != 0);
        this.stack.push(section2);
        return section2.start();
    }

    void end(Section section) {
        block5: {
            try {
                Section section2;
                Section section3 = section2 = this.stack.pop();
                while (section3 != section) {
                    if (section3 == null && this.active) {
                        if (section2 == null) {
                            throw new IllegalStateException(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7e4\ua4a0\ua065\ua945\u7d62\u8e42\u247f\u8b77\u3464f\ua7e7\ua4b6\ua07a\ua945\u7d7f\u8e59\u243a\u8b32\u347ab\ua7f2\ua4ac"));
                        }
                        throw new IllegalStateException(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7f1\ua4bd\ua078\ua906\u7d7e\u8e0a\u246d\u8b36\u34642\ua7e8\ua4ba\ua065\ua945\u7d7f\u8e44\u243a\u8b23\u347fw\ua7a6\ua4a6\ua065\ua904\u7d75\u8e41\u2436\u8b77\u347fw\ua7e7\ua4b1\ua031\ua912\u7d77\u8e59\u243a") + section2);
                    }
                    section3 = this.stack.pop();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (!this.active) break block5;
                throw new IllegalStateException(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7e4\ua4a0\ua065\ua945\u7d62\u8e42\u247f\u8b77\u3464f\ua7e7\ua4b6\ua07a\ua945\u7d7f\u8e59\u243a\u8b32\u347ab\ua7f2\ua4ac"));
            }
        }
    }

    public void mark(String string) {
        long l = 0x92CC568E7A353C57L ^ 0x92CC568E7A353C57L;
        for (Section section : this.sections.values()) {
            l += section.getTime();
        }
        if (l == (0xD6FBC86BA80CF267L ^ 0xD6FBC86BA80CF267L)) {
            int n = this.phases.size();
            this.phases.set(n - (0x874C47CA ^ 0x874C47CB), string);
            return;
        }
        this.phases.add(string);
        for (Section section : this.sections.values()) {
            section.mark();
        }
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    public PrettyPrinter printer(boolean bl, boolean bl2) {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        int n = this.phases.size() + (0x3F8C80F1 ^ 0x3F8C80F5);
        int[] nArray = new int[0xFD5C9C66 ^ 0xFD5C9C63];
        nArray[0x211153AE ^ 0x211153AE] = 0xD56526CC ^ 0xD56526CC;
        nArray[0xE4C2FA26 ^ 0xE4C2FA27] = 0x52948342 ^ 0x52948343;
        nArray[0x4B4F255D ^ 0x4B4F255F] = 0x115361E1 ^ 0x115361E3;
        nArray[0x38E7DE94 ^ 0x38E7DE97] = n - (0x9579CF3A ^ 0x9579CF38);
        nArray[0x2289D060 ^ 0x2289D064] = n - (0xEB4268E8 ^ 0xEB4268E9);
        int[] nArray2 = nArray;
        Object[] objectArray = new Object[n * (0x948D28B6 ^ 0x948D28B4)];
        int n2 = 0xDE013C98 ^ 0xDE013C98;
        int n3 = 0xC30DE9C6 ^ 0xC30DE9C6;
        while (n2 < n) {
            objectArray[n3 + (0xE358C666 ^ 0xE358C667)] = PrettyPrinter.Alignment.RIGHT;
            if (n2 == nArray2[0xF1FCD15F ^ 0xF1FCD15F]) {
                objectArray[n3] = (bl2 ? \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("") : \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7a6")) + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("A\ua7e3\ua4b6\ua065\ua90c\u7d79\u8e44");
                objectArray[n3 + (0xD639437D ^ 0xD639437C)] = PrettyPrinter.Alignment.LEFT;
            } else {
                objectArray[n3] = n2 == nArray2[0x2F11CA71 ^ 0x2F11CA70] ? \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7a6\ua4f5\ua031\ua931\u7d59\u8e7e\u245b\u8b1b") : (n2 == nArray2[0xD3B4A290 ^ 0xD3B4A293] ? \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7a6\ua4f5\ua031\ua926\u7d79\u8e5f\u2474\u8b23") : (n2 == nArray2[0xD2C95484 ^ 0xD2C95480] ? \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("S\ua7f0\ua4b2\ua03f\ua945") : (n2 - nArray2[0xF074E917 ^ 0xF074E915] < this.phases.size() ? this.phases.get(n2 - nArray2[0x6C4FAAA9 ^ 0x6C4FAAAB]) : \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427(""))));
            }
            n3 = ++n2 * (0xBEC13F0F ^ 0xBEC13F0D);
        }
        prettyPrinter.table(objectArray).th().hr().add();
        for (Section section : this.sections.values()) {
            if (section.isFine() && !bl || bl2 && section.getDelegate() != section) continue;
            this.printSectionRow(prettyPrinter, n, nArray2, section, bl2);
            if (!bl2) continue;
            for (Section section2 : this.sections.values()) {
                Section section3 = section2.getDelegate();
                if (section2.isFine() && !bl || section3 != section || section3 == section2) continue;
                this.printSectionRow(prettyPrinter, n, nArray2, section2, bl2);
            }
        }
        return prettyPrinter.add();
    }

    private void printSectionRow(PrettyPrinter prettyPrinter, int n, int[] nArray, Section section, boolean bl) {
        long[] lArray;
        int n2 = section.getDelegate() != section ? 0xC561E2D ^ 0xC561E2C : 0x18F6611 ^ 0x18F6611;
        Object[] objectArray = new Object[n];
        int n3 = 0xB9844628 ^ 0xB9844629;
        if (bl) {
            objectArray[0x2B0260CB ^ 0x2B0260CB] = n2 != 0 ? \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7a6\ua4eb\ua031") + section.getBaseName() : section.getName();
        } else {
            objectArray[0x8E3DCCE9 ^ 0x8E3DCCE9] = (n2 != 0 ? \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("9\ua7a6") : \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7a6")) + section.getName();
        }
        long[] lArray2 = lArray = section.getTimes();
        int n4 = lArray2.length;
        for (int i = 0xE4E4AFEE ^ 0xE4E4AFEE; i < n4; ++i) {
            long l = lArray2[i];
            if (n3 == nArray[0x67AD8BCB ^ 0x67AD8BCA]) {
                objectArray[n3++] = section.getTotalTime() + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7eb\ua4a6");
            }
            if (n3 < nArray[0x2FAF1F3A ^ 0x2FAF1F38] || n3 >= objectArray.length) continue;
            objectArray[n3++] = l + \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7eb\ua4a6");
        }
        objectArray[nArray[0xE7E4439C ^ 0xE7E4439F]] = section.getTotalCount();
        objectArray[nArray[0x66FF745 ^ 0x66FF741]] = new DecimalFormat(\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("2\ua7a6\ua4f5\ua032\ua946\u7d35\u8e1a\u2434\u8b67\u3427\"\ua7a6\ua4b8\ua062")).format(section.getTotalAverageTime());
        for (int i = 0x649B1093 ^ 0x649B1093; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            objectArray[i] = \u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2\u7eb3\u897f\u59b2.\u600e\u4e48\u8bf4\u5462\u6253\u6bd4\u65b9\u7684\u8bdd\u4f60\u4e0d\u4f1a\u7ed9\u72d7\u72d7\u559d\u852c\u83dc\u6c41\u5427("?");
        }
        prettyPrinter.tr(objectArray);
    }

    class SubSection
    extends LiveSection {
        private final String baseName;
        private final Section root;

        SubSection(String string, int n, String string2, Section section) {
            super(string, n);
            this.baseName = string2;
            this.root = section;
        }

        @Override
        Section invalidate() {
            this.root.invalidate();
            return super.invalidate();
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public void setInfo(String string) {
            this.root.setInfo(string);
            super.setInfo(string);
        }

        @Override
        Section getDelegate() {
            return this.root;
        }

        @Override
        Section start() {
            this.root.start();
            return super.start();
        }

        @Override
        public Section end() {
            this.root.stop();
            return super.end();
        }

        @Override
        public Section next(String string) {
            super.stop();
            return this.root.next(string);
        }
    }

    class LiveSection
    extends Section {
        private int cursor;
        private long[] times;
        private long start;
        private long time;
        private long markedTime;
        private int count;
        private int markedCount;

        LiveSection(String string, int n) {
            super(string);
            this.cursor = 0xA9A0DA85 ^ 0xA9A0DA85;
            this.times = new long[0x88D17352 ^ 0x88D17352];
            this.start = 0xE75F03F9BC6084EEL ^ 0xE75F03F9BC6084EEL;
            this.cursor = n;
        }

        @Override
        Section start() {
            this.start = System.currentTimeMillis();
            return this;
        }

        @Override
        protected Section stop() {
            if (this.start > (0x9488136FEEA6312L ^ 0x9488136FEEA6312L)) {
                this.time += System.currentTimeMillis() - this.start;
            }
            this.start = 0xA0F2CD87A9FA2158L ^ 0xA0F2CD87A9FA2158L;
            this.count += 0x61311278 ^ 0x61311279;
            return this;
        }

        @Override
        public Section end() {
            this.stop();
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        @Override
        void mark() {
            if (this.cursor >= this.times.length) {
                this.times = Arrays.copyOf(this.times, this.cursor + (0x48182FA9 ^ 0x48182FAD));
            }
            this.times[this.cursor] = this.time;
            this.markedTime += this.time;
            this.markedCount += this.count;
            this.time = 0x3BB48E1E74D65F25L ^ 0x3BB48E1E74D65F25L;
            this.count = 0xDF769B12 ^ 0xDF769B12;
            this.cursor += 0x5488DD5C ^ 0x5488DD5D;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public long getTotalTime() {
            return this.time + this.markedTime;
        }

        @Override
        public double getSeconds() {
            return (double)this.time * 0.001;
        }

        @Override
        public double getTotalSeconds() {
            return (double)(this.time + this.markedTime) * 0.001;
        }

        @Override
        public long[] getTimes() {
            long[] lArray = new long[this.cursor + (0x43EDD70C ^ 0x43EDD70D)];
            System.arraycopy(this.times, 0xB628E8D8 ^ 0xB628E8D8, lArray, 0xF67BEE5D ^ 0xF67BEE5D, Math.min(this.times.length, this.cursor));
            lArray[this.cursor] = this.time;
            return lArray;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int getTotalCount() {
            return this.count + this.markedCount;
        }

        @Override
        public double getAverageTime() {
            return this.count > 0 ? (double)this.time / (double)this.count : 0.0;
        }

        @Override
        public double getTotalAverageTime() {
            return this.count > 0 ? (double)(this.time + this.markedTime) / (double)(this.count + this.markedCount) : 0.0;
        }
    }

    public class Section {
        static final String SEPARATOR_ROOT = " -> ";
        static final String SEPARATOR_CHILD = ".";
        private final String name;
        private boolean root;
        private boolean fine;
        protected boolean invalidated;
        private String info;

        Section(String string) {
            this.name = string;
            this.info = string;
        }

        Section getDelegate() {
            return this;
        }

        Section invalidate() {
            this.invalidated = 0x29508590 ^ 0x29508591;
            return this;
        }

        Section setRoot(boolean bl) {
            this.root = bl;
            return this;
        }

        public boolean isRoot() {
            return this.root;
        }

        Section setFine(boolean bl) {
            this.fine = bl;
            return this;
        }

        public boolean isFine() {
            return this.fine;
        }

        public String getName() {
            return this.name;
        }

        public String getBaseName() {
            return this.name;
        }

        public void setInfo(String string) {
            this.info = string;
        }

        public String getInfo() {
            return this.info;
        }

        Section start() {
            return this;
        }

        protected Section stop() {
            return this;
        }

        public Section end() {
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        public Section next(String string) {
            this.end();
            return Profiler.this.begin(string);
        }

        void mark() {
        }

        public long getTime() {
            return 0x49D085DBA86C11D6L ^ 0x49D085DBA86C11D6L;
        }

        public long getTotalTime() {
            return 0xB32B3C76F2C43927L ^ 0xB32B3C76F2C43927L;
        }

        public double getSeconds() {
            return 0.0;
        }

        public double getTotalSeconds() {
            return 0.0;
        }

        public long[] getTimes() {
            return new long[0xAF937F9 ^ 0xAF937F8];
        }

        public int getCount() {
            return 0x89D29995 ^ 0x89D29995;
        }

        public int getTotalCount() {
            return 0x18A4093E ^ 0x18A4093E;
        }

        public double getAverageTime() {
            return 0.0;
        }

        public double getTotalAverageTime() {
            return 0.0;
        }

        public final String toString() {
            return this.name;
        }
    }
}

