/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodNode;

public final class Annotations {
    private Annotations() {
    }

    public static void setVisible(FieldNode fieldNode, Class<? extends Annotation> clazz, Object ... objectArray) {
        AnnotationNode annotationNode = Annotations.createNode(Type.getDescriptor(clazz), objectArray);
        fieldNode.visibleAnnotations = Annotations.add(fieldNode.visibleAnnotations, annotationNode);
    }

    public static void setInvisible(FieldNode fieldNode, Class<? extends Annotation> clazz, Object ... objectArray) {
        AnnotationNode annotationNode = Annotations.createNode(Type.getDescriptor(clazz), objectArray);
        fieldNode.invisibleAnnotations = Annotations.add(fieldNode.invisibleAnnotations, annotationNode);
    }

    public static void setVisible(MethodNode methodNode, Class<? extends Annotation> clazz, Object ... objectArray) {
        AnnotationNode annotationNode = Annotations.createNode(Type.getDescriptor(clazz), objectArray);
        methodNode.visibleAnnotations = Annotations.add(methodNode.visibleAnnotations, annotationNode);
    }

    public static void setInvisible(MethodNode methodNode, Class<? extends Annotation> clazz, Object ... objectArray) {
        AnnotationNode annotationNode = Annotations.createNode(Type.getDescriptor(clazz), objectArray);
        methodNode.invisibleAnnotations = Annotations.add(methodNode.invisibleAnnotations, annotationNode);
    }

    private static AnnotationNode createNode(String string, Object ... objectArray) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        for (int i = 0; i < objectArray.length - 1; i += 2) {
            if (!(objectArray[i] instanceof String)) {
                throw new IllegalArgumentException("Annotation keys must be strings, found " + objectArray[i].getClass().getSimpleName() + " with " + objectArray[i].toString() + " at index " + i + " creating " + string);
            }
            annotationNode.visit((String)objectArray[i], objectArray[i + 1]);
        }
        return annotationNode;
    }

    private static List<AnnotationNode> add(List<AnnotationNode> list, AnnotationNode annotationNode) {
        if (list == null) {
            list = new ArrayList<AnnotationNode>(1);
        } else {
            list.remove(Annotations.get(list, annotationNode.desc));
        }
        list.add(annotationNode);
        return list;
    }

    public static AnnotationNode getVisible(FieldNode fieldNode, Class<? extends Annotation> clazz) {
        return Annotations.get(fieldNode.visibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getInvisible(FieldNode fieldNode, Class<? extends Annotation> clazz) {
        return Annotations.get(fieldNode.invisibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getVisible(MethodNode methodNode, Class<? extends Annotation> clazz) {
        return Annotations.get(methodNode.visibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getInvisible(MethodNode methodNode, Class<? extends Annotation> clazz) {
        return Annotations.get(methodNode.invisibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getSingleVisible(MethodNode methodNode, Class<? extends Annotation> ... classArray) {
        return Annotations.getSingle(methodNode.visibleAnnotations, classArray);
    }

    public static AnnotationNode getSingleInvisible(MethodNode methodNode, Class<? extends Annotation> ... classArray) {
        return Annotations.getSingle(methodNode.invisibleAnnotations, classArray);
    }

    public static AnnotationNode getVisible(ClassNode classNode, Class<? extends Annotation> clazz) {
        return Annotations.get(classNode.visibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getInvisible(ClassNode classNode, Class<? extends Annotation> clazz) {
        return Annotations.get(classNode.invisibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getVisibleParameter(MethodNode methodNode, Class<? extends Annotation> clazz, int n) {
        return Annotations.getParameter(methodNode.visibleParameterAnnotations, Type.getDescriptor(clazz), n);
    }

    public static AnnotationNode getInvisibleParameter(MethodNode methodNode, Class<? extends Annotation> clazz, int n) {
        return Annotations.getParameter(methodNode.invisibleParameterAnnotations, Type.getDescriptor(clazz), n);
    }

    public static AnnotationNode getParameter(List<AnnotationNode>[] listArray, String string, int n) {
        if (listArray == null || n < 0 || n >= listArray.length) {
            return null;
        }
        return Annotations.get(listArray[n], string);
    }

    public static AnnotationNode get(List<AnnotationNode> list, String string) {
        if (list == null) {
            return null;
        }
        for (AnnotationNode annotationNode : list) {
            if (!string.equals(annotationNode.desc)) continue;
            return annotationNode;
        }
        return null;
    }

    private static AnnotationNode getSingle(List<AnnotationNode> list, Class<? extends Annotation>[] classArray) {
        ArrayList<AnnotationNode> arrayList = new ArrayList<AnnotationNode>();
        for (Class<? extends Annotation> clazz : classArray) {
            AnnotationNode annotationNode = Annotations.get(list, Type.getDescriptor(clazz));
            if (annotationNode == null) continue;
            arrayList.add(annotationNode);
        }
        int n = arrayList.size();
        if (n > 1) {
            throw new IllegalArgumentException("Conflicting annotations found: " + Lists.transform(arrayList, (Function)new Function<AnnotationNode, String>(){

                public String apply(AnnotationNode annotationNode) {
                    return annotationNode.desc;
                }
            }));
        }
        return n == 0 ? null : (AnnotationNode)arrayList.get(0);
    }

    public static <T> T getValue(AnnotationNode annotationNode) {
        return Annotations.getValue(annotationNode, "value");
    }

    public static <T> T getValue(AnnotationNode annotationNode, String string, T t) {
        T t2 = Annotations.getValue(annotationNode, string);
        return t2 != null ? t2 : t;
    }

    public static <T> T getValue(AnnotationNode annotationNode, String string, Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"annotationClass cannot be null");
        Object object = Annotations.getValue(annotationNode, string);
        if (object == null) {
            try {
                object = clazz.getDeclaredMethod(string, new Class[0]).getDefaultValue();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return object;
    }

    public static <T> T getValue(AnnotationNode annotationNode, String string) {
        boolean bl = false;
        if (annotationNode == null || annotationNode.values == null) {
            return null;
        }
        for (Object object : annotationNode.values) {
            if (bl) {
                return (T)object;
            }
            if (!object.equals(string)) continue;
            bl = true;
        }
        return null;
    }

    public static <T extends Enum<T>> T getValue(AnnotationNode annotationNode, String string, Class<T> clazz, T t) {
        String[] stringArray = (String[])Annotations.getValue(annotationNode, string);
        if (stringArray == null) {
            return t;
        }
        return Annotations.toEnumValue(clazz, stringArray);
    }

    public static <T> List<T> getValue(AnnotationNode annotationNode, String string, boolean bl) {
        T t = Annotations.getValue(annotationNode, string);
        if (t instanceof List) {
            return (List)t;
        }
        if (t != null) {
            ArrayList<T> arrayList = new ArrayList<T>();
            arrayList.add(t);
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static <T extends Enum<T>> List<T> getValue(AnnotationNode annotationNode, String string, boolean bl, Class<T> clazz) {
        T t = Annotations.getValue(annotationNode, string);
        if (t instanceof List) {
            ListIterator<T> listIterator = ((List)t).listIterator();
            while (listIterator.hasNext()) {
                listIterator.set(Annotations.toEnumValue(clazz, (String[])listIterator.next()));
            }
            return (List)t;
        }
        if (t instanceof String[]) {
            ArrayList<T> arrayList = new ArrayList<T>();
            arrayList.add(Annotations.toEnumValue(clazz, (String[])t));
            return arrayList;
        }
        return Collections.emptyList();
    }

    private static <T extends Enum<T>> T toEnumValue(Class<T> clazz, String[] stringArray) {
        if (!clazz.getName().equals(Type.getType(stringArray[0]).getClassName())) {
            throw new IllegalArgumentException("The supplied enum class does not match the stored enum value");
        }
        return Enum.valueOf(clazz, stringArray[1]);
    }
}

