/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.lib.tree.analysis.Analyzer;
import org.spongepowered.asm.lib.tree.analysis.AnalyzerException;
import org.spongepowered.asm.lib.tree.analysis.BasicValue;
import org.spongepowered.asm.lib.tree.analysis.Frame;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.asm.MixinVerifier;
import org.spongepowered.asm.util.throwables.LVTGeneratorException;

public final class Locals {
    private static final Map<String, List<LocalVariableNode>> calculatedLocalVariables = new HashMap<String, List<LocalVariableNode>>();

    private Locals() {
    }

    public static void loadLocals(Type[] typeArray, InsnList insnList, int n, int n2) {
        while (n < typeArray.length && n2 > 0) {
            if (typeArray[n] != null) {
                insnList.add(new VarInsnNode(typeArray[n].getOpcode(21), n));
                --n2;
            }
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalVariableNode[] getLocalsAt(ClassNode classNode, MethodNode methodNode, AbstractInsnNode abstractInsnNode) {
        void var12_17;
        for (int i = 0; i < 3 && (abstractInsnNode instanceof LabelNode || abstractInsnNode instanceof LineNumberNode); ++i) {
            abstractInsnNode = Locals.nextNode(methodNode.instructions, abstractInsnNode);
        }
        ClassInfo classInfo = ClassInfo.forName(classNode.name);
        if (classInfo == null) {
            throw new LVTGeneratorException("Could not load class metadata for " + classNode.name + " generating LVT for " + methodNode.name);
        }
        ClassInfo.Method method = classInfo.findMethod(methodNode);
        if (method == null) {
            throw new LVTGeneratorException("Could not locate method metadata for " + methodNode.name + " generating LVT in " + classNode.name);
        }
        List<ClassInfo.FrameData> list = method.getFrames();
        LocalVariableNode[] localVariableNodeArray = new LocalVariableNode[methodNode.maxLocals];
        int n = 0;
        int n2 = 0;
        if ((methodNode.access & 8) == 0) {
            localVariableNodeArray[n++] = new LocalVariableNode("this", classNode.name, null, null, null, 0);
        }
        for (Type type : Type.getArgumentTypes(methodNode.desc)) {
            localVariableNodeArray[n] = new LocalVariableNode("arg" + n2++, type.toString(), null, null, null, n);
            n += type.getSize();
        }
        int n3 = n;
        int n4 = -1;
        int n5 = 0;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode2;
            AbstractInsnNode abstractInsnNode3 = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode3 instanceof FrameNode) {
                abstractInsnNode2 = (FrameNode)abstractInsnNode3;
                ClassInfo.FrameData frameData = ++n4 < list.size() ? list.get(n4) : null;
                n5 = frameData != null && frameData.type == 0 ? Math.min(n5, frameData.locals) : abstractInsnNode2.local.size();
                int n6 = 0;
                int n7 = 0;
                while (n7 < localVariableNodeArray.length) {
                    Object object;
                    Object object2 = object = n6 < abstractInsnNode2.local.size() ? abstractInsnNode2.local.get(n6) : null;
                    if (object instanceof String) {
                        localVariableNodeArray[n7] = Locals.getLocalVariableAt(classNode, methodNode, abstractInsnNode, n7);
                    } else if (object instanceof Integer) {
                        boolean bl;
                        boolean bl2 = object == Opcodes.UNINITIALIZED_THIS || object == Opcodes.NULL;
                        boolean bl3 = object == Opcodes.INTEGER || object == Opcodes.FLOAT;
                        boolean bl4 = bl = object == Opcodes.DOUBLE || object == Opcodes.LONG;
                        if (object != Opcodes.TOP) {
                            if (bl2) {
                                localVariableNodeArray[n7] = null;
                            } else {
                                if (!bl3 && !bl) throw new LVTGeneratorException("Unrecognised locals opcode " + object + " in locals array at position " + n6 + " in " + classNode.name + "." + methodNode.name + methodNode.desc);
                                localVariableNodeArray[n7] = Locals.getLocalVariableAt(classNode, methodNode, abstractInsnNode, n7);
                                if (bl) {
                                    localVariableNodeArray[++n7] = null;
                                }
                            }
                        }
                    } else {
                        if (object != null) throw new LVTGeneratorException("Invalid value " + object + " in locals array at position " + n6 + " in " + classNode.name + "." + methodNode.name + methodNode.desc);
                        if (n7 >= n3 && n7 >= n5 && n5 > 0) {
                            localVariableNodeArray[n7] = null;
                        }
                    }
                    ++n7;
                    ++n6;
                }
            } else if (abstractInsnNode3 instanceof VarInsnNode) {
                abstractInsnNode2 = (VarInsnNode)abstractInsnNode3;
                localVariableNodeArray[((VarInsnNode)abstractInsnNode2).var] = Locals.getLocalVariableAt(classNode, methodNode, abstractInsnNode, ((VarInsnNode)abstractInsnNode2).var);
            }
            if (abstractInsnNode3 != abstractInsnNode) continue;
            break;
        }
        boolean bl = false;
        while (var12_17 < localVariableNodeArray.length) {
            if (localVariableNodeArray[var12_17] != null && localVariableNodeArray[var12_17].desc == null) {
                localVariableNodeArray[var12_17] = null;
            }
            ++var12_17;
        }
        return localVariableNodeArray;
    }

    public static LocalVariableNode getLocalVariableAt(ClassNode classNode, MethodNode methodNode, AbstractInsnNode abstractInsnNode, int n) {
        return Locals.getLocalVariableAt(classNode, methodNode, methodNode.instructions.indexOf(abstractInsnNode), n);
    }

    private static LocalVariableNode getLocalVariableAt(ClassNode classNode, MethodNode methodNode, int n, int n2) {
        LocalVariableNode localVariableNode = null;
        LocalVariableNode localVariableNode2 = null;
        for (LocalVariableNode localVariableNode3 : Locals.getLocalVariableTable(classNode, methodNode)) {
            if (localVariableNode3.index != n2) continue;
            if (Locals.isOpcodeInRange(methodNode.instructions, localVariableNode3, n)) {
                localVariableNode = localVariableNode3;
                continue;
            }
            if (localVariableNode != null) continue;
            localVariableNode2 = localVariableNode3;
        }
        if (localVariableNode == null && !methodNode.localVariables.isEmpty()) {
            for (LocalVariableNode localVariableNode3 : Locals.getGeneratedLocalVariableTable(classNode, methodNode)) {
                if (localVariableNode3.index != n2 || !Locals.isOpcodeInRange(methodNode.instructions, localVariableNode3, n)) continue;
                localVariableNode = localVariableNode3;
            }
        }
        return localVariableNode != null ? localVariableNode : localVariableNode2;
    }

    private static boolean isOpcodeInRange(InsnList insnList, LocalVariableNode localVariableNode, int n) {
        return insnList.indexOf(localVariableNode.start) < n && insnList.indexOf(localVariableNode.end) > n;
    }

    public static List<LocalVariableNode> getLocalVariableTable(ClassNode classNode, MethodNode methodNode) {
        if (methodNode.localVariables.isEmpty()) {
            return Locals.getGeneratedLocalVariableTable(classNode, methodNode);
        }
        return methodNode.localVariables;
    }

    public static List<LocalVariableNode> getGeneratedLocalVariableTable(ClassNode classNode, MethodNode methodNode) {
        String string = String.format("%s.%s%s", classNode.name, methodNode.name, methodNode.desc);
        List<LocalVariableNode> list = calculatedLocalVariables.get(string);
        if (list != null) {
            return list;
        }
        list = Locals.generateLocalVariableTable(classNode, methodNode);
        calculatedLocalVariables.put(string, list);
        return list;
    }

    public static List<LocalVariableNode> generateLocalVariableTable(ClassNode classNode, MethodNode methodNode) {
        int n;
        ArrayList<Type> arrayList = null;
        if (classNode.interfaces != null) {
            arrayList = new ArrayList<Type>();
            for (String object2 : classNode.interfaces) {
                arrayList.add(Type.getObjectType(object2));
            }
        }
        Object object3 = null;
        if (classNode.superName != null) {
            object3 = Type.getObjectType(classNode.superName);
        }
        Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new MixinVerifier(Type.getObjectType(classNode.name), (Type)object3, arrayList, false));
        try {
            analyzer.analyze(classNode.name, methodNode);
        }
        catch (AnalyzerException frameArray) {
            frameArray.printStackTrace();
        }
        Frame<BasicValue>[] frameArray = analyzer.getFrames();
        int n2 = methodNode.instructions.size();
        ArrayList<LocalVariableNode> arrayList2 = new ArrayList<LocalVariableNode>();
        LocalVariableNode[] localVariableNodeArray = new LocalVariableNode[methodNode.maxLocals];
        BasicValue[] basicValueArray = new BasicValue[methodNode.maxLocals];
        LabelNode[] labelNodeArray = new LabelNode[n2];
        String[] stringArray = new String[methodNode.maxLocals];
        for (int labelNode = 0; labelNode < n2; ++labelNode) {
            Frame<BasicValue> n3 = frameArray[labelNode];
            if (n3 == null) continue;
            LabelNode labelNode2 = null;
            for (int i = 0; i < n3.getLocals(); ++i) {
                Object object;
                BasicValue basicValue = n3.getLocal(i);
                if (basicValue == null && basicValueArray[i] == null || basicValue != null && basicValue.equals(basicValueArray[i])) continue;
                if (labelNode2 == null) {
                    object = methodNode.instructions.get(labelNode);
                    if (object instanceof LabelNode) {
                        labelNode2 = (LabelNode)object;
                    } else {
                        labelNodeArray[labelNode] = labelNode2 = new LabelNode();
                    }
                }
                if (basicValue == null && basicValueArray[i] != null) {
                    arrayList2.add(localVariableNodeArray[i]);
                    localVariableNodeArray[i].end = labelNode2;
                    localVariableNodeArray[i] = null;
                } else if (basicValue != null) {
                    if (basicValueArray[i] != null) {
                        arrayList2.add(localVariableNodeArray[i]);
                        localVariableNodeArray[i].end = labelNode2;
                        localVariableNodeArray[i] = null;
                    }
                    object = basicValue.getType() != null ? basicValue.getType().getDescriptor() : stringArray[i];
                    localVariableNodeArray[i] = new LocalVariableNode("var" + i, (String)object, null, labelNode2, null, i);
                    if (object != null) {
                        stringArray[i] = object;
                    }
                }
                basicValueArray[i] = basicValue;
            }
        }
        LabelNode labelNode = null;
        for (n = 0; n < localVariableNodeArray.length; ++n) {
            if (localVariableNodeArray[n] == null) continue;
            if (labelNode == null) {
                labelNode = new LabelNode();
                methodNode.instructions.add(labelNode);
            }
            localVariableNodeArray[n].end = labelNode;
            arrayList2.add(localVariableNodeArray[n]);
        }
        for (n = n2 - 1; n >= 0; --n) {
            if (labelNodeArray[n] == null) continue;
            methodNode.instructions.insert(methodNode.instructions.get(n), labelNodeArray[n]);
        }
        return arrayList2;
    }

    private static AbstractInsnNode nextNode(InsnList insnList, AbstractInsnNode abstractInsnNode) {
        int n = insnList.indexOf(abstractInsnNode) + 1;
        if (n > 0 && n < insnList.size()) {
            return insnList.get(n);
        }
        return abstractInsnNode;
    }
}

