/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.asm.lib.AnnotationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationNode
extends AnnotationVisitor {
    public String desc;
    public List<Object> values;

    public AnnotationNode(String string) {
        this(327680, string);
        if (this.getClass() != AnnotationNode.class) {
            throw new IllegalStateException();
        }
    }

    public AnnotationNode(int n, String string) {
        super(n);
        this.desc = string;
    }

    AnnotationNode(List<Object> list) {
        super(327680);
        this.values = list;
    }

    @Override
    public void visit(String string, Object object) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(string);
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            ArrayList<Byte> arrayList = new ArrayList<Byte>(byArray.length);
            for (byte by : byArray) {
                arrayList.add(by);
            }
            this.values.add(arrayList);
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>(blArray.length);
            for (boolean bl : blArray) {
                arrayList.add(bl);
            }
            this.values.add(arrayList);
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            ArrayList<Short> arrayList = new ArrayList<Short>(sArray.length);
            for (short s : sArray) {
                arrayList.add(s);
            }
            this.values.add(arrayList);
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            ArrayList<Character> arrayList = new ArrayList<Character>(cArray.length);
            for (char c : cArray) {
                arrayList.add(Character.valueOf(c));
            }
            this.values.add(arrayList);
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
            for (int n : nArray) {
                arrayList.add(n);
            }
            this.values.add(arrayList);
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            ArrayList<Long> arrayList = new ArrayList<Long>(lArray.length);
            for (long l : lArray) {
                arrayList.add(l);
            }
            this.values.add(arrayList);
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            ArrayList<Float> arrayList = new ArrayList<Float>(fArray.length);
            for (float f : fArray) {
                arrayList.add(Float.valueOf(f));
            }
            this.values.add(arrayList);
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
            for (double d : dArray) {
                arrayList.add(d);
            }
            this.values.add(arrayList);
        } else {
            this.values.add(object);
        }
    }

    @Override
    public void visitEnum(String string, String string2, String string3) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(string);
        }
        this.values.add(new String[]{string2, string3});
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, String string2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(string);
        }
        AnnotationNode annotationNode = new AnnotationNode(string2);
        this.values.add(annotationNode);
        return annotationNode;
    }

    @Override
    public AnnotationVisitor visitArray(String string) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(string);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.values.add(arrayList);
        return new AnnotationNode(arrayList);
    }

    @Override
    public void visitEnd() {
    }

    public void check(int n) {
    }

    public void accept(AnnotationVisitor annotationVisitor) {
        if (annotationVisitor != null) {
            if (this.values != null) {
                for (int i = 0; i < this.values.size(); i += 2) {
                    String string = (String)this.values.get(i);
                    Object object = this.values.get(i + 1);
                    AnnotationNode.accept(annotationVisitor, string, object);
                }
            }
            annotationVisitor.visitEnd();
        }
    }

    static void accept(AnnotationVisitor annotationVisitor, String string, Object object) {
        if (annotationVisitor != null) {
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                annotationVisitor.visitEnum(string, stringArray[0], stringArray[1]);
            } else if (object instanceof AnnotationNode) {
                AnnotationNode annotationNode = (AnnotationNode)object;
                annotationNode.accept(annotationVisitor.visitAnnotation(string, annotationNode.desc));
            } else if (object instanceof List) {
                AnnotationVisitor annotationVisitor2 = annotationVisitor.visitArray(string);
                if (annotationVisitor2 != null) {
                    List list = (List)object;
                    for (int i = 0; i < list.size(); ++i) {
                        AnnotationNode.accept(annotationVisitor2, null, list.get(i));
                    }
                    annotationVisitor2.visitEnd();
                }
            } else {
                annotationVisitor.visit(string, object);
            }
        }
    }
}

