/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.SynthesisFilter;
import pers.XiaoShadiao.NMSLException;

class LayerIIDecoder
extends LayerIDecoder
implements FrameDecoder {
    @Override
    protected void createSubbands() {
        if (this.mode == 3) {
            for (int i = 0; i < this.num_subbands; ++i) {
                this.subbands[i] = new SubbandLayer2(i);
            }
        } else if (this.mode == 1) {
            int i;
            for (i = 0; i < this.header.intensity_stereo_bound(); ++i) {
                this.subbands[i] = new SubbandLayer2Stereo(i);
            }
            while (i < this.num_subbands) {
                this.subbands[i] = new SubbandLayer2IntensityStereo(i);
                ++i;
            }
        } else {
            for (int i = 0; i < this.num_subbands; ++i) {
                this.subbands[i] = new SubbandLayer2Stereo(i);
            }
        }
    }

    @Override
    protected void readScaleFactorSelection() {
        for (int i = 0; i < this.num_subbands; ++i) {
            ((SubbandLayer2)this.subbands[i]).read_scalefactor_selection(this.stream, this.crc);
        }
    }

    static class SubbandLayer2Stereo
    extends SubbandLayer2 {
        protected int channel2_allocation;
        protected int channel2_scfsi;
        protected float channel2_scalefactor1;
        protected float channel2_scalefactor2;
        protected float channel2_scalefactor3;
        protected int[] channel2_codelength = new int[]{0};
        protected float[] channel2_factor = new float[]{0.0f};
        protected float[] channel2_samples;
        protected float[] channel2_c = new float[]{0.0f};
        protected float[] channel2_d = new float[]{0.0f};

        public SubbandLayer2Stereo(int subbandnumber) {
            super(subbandnumber);
            this.channel2_samples = new float[3];
        }

        @Override
        public void read_allocation(Bitstream stream, Header header, Crc16 crc) {
            int length = this.get_allocationlength(header);
            this.allocation = stream.get_bits(length);
            this.channel2_allocation = stream.get_bits(length);
            if (crc != null) {
                crc.add_bits(this.allocation, length);
                crc.add_bits(this.channel2_allocation, length);
            }
        }

        @Override
        public void read_scalefactor_selection(Bitstream stream, Crc16 crc) {
            if (this.allocation != 0) {
                this.scfsi = stream.get_bits(2);
                if (crc != null) {
                    crc.add_bits(this.scfsi, 2);
                }
            }
            if (this.channel2_allocation != 0) {
                this.channel2_scfsi = stream.get_bits(2);
                if (crc != null) {
                    crc.add_bits(this.channel2_scfsi, 2);
                }
            }
        }

        @Override
        public void read_scalefactor(Bitstream stream, Header header) {
            super.read_scalefactor(stream, header);
            if (this.channel2_allocation != 0) {
                switch (this.channel2_scfsi) {
                    case 0: {
                        this.channel2_scalefactor1 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor2 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                        break;
                    }
                    case 1: {
                        this.channel2_scalefactor1 = this.channel2_scalefactor2 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                        break;
                    }
                    case 2: {
                        this.channel2_scalefactor2 = this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor1 = this.channel2_scalefactor3;
                        break;
                    }
                    case 3: {
                        this.channel2_scalefactor1 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor2 = this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                    }
                }
                this.prepare_sample_reading(header, this.channel2_allocation, 1, this.channel2_factor, this.channel2_codelength, this.channel2_c, this.channel2_d);
            }
        }

        @Override
        public boolean read_sampledata(Bitstream stream) {
            boolean returnvalue = super.read_sampledata(stream);
            if (this.channel2_allocation != 0) {
                if (this.groupingtable[1] != null) {
                    int samplecode = stream.get_bits(this.channel2_codelength[0]);
                    samplecode += samplecode << 1;
                    float[] target = this.channel2_samples;
                    float[] source = this.groupingtable[1];
                    int tmp = 0;
                    int temp = samplecode;
                    target[tmp] = source[temp];
                    target[++tmp] = source[++temp];
                    target[++tmp] = source[++temp];
                } else {
                    this.channel2_samples[0] = (float)((double)((float)stream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                    this.channel2_samples[1] = (float)((double)((float)stream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                    this.channel2_samples[2] = (float)((double)((float)stream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                }
            }
            return returnvalue;
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            boolean returnvalue = super.put_next_sample(channels, filter1, filter2);
            if (this.channel2_allocation != 0 && channels != 1) {
                float sample = this.channel2_samples[this.samplenumber - 1];
                if (this.groupingtable[1] == null) {
                    sample = (sample + this.channel2_d[0]) * this.channel2_c[0];
                }
                sample = this.groupnumber <= 4 ? (sample *= this.channel2_scalefactor1) : (this.groupnumber <= 8 ? (sample *= this.channel2_scalefactor2) : (sample *= this.channel2_scalefactor3));
                if (channels == 0) {
                    filter2.input_sample(sample, this.subbandnumber);
                } else {
                    filter1.input_sample(sample, this.subbandnumber);
                }
            }
            return returnvalue;
        }
    }

    static class SubbandLayer2IntensityStereo
    extends SubbandLayer2 {
        protected int channel2_scfsi;
        protected float channel2_scalefactor1;
        protected float channel2_scalefactor2;
        protected float channel2_scalefactor3;

        public SubbandLayer2IntensityStereo(int subbandnumber) {
            super(subbandnumber);
        }

        @Override
        public void read_allocation(Bitstream stream, Header header, Crc16 crc) {
            super.read_allocation(stream, header, crc);
        }

        @Override
        public void read_scalefactor_selection(Bitstream stream, Crc16 crc) {
            if (this.allocation != 0) {
                this.scfsi = stream.get_bits(2);
                this.channel2_scfsi = stream.get_bits(2);
                if (crc != null) {
                    crc.add_bits(this.scfsi, 2);
                    crc.add_bits(this.channel2_scfsi, 2);
                }
            }
        }

        @Override
        public void read_scalefactor(Bitstream stream, Header header) {
            if (this.allocation != 0) {
                super.read_scalefactor(stream, header);
                switch (this.channel2_scfsi) {
                    case 0: {
                        this.channel2_scalefactor1 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor2 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                        break;
                    }
                    case 1: {
                        this.channel2_scalefactor1 = this.channel2_scalefactor2 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                        break;
                    }
                    case 2: {
                        this.channel2_scalefactor2 = this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor1 = this.channel2_scalefactor3;
                        break;
                    }
                    case 3: {
                        this.channel2_scalefactor1 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor2 = this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                    }
                }
            }
        }

        @Override
        public boolean read_sampledata(Bitstream stream) {
            return super.read_sampledata(stream);
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            if (this.allocation != 0) {
                float sample = this.samples[this.samplenumber];
                if (this.groupingtable[0] == null) {
                    sample = (sample + this.d[0]) * this.c[0];
                }
                if (channels == 0) {
                    float sample2 = sample;
                    if (this.groupnumber <= 4) {
                        sample *= this.scalefactor1;
                        sample2 *= this.channel2_scalefactor1;
                    } else if (this.groupnumber <= 8) {
                        sample *= this.scalefactor2;
                        sample2 *= this.channel2_scalefactor2;
                    } else {
                        sample *= this.scalefactor3;
                        sample2 *= this.channel2_scalefactor3;
                    }
                    filter1.input_sample(sample, this.subbandnumber);
                    filter2.input_sample(sample2, this.subbandnumber);
                } else if (channels == 1) {
                    sample = this.groupnumber <= 4 ? (sample *= this.scalefactor1) : (this.groupnumber <= 8 ? (sample *= this.scalefactor2) : (sample *= this.scalefactor3));
                    filter1.input_sample(sample, this.subbandnumber);
                } else {
                    sample = this.groupnumber <= 4 ? (sample *= this.channel2_scalefactor1) : (this.groupnumber <= 8 ? (sample *= this.channel2_scalefactor2) : (sample *= this.channel2_scalefactor3));
                    filter1.input_sample(sample, this.subbandnumber);
                }
            }
            return ++this.samplenumber == 3;
        }
    }

    static class SubbandLayer2
    extends LayerIDecoder.Subband {
        public static final float[] grouping_5bits;
        public static final float[] grouping_7bits;
        public static final float[] grouping_10bits;
        public static final int[] table_ab1_codelength;
        public static final float[][] table_ab1_groupingtables;
        public static final float[] table_ab1_factor;
        public static final float[] table_ab1_c;
        public static final float[] table_ab1_d;
        public static final float[][] table_ab234_groupingtables;
        public static final int[] table_ab2_codelength;
        public static final float[] table_ab2_factor;
        public static final float[] table_ab2_c;
        public static final float[] table_ab2_d;
        public static final int[] table_ab3_codelength;
        public static final float[] table_ab3_factor;
        public static final float[] table_ab3_c;
        public static final float[] table_ab3_d;
        public static final int[] table_ab4_codelength;
        public static final float[] table_ab4_factor;
        public static final float[] table_ab4_c;
        public static final float[] table_ab4_d;
        public static final int[] table_cd_codelength;
        public static final float[][] table_cd_groupingtables;
        public static final float[] table_cd_factor;
        public static final float[] table_cd_c;
        public static final float[] table_cd_d;
        protected int subbandnumber;
        protected int allocation;
        protected int scfsi;
        protected float scalefactor1;
        protected float scalefactor2;
        protected float scalefactor3;
        protected int[] codelength = new int[]{0};
        protected float[][] groupingtable = new float[2][];
        protected float[] factor = new float[]{0.0f};
        protected int groupnumber;
        protected int samplenumber;
        protected float[] samples = new float[3];
        protected float[] c = new float[]{0.0f};
        protected float[] d = new float[]{0.0f};
        private static final NMSLException \u8fc7\u53bb\u7684\u6211\u592a\u5929\u771f\u4e86;

        public SubbandLayer2(int subbandnumber) {
            this.subbandnumber = subbandnumber;
            this.samplenumber = 0;
            this.groupnumber = 0;
        }

        protected int get_allocationlength(Header header) {
            if (header.version() == 1) {
                int channel_bitrate = header.bitrate_index();
                if (header.mode() != 3) {
                    channel_bitrate = channel_bitrate == 4 ? 1 : (channel_bitrate -= 4);
                }
                if (channel_bitrate == 1 || channel_bitrate == 2) {
                    if (this.subbandnumber <= 1) {
                        return 4;
                    }
                    return 3;
                }
                if (this.subbandnumber <= 10) {
                    return 4;
                }
                if (this.subbandnumber <= 22) {
                    return 3;
                }
                return 2;
            }
            if (this.subbandnumber <= 3) {
                return 4;
            }
            if (this.subbandnumber <= 10) {
                return 3;
            }
            return 2;
        }

        protected void prepare_sample_reading(Header header, int allocation, int channel, float[] factor, int[] codelength, float[] c, float[] d) {
            int channel_bitrate = header.bitrate_index();
            if (header.mode() != 3) {
                channel_bitrate = channel_bitrate == 4 ? 1 : (channel_bitrate -= 4);
            }
            if (channel_bitrate == 1 || channel_bitrate == 2) {
                this.groupingtable[channel] = table_cd_groupingtables[allocation];
                factor[0] = table_cd_factor[allocation];
                codelength[0] = table_cd_codelength[allocation];
                c[0] = table_cd_c[allocation];
                d[0] = table_cd_d[allocation];
            } else if (this.subbandnumber <= 2) {
                this.groupingtable[channel] = table_ab1_groupingtables[allocation];
                factor[0] = table_ab1_factor[allocation];
                codelength[0] = table_ab1_codelength[allocation];
                c[0] = table_ab1_c[allocation];
                d[0] = table_ab1_d[allocation];
            } else {
                this.groupingtable[channel] = table_ab234_groupingtables[allocation];
                if (this.subbandnumber <= 10) {
                    factor[0] = table_ab2_factor[allocation];
                    codelength[0] = table_ab2_codelength[allocation];
                    c[0] = table_ab2_c[allocation];
                    d[0] = table_ab2_d[allocation];
                } else if (this.subbandnumber <= 22) {
                    factor[0] = table_ab3_factor[allocation];
                    codelength[0] = table_ab3_codelength[allocation];
                    c[0] = table_ab3_c[allocation];
                    d[0] = table_ab3_d[allocation];
                } else {
                    factor[0] = table_ab4_factor[allocation];
                    codelength[0] = table_ab4_codelength[allocation];
                    c[0] = table_ab4_c[allocation];
                    d[0] = table_ab4_d[allocation];
                }
            }
        }

        @Override
        public void read_allocation(Bitstream stream, Header header, Crc16 crc) {
            int length = this.get_allocationlength(header);
            this.allocation = stream.get_bits(length);
            if (crc != null) {
                crc.add_bits(this.allocation, length);
            }
        }

        public void read_scalefactor_selection(Bitstream stream, Crc16 crc) {
            if (this.allocation != 0) {
                this.scfsi = stream.get_bits(2);
                if (crc != null) {
                    crc.add_bits(this.scfsi, 2);
                }
            }
        }

        @Override
        public void read_scalefactor(Bitstream stream, Header header) {
            if (this.allocation != 0) {
                switch (this.scfsi) {
                    case 0: {
                        this.scalefactor1 = scalefactors[stream.get_bits(6)];
                        this.scalefactor2 = scalefactors[stream.get_bits(6)];
                        this.scalefactor3 = scalefactors[stream.get_bits(6)];
                        break;
                    }
                    case 1: {
                        this.scalefactor1 = this.scalefactor2 = scalefactors[stream.get_bits(6)];
                        this.scalefactor3 = scalefactors[stream.get_bits(6)];
                        break;
                    }
                    case 2: {
                        this.scalefactor2 = this.scalefactor3 = scalefactors[stream.get_bits(6)];
                        this.scalefactor1 = this.scalefactor3;
                        break;
                    }
                    case 3: {
                        this.scalefactor1 = scalefactors[stream.get_bits(6)];
                        this.scalefactor2 = this.scalefactor3 = scalefactors[stream.get_bits(6)];
                    }
                }
                this.prepare_sample_reading(header, this.allocation, 0, this.factor, this.codelength, this.c, this.d);
            }
        }

        @Override
        public boolean read_sampledata(Bitstream stream) {
            if (this.allocation != 0) {
                if (this.groupingtable[0] != null) {
                    int samplecode = stream.get_bits(this.codelength[0]);
                    samplecode += samplecode << 1;
                    float[] target = this.samples;
                    float[] source = this.groupingtable[0];
                    int tmp = 0;
                    int temp = samplecode;
                    if (temp > source.length - 3) {
                        temp = source.length - 3;
                    }
                    target[tmp] = source[temp];
                    target[++tmp] = source[++temp];
                    target[++tmp] = source[++temp];
                } else {
                    this.samples[0] = (float)((double)((float)stream.get_bits(this.codelength[0]) * this.factor[0]) - 1.0);
                    this.samples[1] = (float)((double)((float)stream.get_bits(this.codelength[0]) * this.factor[0]) - 1.0);
                    this.samples[2] = (float)((double)((float)stream.get_bits(this.codelength[0]) * this.factor[0]) - 1.0);
                }
            }
            this.samplenumber = 0;
            return ++this.groupnumber == 12;
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            if (this.allocation != 0 && channels != 2) {
                float sample = this.samples[this.samplenumber];
                if (this.groupingtable[0] == null) {
                    sample = (sample + this.d[0]) * this.c[0];
                }
                sample = this.groupnumber <= 4 ? (sample *= this.scalefactor1) : (this.groupnumber <= 8 ? (sample *= this.scalefactor2) : (sample *= this.scalefactor3));
                filter1.input_sample(sample, this.subbandnumber);
            }
            return ++this.samplenumber == 3;
        }

        static {
            \u8fc7\u53bb\u7684\u6211\u592a\u5929\u771f\u4e86 = new NMSLException("\ud2f8\ue849\u86e4\u2c8f\u509c\u7480\u6ef9\uac32\ue5a2\u95f6\u3d61\u3b04\uc447\u5162\u2b0f\ufe38\uaa09\ufc03\u616f\uc1d9\u54c0\uf26c\u941e\u565c\u51f0\u724b\u6cb6\u53cc\ue24e\u9f0e\uccfb\ue807\ufb0d\u9509\u65da\u4044\u2eea\ud2ff");
            grouping_5bits = new float[]{-0.6666667f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.0f, -0.6666667f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f};
            grouping_7bits = new float[]{-0.8f, -0.8f, -0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.8f, -0.8f, -0.8f, -0.4f, -0.8f, -0.4f, -0.4f, -0.8f, 0.0f, -0.4f, -0.8f, 0.4f, -0.4f, -0.8f, 0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.8f, -0.4f, 0.0f, -0.8f, 0.0f, 0.0f, -0.8f, 0.4f, 0.0f, -0.8f, 0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.8f, -0.4f, 0.4f, -0.8f, 0.0f, 0.4f, -0.8f, 0.4f, 0.4f, -0.8f, 0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.8f, -0.4f, 0.8f, -0.8f, 0.0f, 0.8f, -0.8f, 0.4f, 0.8f, -0.8f, 0.8f, 0.8f, -0.8f, -0.8f, -0.8f, -0.4f, -0.4f, -0.8f, -0.4f, 0.0f, -0.8f, -0.4f, 0.4f, -0.8f, -0.4f, 0.8f, -0.8f, -0.4f, -0.8f, -0.4f, -0.4f, -0.4f, -0.4f, -0.4f, 0.0f, -0.4f, -0.4f, 0.4f, -0.4f, -0.4f, 0.8f, -0.4f, -0.4f, -0.8f, 0.0f, -0.4f, -0.4f, 0.0f, -0.4f, 0.0f, 0.0f, -0.4f, 0.4f, 0.0f, -0.4f, 0.8f, 0.0f, -0.4f, -0.8f, 0.4f, -0.4f, -0.4f, 0.4f, -0.4f, 0.0f, 0.4f, -0.4f, 0.4f, 0.4f, -0.4f, 0.8f, 0.4f, -0.4f, -0.8f, 0.8f, -0.4f, -0.4f, 0.8f, -0.4f, 0.0f, 0.8f, -0.4f, 0.4f, 0.8f, -0.4f, 0.8f, 0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.4f, -0.8f, 0.0f, 0.0f, -0.8f, 0.0f, 0.4f, -0.8f, 0.0f, 0.8f, -0.8f, 0.0f, -0.8f, -0.4f, 0.0f, -0.4f, -0.4f, 0.0f, 0.0f, -0.4f, 0.0f, 0.4f, -0.4f, 0.0f, 0.8f, -0.4f, 0.0f, -0.8f, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.0f, 0.0f, 0.8f, 0.0f, 0.0f, -0.8f, 0.4f, 0.0f, -0.4f, 0.4f, 0.0f, 0.0f, 0.4f, 0.0f, 0.4f, 0.4f, 0.0f, 0.8f, 0.4f, 0.0f, -0.8f, 0.8f, 0.0f, -0.4f, 0.8f, 0.0f, 0.0f, 0.8f, 0.0f, 0.4f, 0.8f, 0.0f, 0.8f, 0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.4f, -0.8f, 0.4f, 0.0f, -0.8f, 0.4f, 0.4f, -0.8f, 0.4f, 0.8f, -0.8f, 0.4f, -0.8f, -0.4f, 0.4f, -0.4f, -0.4f, 0.4f, 0.0f, -0.4f, 0.4f, 0.4f, -0.4f, 0.4f, 0.8f, -0.4f, 0.4f, -0.8f, 0.0f, 0.4f, -0.4f, 0.0f, 0.4f, 0.0f, 0.0f, 0.4f, 0.4f, 0.0f, 0.4f, 0.8f, 0.0f, 0.4f, -0.8f, 0.4f, 0.4f, -0.4f, 0.4f, 0.4f, 0.0f, 0.4f, 0.4f, 0.4f, 0.4f, 0.4f, 0.8f, 0.4f, 0.4f, -0.8f, 0.8f, 0.4f, -0.4f, 0.8f, 0.4f, 0.0f, 0.8f, 0.4f, 0.4f, 0.8f, 0.4f, 0.8f, 0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.4f, -0.8f, 0.8f, 0.0f, -0.8f, 0.8f, 0.4f, -0.8f, 0.8f, 0.8f, -0.8f, 0.8f, -0.8f, -0.4f, 0.8f, -0.4f, -0.4f, 0.8f, 0.0f, -0.4f, 0.8f, 0.4f, -0.4f, 0.8f, 0.8f, -0.4f, 0.8f, -0.8f, 0.0f, 0.8f, -0.4f, 0.0f, 0.8f, 0.0f, 0.0f, 0.8f, 0.4f, 0.0f, 0.8f, 0.8f, 0.0f, 0.8f, -0.8f, 0.4f, 0.8f, -0.4f, 0.4f, 0.8f, 0.0f, 0.4f, 0.8f, 0.4f, 0.4f, 0.8f, 0.8f, 0.4f, 0.8f, -0.8f, 0.8f, 0.8f, -0.4f, 0.8f, 0.8f, 0.0f, 0.8f, 0.8f, 0.4f, 0.8f, 0.8f, 0.8f, 0.8f, 0.8f};
            grouping_10bits = new float[]{-0.8888889f, -0.8888889f, -0.8888889f, -0.6666667f, -0.8888889f, -0.8888889f, -0.44444445f, -0.8888889f, -0.8888889f, -0.22222222f, -0.8888889f, -0.8888889f, 0.0f, -0.8888889f, -0.8888889f, 0.22222222f, -0.8888889f, -0.8888889f, 0.44444445f, -0.8888889f, -0.8888889f, 0.6666667f, -0.8888889f, -0.8888889f, 0.8888889f, -0.8888889f, -0.8888889f, -0.8888889f, -0.6666667f, -0.8888889f, -0.6666667f, -0.6666667f, -0.8888889f, -0.44444445f, -0.6666667f, -0.8888889f, -0.22222222f, -0.6666667f, -0.8888889f, 0.0f, -0.6666667f, -0.8888889f, 0.22222222f, -0.6666667f, -0.8888889f, 0.44444445f, -0.6666667f, -0.8888889f, 0.6666667f, -0.6666667f, -0.8888889f, 0.8888889f, -0.6666667f, -0.8888889f, -0.8888889f, -0.44444445f, -0.8888889f, -0.6666667f, -0.44444445f, -0.8888889f, -0.44444445f, -0.44444445f, -0.8888889f, -0.22222222f, -0.44444445f, -0.8888889f, 0.0f, -0.44444445f, -0.8888889f, 0.22222222f, -0.44444445f, -0.8888889f, 0.44444445f, -0.44444445f, -0.8888889f, 0.6666667f, -0.44444445f, -0.8888889f, 0.8888889f, -0.44444445f, -0.8888889f, -0.8888889f, -0.22222222f, -0.8888889f, -0.6666667f, -0.22222222f, -0.8888889f, -0.44444445f, -0.22222222f, -0.8888889f, -0.22222222f, -0.22222222f, -0.8888889f, 0.0f, -0.22222222f, -0.8888889f, 0.22222222f, -0.22222222f, -0.8888889f, 0.44444445f, -0.22222222f, -0.8888889f, 0.6666667f, -0.22222222f, -0.8888889f, 0.8888889f, -0.22222222f, -0.8888889f, -0.8888889f, 0.0f, -0.8888889f, -0.6666667f, 0.0f, -0.8888889f, -0.44444445f, 0.0f, -0.8888889f, -0.22222222f, 0.0f, -0.8888889f, 0.0f, 0.0f, -0.8888889f, 0.22222222f, 0.0f, -0.8888889f, 0.44444445f, 0.0f, -0.8888889f, 0.6666667f, 0.0f, -0.8888889f, 0.8888889f, 0.0f, -0.8888889f, -0.8888889f, 0.22222222f, -0.8888889f, -0.6666667f, 0.22222222f, -0.8888889f, -0.44444445f, 0.22222222f, -0.8888889f, -0.22222222f, 0.22222222f, -0.8888889f, 0.0f, 0.22222222f, -0.8888889f, 0.22222222f, 0.22222222f, -0.8888889f, 0.44444445f, 0.22222222f, -0.8888889f, 0.6666667f, 0.22222222f, -0.8888889f, 0.8888889f, 0.22222222f, -0.8888889f, -0.8888889f, 0.44444445f, -0.8888889f, -0.6666667f, 0.44444445f, -0.8888889f, -0.44444445f, 0.44444445f, -0.8888889f, -0.22222222f, 0.44444445f, -0.8888889f, 0.0f, 0.44444445f, -0.8888889f, 0.22222222f, 0.44444445f, -0.8888889f, 0.44444445f, 0.44444445f, -0.8888889f, 0.6666667f, 0.44444445f, -0.8888889f, 0.8888889f, 0.44444445f, -0.8888889f, -0.8888889f, 0.6666667f, -0.8888889f, -0.6666667f, 0.6666667f, -0.8888889f, -0.44444445f, 0.6666667f, -0.8888889f, -0.22222222f, 0.6666667f, -0.8888889f, 0.0f, 0.6666667f, -0.8888889f, 0.22222222f, 0.6666667f, -0.8888889f, 0.44444445f, 0.6666667f, -0.8888889f, 0.6666667f, 0.6666667f, -0.8888889f, 0.8888889f, 0.6666667f, -0.8888889f, -0.8888889f, 0.8888889f, -0.8888889f, -0.6666667f, 0.8888889f, -0.8888889f, -0.44444445f, 0.8888889f, -0.8888889f, -0.22222222f, 0.8888889f, -0.8888889f, 0.0f, 0.8888889f, -0.8888889f, 0.22222222f, 0.8888889f, -0.8888889f, 0.44444445f, 0.8888889f, -0.8888889f, 0.6666667f, 0.8888889f, -0.8888889f, 0.8888889f, 0.8888889f, -0.8888889f, -0.8888889f, -0.8888889f, -0.6666667f, -0.6666667f, -0.8888889f, -0.6666667f, -0.44444445f, -0.8888889f, -0.6666667f, -0.22222222f, -0.8888889f, -0.6666667f, 0.0f, -0.8888889f, -0.6666667f, 0.22222222f, -0.8888889f, -0.6666667f, 0.44444445f, -0.8888889f, -0.6666667f, 0.6666667f, -0.8888889f, -0.6666667f, 0.8888889f, -0.8888889f, -0.6666667f, -0.8888889f, -0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, -0.44444445f, -0.6666667f, -0.6666667f, -0.22222222f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.22222222f, -0.6666667f, -0.6666667f, 0.44444445f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, 0.8888889f, -0.6666667f, -0.6666667f, -0.8888889f, -0.44444445f, -0.6666667f, -0.6666667f, -0.44444445f, -0.6666667f, -0.44444445f, -0.44444445f, -0.6666667f, -0.22222222f, -0.44444445f, -0.6666667f, 0.0f, -0.44444445f, -0.6666667f, 0.22222222f, -0.44444445f, -0.6666667f, 0.44444445f, -0.44444445f, -0.6666667f, 0.6666667f, -0.44444445f, -0.6666667f, 0.8888889f, -0.44444445f, -0.6666667f, -0.8888889f, -0.22222222f, -0.6666667f, -0.6666667f, -0.22222222f, -0.6666667f, -0.44444445f, -0.22222222f, -0.6666667f, -0.22222222f, -0.22222222f, -0.6666667f, 0.0f, -0.22222222f, -0.6666667f, 0.22222222f, -0.22222222f, -0.6666667f, 0.44444445f, -0.22222222f, -0.6666667f, 0.6666667f, -0.22222222f, -0.6666667f, 0.8888889f, -0.22222222f, -0.6666667f, -0.8888889f, 0.0f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, -0.44444445f, 0.0f, -0.6666667f, -0.22222222f, 0.0f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.22222222f, 0.0f, -0.6666667f, 0.44444445f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, 0.8888889f, 0.0f, -0.6666667f, -0.8888889f, 0.22222222f, -0.6666667f, -0.6666667f, 0.22222222f, -0.6666667f, -0.44444445f, 0.22222222f, -0.6666667f, -0.22222222f, 0.22222222f, -0.6666667f, 0.0f, 0.22222222f, -0.6666667f, 0.22222222f, 0.22222222f, -0.6666667f, 0.44444445f, 0.22222222f, -0.6666667f, 0.6666667f, 0.22222222f, -0.6666667f, 0.8888889f, 0.22222222f, -0.6666667f, -0.8888889f, 0.44444445f, -0.6666667f, -0.6666667f, 0.44444445f, -0.6666667f, -0.44444445f, 0.44444445f, -0.6666667f, -0.22222222f, 0.44444445f, -0.6666667f, 0.0f, 0.44444445f, -0.6666667f, 0.22222222f, 0.44444445f, -0.6666667f, 0.44444445f, 0.44444445f, -0.6666667f, 0.6666667f, 0.44444445f, -0.6666667f, 0.8888889f, 0.44444445f, -0.6666667f, -0.8888889f, 0.6666667f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, -0.44444445f, 0.6666667f, -0.6666667f, -0.22222222f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.22222222f, 0.6666667f, -0.6666667f, 0.44444445f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, 0.8888889f, 0.6666667f, -0.6666667f, -0.8888889f, 0.8888889f, -0.6666667f, -0.6666667f, 0.8888889f, -0.6666667f, -0.44444445f, 0.8888889f, -0.6666667f, -0.22222222f, 0.8888889f, -0.6666667f, 0.0f, 0.8888889f, -0.6666667f, 0.22222222f, 0.8888889f, -0.6666667f, 0.44444445f, 0.8888889f, -0.6666667f, 0.6666667f, 0.8888889f, -0.6666667f, 0.8888889f, 0.8888889f, -0.6666667f, -0.8888889f, -0.8888889f, -0.44444445f, -0.6666667f, -0.8888889f, -0.44444445f, -0.44444445f, -0.8888889f, -0.44444445f, -0.22222222f, -0.8888889f, -0.44444445f, 0.0f, -0.8888889f, -0.44444445f, 0.22222222f, -0.8888889f, -0.44444445f, 0.44444445f, -0.8888889f, -0.44444445f, 0.6666667f, -0.8888889f, -0.44444445f, 0.8888889f, -0.8888889f, -0.44444445f, -0.8888889f, -0.6666667f, -0.44444445f, -0.6666667f, -0.6666667f, -0.44444445f, -0.44444445f, -0.6666667f, -0.44444445f, -0.22222222f, -0.6666667f, -0.44444445f, 0.0f, -0.6666667f, -0.44444445f, 0.22222222f, -0.6666667f, -0.44444445f, 0.44444445f, -0.6666667f, -0.44444445f, 0.6666667f, -0.6666667f, -0.44444445f, 0.8888889f, -0.6666667f, -0.44444445f, -0.8888889f, -0.44444445f, -0.44444445f, -0.6666667f, -0.44444445f, -0.44444445f, -0.44444445f, -0.44444445f, -0.44444445f, -0.22222222f, -0.44444445f, -0.44444445f, 0.0f, -0.44444445f, -0.44444445f, 0.22222222f, -0.44444445f, -0.44444445f, 0.44444445f, -0.44444445f, -0.44444445f, 0.6666667f, -0.44444445f, -0.44444445f, 0.8888889f, -0.44444445f, -0.44444445f, -0.8888889f, -0.22222222f, -0.44444445f, -0.6666667f, -0.22222222f, -0.44444445f, -0.44444445f, -0.22222222f, -0.44444445f, -0.22222222f, -0.22222222f, -0.44444445f, 0.0f, -0.22222222f, -0.44444445f, 0.22222222f, -0.22222222f, -0.44444445f, 0.44444445f, -0.22222222f, -0.44444445f, 0.6666667f, -0.22222222f, -0.44444445f, 0.8888889f, -0.22222222f, -0.44444445f, -0.8888889f, 0.0f, -0.44444445f, -0.6666667f, 0.0f, -0.44444445f, -0.44444445f, 0.0f, -0.44444445f, -0.22222222f, 0.0f, -0.44444445f, 0.0f, 0.0f, -0.44444445f, 0.22222222f, 0.0f, -0.44444445f, 0.44444445f, 0.0f, -0.44444445f, 0.6666667f, 0.0f, -0.44444445f, 0.8888889f, 0.0f, -0.44444445f, -0.8888889f, 0.22222222f, -0.44444445f, -0.6666667f, 0.22222222f, -0.44444445f, -0.44444445f, 0.22222222f, -0.44444445f, -0.22222222f, 0.22222222f, -0.44444445f, 0.0f, 0.22222222f, -0.44444445f, 0.22222222f, 0.22222222f, -0.44444445f, 0.44444445f, 0.22222222f, -0.44444445f, 0.6666667f, 0.22222222f, -0.44444445f, 0.8888889f, 0.22222222f, -0.44444445f, -0.8888889f, 0.44444445f, -0.44444445f, -0.6666667f, 0.44444445f, -0.44444445f, -0.44444445f, 0.44444445f, -0.44444445f, -0.22222222f, 0.44444445f, -0.44444445f, 0.0f, 0.44444445f, -0.44444445f, 0.22222222f, 0.44444445f, -0.44444445f, 0.44444445f, 0.44444445f, -0.44444445f, 0.6666667f, 0.44444445f, -0.44444445f, 0.8888889f, 0.44444445f, -0.44444445f, -0.8888889f, 0.6666667f, -0.44444445f, -0.6666667f, 0.6666667f, -0.44444445f, -0.44444445f, 0.6666667f, -0.44444445f, -0.22222222f, 0.6666667f, -0.44444445f, 0.0f, 0.6666667f, -0.44444445f, 0.22222222f, 0.6666667f, -0.44444445f, 0.44444445f, 0.6666667f, -0.44444445f, 0.6666667f, 0.6666667f, -0.44444445f, 0.8888889f, 0.6666667f, -0.44444445f, -0.8888889f, 0.8888889f, -0.44444445f, -0.6666667f, 0.8888889f, -0.44444445f, -0.44444445f, 0.8888889f, -0.44444445f, -0.22222222f, 0.8888889f, -0.44444445f, 0.0f, 0.8888889f, -0.44444445f, 0.22222222f, 0.8888889f, -0.44444445f, 0.44444445f, 0.8888889f, -0.44444445f, 0.6666667f, 0.8888889f, -0.44444445f, 0.8888889f, 0.8888889f, -0.44444445f, -0.8888889f, -0.8888889f, -0.22222222f, -0.6666667f, -0.8888889f, -0.22222222f, -0.44444445f, -0.8888889f, -0.22222222f, -0.22222222f, -0.8888889f, -0.22222222f, 0.0f, -0.8888889f, -0.22222222f, 0.22222222f, -0.8888889f, -0.22222222f, 0.44444445f, -0.8888889f, -0.22222222f, 0.6666667f, -0.8888889f, -0.22222222f, 0.8888889f, -0.8888889f, -0.22222222f, -0.8888889f, -0.6666667f, -0.22222222f, -0.6666667f, -0.6666667f, -0.22222222f, -0.44444445f, -0.6666667f, -0.22222222f, -0.22222222f, -0.6666667f, -0.22222222f, 0.0f, -0.6666667f, -0.22222222f, 0.22222222f, -0.6666667f, -0.22222222f, 0.44444445f, -0.6666667f, -0.22222222f, 0.6666667f, -0.6666667f, -0.22222222f, 0.8888889f, -0.6666667f, -0.22222222f, -0.8888889f, -0.44444445f, -0.22222222f, -0.6666667f, -0.44444445f, -0.22222222f, -0.44444445f, -0.44444445f, -0.22222222f, -0.22222222f, -0.44444445f, -0.22222222f, 0.0f, -0.44444445f, -0.22222222f, 0.22222222f, -0.44444445f, -0.22222222f, 0.44444445f, -0.44444445f, -0.22222222f, 0.6666667f, -0.44444445f, -0.22222222f, 0.8888889f, -0.44444445f, -0.22222222f, -0.8888889f, -0.22222222f, -0.22222222f, -0.6666667f, -0.22222222f, -0.22222222f, -0.44444445f, -0.22222222f, -0.22222222f, -0.22222222f, -0.22222222f, -0.22222222f, 0.0f, -0.22222222f, -0.22222222f, 0.22222222f, -0.22222222f, -0.22222222f, 0.44444445f, -0.22222222f, -0.22222222f, 0.6666667f, -0.22222222f, -0.22222222f, 0.8888889f, -0.22222222f, -0.22222222f, -0.8888889f, 0.0f, -0.22222222f, -0.6666667f, 0.0f, -0.22222222f, -0.44444445f, 0.0f, -0.22222222f, -0.22222222f, 0.0f, -0.22222222f, 0.0f, 0.0f, -0.22222222f, 0.22222222f, 0.0f, -0.22222222f, 0.44444445f, 0.0f, -0.22222222f, 0.6666667f, 0.0f, -0.22222222f, 0.8888889f, 0.0f, -0.22222222f, -0.8888889f, 0.22222222f, -0.22222222f, -0.6666667f, 0.22222222f, -0.22222222f, -0.44444445f, 0.22222222f, -0.22222222f, -0.22222222f, 0.22222222f, -0.22222222f, 0.0f, 0.22222222f, -0.22222222f, 0.22222222f, 0.22222222f, -0.22222222f, 0.44444445f, 0.22222222f, -0.22222222f, 0.6666667f, 0.22222222f, -0.22222222f, 0.8888889f, 0.22222222f, -0.22222222f, -0.8888889f, 0.44444445f, -0.22222222f, -0.6666667f, 0.44444445f, -0.22222222f, -0.44444445f, 0.44444445f, -0.22222222f, -0.22222222f, 0.44444445f, -0.22222222f, 0.0f, 0.44444445f, -0.22222222f, 0.22222222f, 0.44444445f, -0.22222222f, 0.44444445f, 0.44444445f, -0.22222222f, 0.6666667f, 0.44444445f, -0.22222222f, 0.8888889f, 0.44444445f, -0.22222222f, -0.8888889f, 0.6666667f, -0.22222222f, -0.6666667f, 0.6666667f, -0.22222222f, -0.44444445f, 0.6666667f, -0.22222222f, -0.22222222f, 0.6666667f, -0.22222222f, 0.0f, 0.6666667f, -0.22222222f, 0.22222222f, 0.6666667f, -0.22222222f, 0.44444445f, 0.6666667f, -0.22222222f, 0.6666667f, 0.6666667f, -0.22222222f, 0.8888889f, 0.6666667f, -0.22222222f, -0.8888889f, 0.8888889f, -0.22222222f, -0.6666667f, 0.8888889f, -0.22222222f, -0.44444445f, 0.8888889f, -0.22222222f, -0.22222222f, 0.8888889f, -0.22222222f, 0.0f, 0.8888889f, -0.22222222f, 0.22222222f, 0.8888889f, -0.22222222f, 0.44444445f, 0.8888889f, -0.22222222f, 0.6666667f, 0.8888889f, -0.22222222f, 0.8888889f, 0.8888889f, -0.22222222f, -0.8888889f, -0.8888889f, 0.0f, -0.6666667f, -0.8888889f, 0.0f, -0.44444445f, -0.8888889f, 0.0f, -0.22222222f, -0.8888889f, 0.0f, 0.0f, -0.8888889f, 0.0f, 0.22222222f, -0.8888889f, 0.0f, 0.44444445f, -0.8888889f, 0.0f, 0.6666667f, -0.8888889f, 0.0f, 0.8888889f, -0.8888889f, 0.0f, -0.8888889f, -0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.0f, -0.44444445f, -0.6666667f, 0.0f, -0.22222222f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.0f, 0.22222222f, -0.6666667f, 0.0f, 0.44444445f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.0f, 0.8888889f, -0.6666667f, 0.0f, -0.8888889f, -0.44444445f, 0.0f, -0.6666667f, -0.44444445f, 0.0f, -0.44444445f, -0.44444445f, 0.0f, -0.22222222f, -0.44444445f, 0.0f, 0.0f, -0.44444445f, 0.0f, 0.22222222f, -0.44444445f, 0.0f, 0.44444445f, -0.44444445f, 0.0f, 0.6666667f, -0.44444445f, 0.0f, 0.8888889f, -0.44444445f, 0.0f, -0.8888889f, -0.22222222f, 0.0f, -0.6666667f, -0.22222222f, 0.0f, -0.44444445f, -0.22222222f, 0.0f, -0.22222222f, -0.22222222f, 0.0f, 0.0f, -0.22222222f, 0.0f, 0.22222222f, -0.22222222f, 0.0f, 0.44444445f, -0.22222222f, 0.0f, 0.6666667f, -0.22222222f, 0.0f, 0.8888889f, -0.22222222f, 0.0f, -0.8888889f, 0.0f, 0.0f, -0.6666667f, 0.0f, 0.0f, -0.44444445f, 0.0f, 0.0f, -0.22222222f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.22222222f, 0.0f, 0.0f, 0.44444445f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.0f, 0.8888889f, 0.0f, 0.0f, -0.8888889f, 0.22222222f, 0.0f, -0.6666667f, 0.22222222f, 0.0f, -0.44444445f, 0.22222222f, 0.0f, -0.22222222f, 0.22222222f, 0.0f, 0.0f, 0.22222222f, 0.0f, 0.22222222f, 0.22222222f, 0.0f, 0.44444445f, 0.22222222f, 0.0f, 0.6666667f, 0.22222222f, 0.0f, 0.8888889f, 0.22222222f, 0.0f, -0.8888889f, 0.44444445f, 0.0f, -0.6666667f, 0.44444445f, 0.0f, -0.44444445f, 0.44444445f, 0.0f, -0.22222222f, 0.44444445f, 0.0f, 0.0f, 0.44444445f, 0.0f, 0.22222222f, 0.44444445f, 0.0f, 0.44444445f, 0.44444445f, 0.0f, 0.6666667f, 0.44444445f, 0.0f, 0.8888889f, 0.44444445f, 0.0f, -0.8888889f, 0.6666667f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, -0.44444445f, 0.6666667f, 0.0f, -0.22222222f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.22222222f, 0.6666667f, 0.0f, 0.44444445f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, 0.8888889f, 0.6666667f, 0.0f, -0.8888889f, 0.8888889f, 0.0f, -0.6666667f, 0.8888889f, 0.0f, -0.44444445f, 0.8888889f, 0.0f, -0.22222222f, 0.8888889f, 0.0f, 0.0f, 0.8888889f, 0.0f, 0.22222222f, 0.8888889f, 0.0f, 0.44444445f, 0.8888889f, 0.0f, 0.6666667f, 0.8888889f, 0.0f, 0.8888889f, 0.8888889f, 0.0f, -0.8888889f, -0.8888889f, 0.22222222f, -0.6666667f, -0.8888889f, 0.22222222f, -0.44444445f, -0.8888889f, 0.22222222f, -0.22222222f, -0.8888889f, 0.22222222f, 0.0f, -0.8888889f, 0.22222222f, 0.22222222f, -0.8888889f, 0.22222222f, 0.44444445f, -0.8888889f, 0.22222222f, 0.6666667f, -0.8888889f, 0.22222222f, 0.8888889f, -0.8888889f, 0.22222222f, -0.8888889f, -0.6666667f, 0.22222222f, -0.6666667f, -0.6666667f, 0.22222222f, -0.44444445f, -0.6666667f, 0.22222222f, -0.22222222f, -0.6666667f, 0.22222222f, 0.0f, -0.6666667f, 0.22222222f, 0.22222222f, -0.6666667f, 0.22222222f, 0.44444445f, -0.6666667f, 0.22222222f, 0.6666667f, -0.6666667f, 0.22222222f, 0.8888889f, -0.6666667f, 0.22222222f, -0.8888889f, -0.44444445f, 0.22222222f, -0.6666667f, -0.44444445f, 0.22222222f, -0.44444445f, -0.44444445f, 0.22222222f, -0.22222222f, -0.44444445f, 0.22222222f, 0.0f, -0.44444445f, 0.22222222f, 0.22222222f, -0.44444445f, 0.22222222f, 0.44444445f, -0.44444445f, 0.22222222f, 0.6666667f, -0.44444445f, 0.22222222f, 0.8888889f, -0.44444445f, 0.22222222f, -0.8888889f, -0.22222222f, 0.22222222f, -0.6666667f, -0.22222222f, 0.22222222f, -0.44444445f, -0.22222222f, 0.22222222f, -0.22222222f, -0.22222222f, 0.22222222f, 0.0f, -0.22222222f, 0.22222222f, 0.22222222f, -0.22222222f, 0.22222222f, 0.44444445f, -0.22222222f, 0.22222222f, 0.6666667f, -0.22222222f, 0.22222222f, 0.8888889f, -0.22222222f, 0.22222222f, -0.8888889f, 0.0f, 0.22222222f, -0.6666667f, 0.0f, 0.22222222f, -0.44444445f, 0.0f, 0.22222222f, -0.22222222f, 0.0f, 0.22222222f, 0.0f, 0.0f, 0.22222222f, 0.22222222f, 0.0f, 0.22222222f, 0.44444445f, 0.0f, 0.22222222f, 0.6666667f, 0.0f, 0.22222222f, 0.8888889f, 0.0f, 0.22222222f, -0.8888889f, 0.22222222f, 0.22222222f, -0.6666667f, 0.22222222f, 0.22222222f, -0.44444445f, 0.22222222f, 0.22222222f, -0.22222222f, 0.22222222f, 0.22222222f, 0.0f, 0.22222222f, 0.22222222f, 0.22222222f, 0.22222222f, 0.22222222f, 0.44444445f, 0.22222222f, 0.22222222f, 0.6666667f, 0.22222222f, 0.22222222f, 0.8888889f, 0.22222222f, 0.22222222f, -0.8888889f, 0.44444445f, 0.22222222f, -0.6666667f, 0.44444445f, 0.22222222f, -0.44444445f, 0.44444445f, 0.22222222f, -0.22222222f, 0.44444445f, 0.22222222f, 0.0f, 0.44444445f, 0.22222222f, 0.22222222f, 0.44444445f, 0.22222222f, 0.44444445f, 0.44444445f, 0.22222222f, 0.6666667f, 0.44444445f, 0.22222222f, 0.8888889f, 0.44444445f, 0.22222222f, -0.8888889f, 0.6666667f, 0.22222222f, -0.6666667f, 0.6666667f, 0.22222222f, -0.44444445f, 0.6666667f, 0.22222222f, -0.22222222f, 0.6666667f, 0.22222222f, 0.0f, 0.6666667f, 0.22222222f, 0.22222222f, 0.6666667f, 0.22222222f, 0.44444445f, 0.6666667f, 0.22222222f, 0.6666667f, 0.6666667f, 0.22222222f, 0.8888889f, 0.6666667f, 0.22222222f, -0.8888889f, 0.8888889f, 0.22222222f, -0.6666667f, 0.8888889f, 0.22222222f, -0.44444445f, 0.8888889f, 0.22222222f, -0.22222222f, 0.8888889f, 0.22222222f, 0.0f, 0.8888889f, 0.22222222f, 0.22222222f, 0.8888889f, 0.22222222f, 0.44444445f, 0.8888889f, 0.22222222f, 0.6666667f, 0.8888889f, 0.22222222f, 0.8888889f, 0.8888889f, 0.22222222f, -0.8888889f, -0.8888889f, 0.44444445f, -0.6666667f, -0.8888889f, 0.44444445f, -0.44444445f, -0.8888889f, 0.44444445f, -0.22222222f, -0.8888889f, 0.44444445f, 0.0f, -0.8888889f, 0.44444445f, 0.22222222f, -0.8888889f, 0.44444445f, 0.44444445f, -0.8888889f, 0.44444445f, 0.6666667f, -0.8888889f, 0.44444445f, 0.8888889f, -0.8888889f, 0.44444445f, -0.8888889f, -0.6666667f, 0.44444445f, -0.6666667f, -0.6666667f, 0.44444445f, -0.44444445f, -0.6666667f, 0.44444445f, -0.22222222f, -0.6666667f, 0.44444445f, 0.0f, -0.6666667f, 0.44444445f, 0.22222222f, -0.6666667f, 0.44444445f, 0.44444445f, -0.6666667f, 0.44444445f, 0.6666667f, -0.6666667f, 0.44444445f, 0.8888889f, -0.6666667f, 0.44444445f, -0.8888889f, -0.44444445f, 0.44444445f, -0.6666667f, -0.44444445f, 0.44444445f, -0.44444445f, -0.44444445f, 0.44444445f, -0.22222222f, -0.44444445f, 0.44444445f, 0.0f, -0.44444445f, 0.44444445f, 0.22222222f, -0.44444445f, 0.44444445f, 0.44444445f, -0.44444445f, 0.44444445f, 0.6666667f, -0.44444445f, 0.44444445f, 0.8888889f, -0.44444445f, 0.44444445f, -0.8888889f, -0.22222222f, 0.44444445f, -0.6666667f, -0.22222222f, 0.44444445f, -0.44444445f, -0.22222222f, 0.44444445f, -0.22222222f, -0.22222222f, 0.44444445f, 0.0f, -0.22222222f, 0.44444445f, 0.22222222f, -0.22222222f, 0.44444445f, 0.44444445f, -0.22222222f, 0.44444445f, 0.6666667f, -0.22222222f, 0.44444445f, 0.8888889f, -0.22222222f, 0.44444445f, -0.8888889f, 0.0f, 0.44444445f, -0.6666667f, 0.0f, 0.44444445f, -0.44444445f, 0.0f, 0.44444445f, -0.22222222f, 0.0f, 0.44444445f, 0.0f, 0.0f, 0.44444445f, 0.22222222f, 0.0f, 0.44444445f, 0.44444445f, 0.0f, 0.44444445f, 0.6666667f, 0.0f, 0.44444445f, 0.8888889f, 0.0f, 0.44444445f, -0.8888889f, 0.22222222f, 0.44444445f, -0.6666667f, 0.22222222f, 0.44444445f, -0.44444445f, 0.22222222f, 0.44444445f, -0.22222222f, 0.22222222f, 0.44444445f, 0.0f, 0.22222222f, 0.44444445f, 0.22222222f, 0.22222222f, 0.44444445f, 0.44444445f, 0.22222222f, 0.44444445f, 0.6666667f, 0.22222222f, 0.44444445f, 0.8888889f, 0.22222222f, 0.44444445f, -0.8888889f, 0.44444445f, 0.44444445f, -0.6666667f, 0.44444445f, 0.44444445f, -0.44444445f, 0.44444445f, 0.44444445f, -0.22222222f, 0.44444445f, 0.44444445f, 0.0f, 0.44444445f, 0.44444445f, 0.22222222f, 0.44444445f, 0.44444445f, 0.44444445f, 0.44444445f, 0.44444445f, 0.6666667f, 0.44444445f, 0.44444445f, 0.8888889f, 0.44444445f, 0.44444445f, -0.8888889f, 0.6666667f, 0.44444445f, -0.6666667f, 0.6666667f, 0.44444445f, -0.44444445f, 0.6666667f, 0.44444445f, -0.22222222f, 0.6666667f, 0.44444445f, 0.0f, 0.6666667f, 0.44444445f, 0.22222222f, 0.6666667f, 0.44444445f, 0.44444445f, 0.6666667f, 0.44444445f, 0.6666667f, 0.6666667f, 0.44444445f, 0.8888889f, 0.6666667f, 0.44444445f, -0.8888889f, 0.8888889f, 0.44444445f, -0.6666667f, 0.8888889f, 0.44444445f, -0.44444445f, 0.8888889f, 0.44444445f, -0.22222222f, 0.8888889f, 0.44444445f, 0.0f, 0.8888889f, 0.44444445f, 0.22222222f, 0.8888889f, 0.44444445f, 0.44444445f, 0.8888889f, 0.44444445f, 0.6666667f, 0.8888889f, 0.44444445f, 0.8888889f, 0.8888889f, 0.44444445f, -0.8888889f, -0.8888889f, 0.6666667f, -0.6666667f, -0.8888889f, 0.6666667f, -0.44444445f, -0.8888889f, 0.6666667f, -0.22222222f, -0.8888889f, 0.6666667f, 0.0f, -0.8888889f, 0.6666667f, 0.22222222f, -0.8888889f, 0.6666667f, 0.44444445f, -0.8888889f, 0.6666667f, 0.6666667f, -0.8888889f, 0.6666667f, 0.8888889f, -0.8888889f, 0.6666667f, -0.8888889f, -0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, 0.6666667f, -0.44444445f, -0.6666667f, 0.6666667f, -0.22222222f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, 0.6666667f, 0.22222222f, -0.6666667f, 0.6666667f, 0.44444445f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, 0.6666667f, 0.8888889f, -0.6666667f, 0.6666667f, -0.8888889f, -0.44444445f, 0.6666667f, -0.6666667f, -0.44444445f, 0.6666667f, -0.44444445f, -0.44444445f, 0.6666667f, -0.22222222f, -0.44444445f, 0.6666667f, 0.0f, -0.44444445f, 0.6666667f, 0.22222222f, -0.44444445f, 0.6666667f, 0.44444445f, -0.44444445f, 0.6666667f, 0.6666667f, -0.44444445f, 0.6666667f, 0.8888889f, -0.44444445f, 0.6666667f, -0.8888889f, -0.22222222f, 0.6666667f, -0.6666667f, -0.22222222f, 0.6666667f, -0.44444445f, -0.22222222f, 0.6666667f, -0.22222222f, -0.22222222f, 0.6666667f, 0.0f, -0.22222222f, 0.6666667f, 0.22222222f, -0.22222222f, 0.6666667f, 0.44444445f, -0.22222222f, 0.6666667f, 0.6666667f, -0.22222222f, 0.6666667f, 0.8888889f, -0.22222222f, 0.6666667f, -0.8888889f, 0.0f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, -0.44444445f, 0.0f, 0.6666667f, -0.22222222f, 0.0f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.22222222f, 0.0f, 0.6666667f, 0.44444445f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, 0.8888889f, 0.0f, 0.6666667f, -0.8888889f, 0.22222222f, 0.6666667f, -0.6666667f, 0.22222222f, 0.6666667f, -0.44444445f, 0.22222222f, 0.6666667f, -0.22222222f, 0.22222222f, 0.6666667f, 0.0f, 0.22222222f, 0.6666667f, 0.22222222f, 0.22222222f, 0.6666667f, 0.44444445f, 0.22222222f, 0.6666667f, 0.6666667f, 0.22222222f, 0.6666667f, 0.8888889f, 0.22222222f, 0.6666667f, -0.8888889f, 0.44444445f, 0.6666667f, -0.6666667f, 0.44444445f, 0.6666667f, -0.44444445f, 0.44444445f, 0.6666667f, -0.22222222f, 0.44444445f, 0.6666667f, 0.0f, 0.44444445f, 0.6666667f, 0.22222222f, 0.44444445f, 0.6666667f, 0.44444445f, 0.44444445f, 0.6666667f, 0.6666667f, 0.44444445f, 0.6666667f, 0.8888889f, 0.44444445f, 0.6666667f, -0.8888889f, 0.6666667f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, -0.44444445f, 0.6666667f, 0.6666667f, -0.22222222f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.22222222f, 0.6666667f, 0.6666667f, 0.44444445f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f, 0.8888889f, 0.6666667f, 0.6666667f, -0.8888889f, 0.8888889f, 0.6666667f, -0.6666667f, 0.8888889f, 0.6666667f, -0.44444445f, 0.8888889f, 0.6666667f, -0.22222222f, 0.8888889f, 0.6666667f, 0.0f, 0.8888889f, 0.6666667f, 0.22222222f, 0.8888889f, 0.6666667f, 0.44444445f, 0.8888889f, 0.6666667f, 0.6666667f, 0.8888889f, 0.6666667f, 0.8888889f, 0.8888889f, 0.6666667f, -0.8888889f, -0.8888889f, 0.8888889f, -0.6666667f, -0.8888889f, 0.8888889f, -0.44444445f, -0.8888889f, 0.8888889f, -0.22222222f, -0.8888889f, 0.8888889f, 0.0f, -0.8888889f, 0.8888889f, 0.22222222f, -0.8888889f, 0.8888889f, 0.44444445f, -0.8888889f, 0.8888889f, 0.6666667f, -0.8888889f, 0.8888889f, 0.8888889f, -0.8888889f, 0.8888889f, -0.8888889f, -0.6666667f, 0.8888889f, -0.6666667f, -0.6666667f, 0.8888889f, -0.44444445f, -0.6666667f, 0.8888889f, -0.22222222f, -0.6666667f, 0.8888889f, 0.0f, -0.6666667f, 0.8888889f, 0.22222222f, -0.6666667f, 0.8888889f, 0.44444445f, -0.6666667f, 0.8888889f, 0.6666667f, -0.6666667f, 0.8888889f, 0.8888889f, -0.6666667f, 0.8888889f, -0.8888889f, -0.44444445f, 0.8888889f, -0.6666667f, -0.44444445f, 0.8888889f, -0.44444445f, -0.44444445f, 0.8888889f, -0.22222222f, -0.44444445f, 0.8888889f, 0.0f, -0.44444445f, 0.8888889f, 0.22222222f, -0.44444445f, 0.8888889f, 0.44444445f, -0.44444445f, 0.8888889f, 0.6666667f, -0.44444445f, 0.8888889f, 0.8888889f, -0.44444445f, 0.8888889f, -0.8888889f, -0.22222222f, 0.8888889f, -0.6666667f, -0.22222222f, 0.8888889f, -0.44444445f, -0.22222222f, 0.8888889f, -0.22222222f, -0.22222222f, 0.8888889f, 0.0f, -0.22222222f, 0.8888889f, 0.22222222f, -0.22222222f, 0.8888889f, 0.44444445f, -0.22222222f, 0.8888889f, 0.6666667f, -0.22222222f, 0.8888889f, 0.8888889f, -0.22222222f, 0.8888889f, -0.8888889f, 0.0f, 0.8888889f, -0.6666667f, 0.0f, 0.8888889f, -0.44444445f, 0.0f, 0.8888889f, -0.22222222f, 0.0f, 0.8888889f, 0.0f, 0.0f, 0.8888889f, 0.22222222f, 0.0f, 0.8888889f, 0.44444445f, 0.0f, 0.8888889f, 0.6666667f, 0.0f, 0.8888889f, 0.8888889f, 0.0f, 0.8888889f, -0.8888889f, 0.22222222f, 0.8888889f, -0.6666667f, 0.22222222f, 0.8888889f, -0.44444445f, 0.22222222f, 0.8888889f, -0.22222222f, 0.22222222f, 0.8888889f, 0.0f, 0.22222222f, 0.8888889f, 0.22222222f, 0.22222222f, 0.8888889f, 0.44444445f, 0.22222222f, 0.8888889f, 0.6666667f, 0.22222222f, 0.8888889f, 0.8888889f, 0.22222222f, 0.8888889f, -0.8888889f, 0.44444445f, 0.8888889f, -0.6666667f, 0.44444445f, 0.8888889f, -0.44444445f, 0.44444445f, 0.8888889f, -0.22222222f, 0.44444445f, 0.8888889f, 0.0f, 0.44444445f, 0.8888889f, 0.22222222f, 0.44444445f, 0.8888889f, 0.44444445f, 0.44444445f, 0.8888889f, 0.6666667f, 0.44444445f, 0.8888889f, 0.8888889f, 0.44444445f, 0.8888889f, -0.8888889f, 0.6666667f, 0.8888889f, -0.6666667f, 0.6666667f, 0.8888889f, -0.44444445f, 0.6666667f, 0.8888889f, -0.22222222f, 0.6666667f, 0.8888889f, 0.0f, 0.6666667f, 0.8888889f, 0.22222222f, 0.6666667f, 0.8888889f, 0.44444445f, 0.6666667f, 0.8888889f, 0.6666667f, 0.6666667f, 0.8888889f, 0.8888889f, 0.6666667f, 0.8888889f, -0.8888889f, 0.8888889f, 0.8888889f, -0.6666667f, 0.8888889f, 0.8888889f, -0.44444445f, 0.8888889f, 0.8888889f, -0.22222222f, 0.8888889f, 0.8888889f, 0.0f, 0.8888889f, 0.8888889f, 0.22222222f, 0.8888889f, 0.8888889f, 0.44444445f, 0.8888889f, 0.8888889f, 0.6666667f, 0.8888889f, 0.8888889f, 0.8888889f, 0.8888889f, 0.8888889f};
            table_ab1_codelength = new int[]{0, 5, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
            table_ab1_groupingtables = new float[][]{null, grouping_5bits, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
            table_ab1_factor = new float[]{0.0f, 0.5f, 0.25f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.1035156E-5f, 3.0517578E-5f};
            table_ab1_c = new float[]{0.0f, 1.3333334f, 1.1428572f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.000061f, 1.0000305f, 1.0000153f};
            table_ab1_d = new float[]{0.0f, 0.5f, 0.25f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.103516E-5f, 3.051758E-5f};
            table_ab234_groupingtables = new float[][]{null, grouping_5bits, grouping_7bits, null, grouping_10bits, null, null, null, null, null, null, null, null, null, null, null};
            table_ab2_codelength = new int[]{0, 5, 7, 3, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16};
            table_ab2_factor = new float[]{0.0f, 0.5f, 0.25f, 0.25f, 0.125f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 3.0517578E-5f};
            table_ab2_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.1428572f, 1.7777778f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.0000153f};
            table_ab2_d = new float[]{0.0f, 0.5f, 0.5f, 0.25f, 0.5f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 3.051758E-5f};
            table_ab3_codelength = new int[]{0, 5, 7, 3, 10, 4, 5, 16};
            table_ab3_factor = new float[]{0.0f, 0.5f, 0.25f, 0.25f, 0.125f, 0.125f, 0.0625f, 3.0517578E-5f};
            table_ab3_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.1428572f, 1.7777778f, 1.0666667f, 1.032258f, 1.0000153f};
            table_ab3_d = new float[]{0.0f, 0.5f, 0.5f, 0.25f, 0.5f, 0.125f, 0.0625f, 3.051758E-5f};
            table_ab4_codelength = new int[]{0, 5, 7, 16};
            table_ab4_factor = new float[]{0.0f, 0.5f, 0.25f, 3.0517578E-5f};
            table_ab4_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.0000153f};
            table_ab4_d = new float[]{0.0f, 0.5f, 0.5f, 3.051758E-5f};
            table_cd_codelength = new int[]{0, 5, 7, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
            table_cd_groupingtables = new float[][]{null, grouping_5bits, grouping_7bits, grouping_10bits, null, null, null, null, null, null, null, null, null, null, null, null};
            table_cd_factor = new float[]{0.0f, 0.5f, 0.25f, 0.125f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.1035156E-5f};
            table_cd_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.7777778f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.000061f, 1.0000305f};
            table_cd_d = new float[]{0.0f, 0.5f, 0.5f, 0.5f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.103516E-5f};
        }
    }
}

