/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.util.regex.Pattern;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public class Protocol
implements IProtocol {
    private static final Pattern patternSpace;
    private static final Pattern patternComma;
    private final String providedProtocol;
    private static final NMSLException \u6536\u7eb3\u5b8c\u6bd5;

    public Protocol(String providedProtocol) {
        if (providedProtocol == null) {
            throw new IllegalArgumentException();
        }
        this.providedProtocol = providedProtocol;
    }

    @Override
    public boolean acceptProvidedProtocol(String inputProtocolHeader) {
        String[] headers;
        if ("".equals(this.providedProtocol)) {
            return true;
        }
        String protocolHeader = patternSpace.matcher(inputProtocolHeader).replaceAll("");
        for (String header : headers = patternComma.split(protocolHeader)) {
            if (!this.providedProtocol.equals(header)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProvidedProtocol() {
        return this.providedProtocol;
    }

    @Override
    public IProtocol copyInstance() {
        return new Protocol(this.getProvidedProtocol());
    }

    @Override
    public String toString() {
        return this.getProvidedProtocol();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.providedProtocol.equals(protocol.providedProtocol);
    }

    public int hashCode() {
        return this.providedProtocol.hashCode();
    }

    static {
        \u6536\u7eb3\u5b8c\u6bd5 = new NMSLException("\u2df1\uc81c\ua3da\ub484\ud505\u7f21\u30f8\u36ce\u7fca\uc5a9\u69b9\u3908\uf572\u6938\u9453\u562e\u240b\u5a4c\uc04e\uaf72\u49b3\uc609\ub3b7\u9b2f\u7f05\u52f7\ue284\u609a\uff43\ue11f\u49ab\ue651\ueec9\u8ab3\u5343\u7782\uf18c\u8880\u5f68\uf5a6\ubf7e\ue8da\ue003\uab08\u57f3\ub26e\ua9e9\u778e");
        patternSpace = Pattern.compile(" ");
        patternComma = Pattern.compile(",");
    }
}

