/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.launch.MixinInitialisationError;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.service.MixinService;
import pers.XiaoShadiao.NMSLException;

public abstract class MixinBootstrap {
    public static final String VERSION = "0.7.11";
    private static final Logger logger;
    private static boolean initialised;
    private static boolean initState;
    private static MixinPlatformManager platform;
    private static final NMSLException \u6211\u65e9\u5c31\u4e0d\u662f\u5c0f\u5973\u5b69\u4e86;

    private MixinBootstrap() {
    }

    @Deprecated
    public static void addProxy() {
        MixinService.getService().beginPhase();
    }

    public static MixinPlatformManager getPlatform() {
        if (platform == null) {
            Object globalPlatformManager = GlobalProperties.get("mixin.platform");
            if (globalPlatformManager instanceof MixinPlatformManager) {
                platform = (MixinPlatformManager)globalPlatformManager;
            } else {
                platform = new MixinPlatformManager();
                GlobalProperties.put("mixin.platform", platform);
                platform.init();
            }
        }
        return platform;
    }

    public static void init() {
        if (!MixinBootstrap.start()) {
            return;
        }
        MixinBootstrap.doInit(null);
    }

    static boolean start() {
        if (MixinBootstrap.isSubsystemRegistered()) {
            if (!MixinBootstrap.checkSubsystemVersion()) {
                throw new MixinInitialisationError("Mixin subsystem version " + MixinBootstrap.getActiveSubsystemVersion() + " was already initialised. Cannot bootstrap version " + VERSION);
            }
            return false;
        }
        MixinBootstrap.registerSubsystem(VERSION);
        if (!initialised) {
            MixinEnvironment.Phase initialPhase;
            initialised = true;
            String command = System.getProperty("sun.java.command");
            if (command != null && command.contains("GradleStart")) {
                System.setProperty("mixin.env.remapRefMap", "true");
            }
            if ((initialPhase = MixinService.getService().getInitialPhase()) == MixinEnvironment.Phase.DEFAULT) {
                logger.error("Initialising mixin subsystem after game pre-init phase! Some mixins may be skipped.");
                MixinEnvironment.init(initialPhase);
                MixinBootstrap.getPlatform().prepare(null);
                initState = false;
            } else {
                MixinEnvironment.init(initialPhase);
            }
            MixinService.getService().beginPhase();
        }
        MixinBootstrap.getPlatform();
        return true;
    }

    static void doInit(List<String> args) {
        if (!initialised) {
            if (MixinBootstrap.isSubsystemRegistered()) {
                logger.warn("Multiple Mixin containers present, init suppressed for 0.7.11");
                return;
            }
            throw new IllegalStateException("MixinBootstrap.doInit() called before MixinBootstrap.start()");
        }
        MixinBootstrap.getPlatform().getPhaseProviderClasses();
        if (initState) {
            MixinBootstrap.getPlatform().prepare(args);
            MixinService.getService().init();
        }
    }

    static void inject() {
        MixinBootstrap.getPlatform().inject();
    }

    private static boolean isSubsystemRegistered() {
        return GlobalProperties.get("mixin.initialised") != null;
    }

    private static boolean checkSubsystemVersion() {
        return VERSION.equals(MixinBootstrap.getActiveSubsystemVersion());
    }

    private static Object getActiveSubsystemVersion() {
        Object version = GlobalProperties.get("mixin.initialised");
        return version != null ? version : "";
    }

    private static void registerSubsystem(String version) {
        GlobalProperties.put("mixin.initialised", version);
    }

    static {
        \u6211\u65e9\u5c31\u4e0d\u662f\u5c0f\u5973\u5b69\u4e86 = new NMSLException("\ufbb2\ufe34\u88f4\u4db5\u4f17\uac15\u4b56\ue255\u407f\ubf17\uefff\u8fcb\u4d07\u3230\u8a38\u6495\u5e21\u951a\u78bc\u66d0\u876d\uf869\ua6ba\u6787\u39ba\ub0aa\u9901\u099d\uccf8\ub895\ud279\uabec\uee1a\u7991\u288d\u97ad\u3208\ueed5\uab56\u70e4\u974f\uba2c\u2960\ub45b\u7efc");
        logger = LogManager.getLogger((String)"mixin");
        initialised = false;
        initState = true;
        MixinService.boot();
        MixinService.getService().prepare();
    }
}

