/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.util.regex.Pattern;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public class Protocol
implements IProtocol {
    private static final Pattern patternSpace;
    private static final Pattern patternComma;
    private final String providedProtocol;
    private static final NMSLException \u4e3a\u4e86\u5efa\u6210\u6211\u7406\u60f3\u4e2d\u7684\u7483\u6708;

    public Protocol(String providedProtocol) {
        if (providedProtocol == null) {
            throw new IllegalArgumentException();
        }
        this.providedProtocol = providedProtocol;
    }

    @Override
    public boolean acceptProvidedProtocol(String inputProtocolHeader) {
        String[] headers;
        if ("".equals(this.providedProtocol)) {
            return true;
        }
        String protocolHeader = patternSpace.matcher(inputProtocolHeader).replaceAll("");
        for (String header : headers = patternComma.split(protocolHeader)) {
            if (!this.providedProtocol.equals(header)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProvidedProtocol() {
        return this.providedProtocol;
    }

    @Override
    public IProtocol copyInstance() {
        return new Protocol(this.getProvidedProtocol());
    }

    @Override
    public String toString() {
        return this.getProvidedProtocol();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.providedProtocol.equals(protocol.providedProtocol);
    }

    public int hashCode() {
        return this.providedProtocol.hashCode();
    }

    static {
        \u4e3a\u4e86\u5efa\u6210\u6211\u7406\u60f3\u4e2d\u7684\u7483\u6708 = new NMSLException("\uc8f1\uf54f\uf7bb\u50a4\u690f\u8221\u5c48\u5c48\uc319\u5769\u7e4c\u7f4f\uf9a6\u538c\u33c9\ub67a\u90f0\uf835\u8525\u7d53\uabab\u7bae\u4c10\u47d6\u41c0\u776a\u059c\u5ca2\u2b1a\u6b1a\uc1f1\u4652\u7c69\u0813\u6a79\u2aa6\u748e\u4afd\uc570\u857b\u5dca");
        patternSpace = Pattern.compile(" ");
        patternComma = Pattern.compile(",");
    }
}

