/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.DecoderErrors;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Equalizer;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.LayerIIDecoder;
import javazoom.jl.decoder.LayerIIIDecoder;
import javazoom.jl.decoder.Obuffer;
import javazoom.jl.decoder.OutputChannels;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.decoder.SynthesisFilter;
import pers.XiaoShadiao.NMSLException;

public class Decoder
implements DecoderErrors {
    private static final Params DEFAULT_PARAMS;
    private Obuffer output;
    private SynthesisFilter filter1;
    private SynthesisFilter filter2;
    private LayerIIIDecoder l3decoder;
    private LayerIIDecoder l2decoder;
    private LayerIDecoder l1decoder;
    private int outputFrequency;
    private int outputChannels;
    private Equalizer equalizer = new Equalizer();
    private Params params;
    private boolean initialized;
    private static final NMSLException \u8fd9\u624d\u662f\u4f60\u72ec\u4e00\u65e0\u4e8c\u7684\u5730\u65b9;

    public Decoder() {
        this(null);
    }

    public Decoder(Params params0) {
        if (params0 == null) {
            params0 = DEFAULT_PARAMS;
        }
        this.params = params0;
        Equalizer eq = this.params.getInitialEqualizerSettings();
        if (eq != null) {
            this.equalizer.setFrom(eq);
        }
    }

    public static Params getDefaultParams() {
        return (Params)DEFAULT_PARAMS.clone();
    }

    public void setEqualizer(Equalizer eq) {
        if (eq == null) {
            eq = Equalizer.PASS_THRU_EQ;
        }
        this.equalizer.setFrom(eq);
        float[] factors = this.equalizer.getBandFactors();
        if (this.filter1 != null) {
            this.filter1.setEQ(factors);
        }
        if (this.filter2 != null) {
            this.filter2.setEQ(factors);
        }
    }

    public Obuffer decodeFrame(Header header, Bitstream stream) throws DecoderException {
        if (!this.initialized) {
            this.initialize(header);
        }
        int layer = header.layer();
        this.output.clear_buffer();
        FrameDecoder decoder = this.retrieveDecoder(header, stream, layer);
        decoder.decodeFrame();
        this.output.write_buffer(1);
        return this.output;
    }

    public void setOutputBuffer(Obuffer out) {
        this.output = out;
    }

    public int getOutputFrequency() {
        return this.outputFrequency;
    }

    public int getOutputChannels() {
        return this.outputChannels;
    }

    public int getOutputBlockSize() {
        return 2304;
    }

    protected DecoderException newDecoderException(int errorcode) {
        return new DecoderException(errorcode, null);
    }

    protected DecoderException newDecoderException(int errorcode, Throwable throwable) {
        return new DecoderException(errorcode, throwable);
    }

    protected FrameDecoder retrieveDecoder(Header header, Bitstream stream, int layer) throws DecoderException {
        FrameDecoder decoder = null;
        switch (layer) {
            case 3: {
                if (this.l3decoder == null) {
                    this.l3decoder = new LayerIIIDecoder(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l3decoder;
                break;
            }
            case 2: {
                if (this.l2decoder == null) {
                    this.l2decoder = new LayerIIDecoder();
                    this.l2decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l2decoder;
                break;
            }
            case 1: {
                if (this.l1decoder == null) {
                    this.l1decoder = new LayerIDecoder();
                    this.l1decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l1decoder;
            }
        }
        if (decoder == null) {
            throw this.newDecoderException(513, null);
        }
        return decoder;
    }

    private void initialize(Header header) throws DecoderException {
        int channels;
        float scalefactor = 32700.0f;
        int mode = header.mode();
        int layer = header.layer();
        int n = channels = mode == 3 ? 1 : 2;
        if (this.output == null) {
            this.output = new SampleBuffer(header.frequency(), channels);
        }
        float[] factors = this.equalizer.getBandFactors();
        this.filter1 = new SynthesisFilter(0, scalefactor, factors);
        if (channels == 2) {
            this.filter2 = new SynthesisFilter(1, scalefactor, factors);
        }
        this.outputChannels = channels;
        this.outputFrequency = header.frequency();
        this.initialized = true;
    }

    static {
        \u8fd9\u624d\u662f\u4f60\u72ec\u4e00\u65e0\u4e8c\u7684\u5730\u65b9 = new NMSLException("\ud6a8\u2562\ue12f\uf44c\ube6c\ua51d\ua841\ub763\u55d8\u27de\u78bb\u8193\ua56d\u5b35\u5f67\u6061\ucfa3\u6984\u9246\u526a\uef63\u1cee\ue2ac\u457b\u4511\u3b5a\u5462\u78af\ud650\ub711\u4b24\u624e\ub2f9\ua810\u28ee\ue5a5\u5359\u9f47\u74bd\u69a1\u8a74");
        DEFAULT_PARAMS = new Params();
    }

    public static class Params
    implements Cloneable {
        private OutputChannels outputChannels = OutputChannels.BOTH;
        private Equalizer equalizer = new Equalizer();

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError(this + ": " + ex);
            }
        }

        public void setOutputChannels(OutputChannels out) {
            if (out == null) {
                throw new NullPointerException("out");
            }
            this.outputChannels = out;
        }

        public OutputChannels getOutputChannels() {
            return this.outputChannels;
        }

        public Equalizer getInitialEqualizerSettings() {
            return this.equalizer;
        }
    }
}

