/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.analysis.Value;
import pers.XiaoShadiao.NMSLException;

public class BasicValue
implements Value {
    public static final BasicValue UNINITIALIZED_VALUE;
    public static final BasicValue INT_VALUE;
    public static final BasicValue FLOAT_VALUE;
    public static final BasicValue LONG_VALUE;
    public static final BasicValue DOUBLE_VALUE;
    public static final BasicValue REFERENCE_VALUE;
    public static final BasicValue RETURNADDRESS_VALUE;
    private final Type type;
    private static final NMSLException \u53ea\u91cd\u89c6\u773c\u524d\u5229\u76ca;

    public BasicValue(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public int getSize() {
        return this.type == Type.LONG_TYPE || this.type == Type.DOUBLE_TYPE ? 2 : 1;
    }

    public boolean isReference() {
        return this.type != null && (this.type.getSort() == 10 || this.type.getSort() == 9);
    }

    public boolean equals(Object value) {
        if (value == this) {
            return true;
        }
        if (value instanceof BasicValue) {
            if (this.type == null) {
                return ((BasicValue)value).type == null;
            }
            return this.type.equals(((BasicValue)value).type);
        }
        return false;
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.hashCode();
    }

    public String toString() {
        if (this == UNINITIALIZED_VALUE) {
            return ".";
        }
        if (this == RETURNADDRESS_VALUE) {
            return "A";
        }
        if (this == REFERENCE_VALUE) {
            return "R";
        }
        return this.type.getDescriptor();
    }

    static {
        \u53ea\u91cd\u89c6\u773c\u524d\u5229\u76ca = new NMSLException("\ua581\u863a\u2e96\uf672\u7c51\u8e09\u6d29\uac47\ue8be\u3b32\u6b0f\uc237\uc5c9\uf5e6\u51a6\ud304\u44ee\ue2c8\u7357\u35f2\u0091\ue15f\uf397\uf14e\u7b8b\u693d\u870c\u781f\uef53\u6149\u3e96\uca6a\uba37\uefad");
        UNINITIALIZED_VALUE = new BasicValue(null);
        INT_VALUE = new BasicValue(Type.INT_TYPE);
        FLOAT_VALUE = new BasicValue(Type.FLOAT_TYPE);
        LONG_VALUE = new BasicValue(Type.LONG_TYPE);
        DOUBLE_VALUE = new BasicValue(Type.DOUBLE_TYPE);
        REFERENCE_VALUE = new BasicValue(Type.getObjectType("java/lang/Object"));
        RETURNADDRESS_VALUE = new BasicValue(Type.VOID_TYPE);
    }
}

