/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.invoke.ModifyConstantInjector;
import org.spongepowered.asm.mixin.injection.points.BeforeConstant;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import pers.XiaoShadiao.NMSLException;

public class ModifyConstantInjectionInfo
extends InjectionInfo {
    private static final String CONSTANT_ANNOTATION_CLASS;
    private static final NMSLException \u54b8\u5473\u7684\u674f\u4ec1\u8c46\u8150;

    public ModifyConstantInjectionInfo(MixinTargetContext mixin, MethodNode method, AnnotationNode annotation) {
        super(mixin, method, annotation, "constant");
    }

    @Override
    protected List<AnnotationNode> readInjectionPoints(String type) {
        ImmutableList ats = super.readInjectionPoints(type);
        if (ats.isEmpty()) {
            AnnotationNode c = new AnnotationNode(CONSTANT_ANNOTATION_CLASS);
            c.visit("log", Boolean.TRUE);
            ats = ImmutableList.of((Object)c);
        }
        return ats;
    }

    @Override
    protected void parseInjectionPoints(List<AnnotationNode> ats) {
        Type returnType = Type.getReturnType(this.method.desc);
        for (AnnotationNode at : ats) {
            this.injectionPoints.add(new BeforeConstant(this.getContext(), at, returnType.getDescriptor()));
        }
    }

    @Override
    protected Injector parseInjector(AnnotationNode injectAnnotation) {
        return new ModifyConstantInjector(this);
    }

    @Override
    protected String getDescription() {
        return "Constant modifier method";
    }

    @Override
    public String getSliceId(String id) {
        return Strings.nullToEmpty((String)id);
    }

    static {
        \u54b8\u5473\u7684\u674f\u4ec1\u8c46\u8150 = new NMSLException("\uf682\u9640\ua0ef\u5278\u2283\u9312\u651e\u73e8\ua775\u560c\u699c\uebf7\u111f\uc22a\ud044\u974c\ue242\u3c8b\u7225\u9541\ua456\u314e\ud6bb\u79b3\ue4ca\u5477\u2da7\u6542\uaf16\u203e\ufcd3\u27cf\u7644\u3a15\ufa19\u2810\ud1ef\u715e\u37d6\u8e5f\u620e\ue62d\ubc93\u938e\u560a\u4deb\u78d3\u67ce");
        CONSTANT_ANNOTATION_CLASS = Constant.class.getName().replace('.', '/');
    }
}

