/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import pers.XiaoShadiao.NMSLException;

public final class Equalizer {
    public static final float BAND_NOT_PRESENT = Float.NEGATIVE_INFINITY;
    public static final Equalizer PASS_THRU_EQ;
    private static final int BANDS = 32;
    private final float[] settings = new float[32];
    private static final NMSLException \u4f60\u5c31\u662f\u6211\u7406\u60f3\u4e2d\u7684\u90a3\u4e2a\u4eba\u4e00\u4e00\u6b38;

    public Equalizer() {
    }

    public Equalizer(float[] settings) {
        this.setFrom(settings);
    }

    public Equalizer(EQFunction eq) {
        this.setFrom(eq);
    }

    public void setFrom(float[] eq) {
        this.reset();
        int max = eq.length > 32 ? 32 : eq.length;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq[i]);
        }
    }

    public void setFrom(EQFunction eq) {
        this.reset();
        int max = 32;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq.getBand(i));
        }
    }

    public void setFrom(Equalizer eq) {
        if (eq != this) {
            this.setFrom(eq.settings);
        }
    }

    public void reset() {
        for (int i = 0; i < 32; ++i) {
            this.settings[i] = 0.0f;
        }
    }

    public int getBandCount() {
        return this.settings.length;
    }

    public float setBand(int band, float neweq) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
            this.settings[band] = this.limit(neweq);
        }
        return eq;
    }

    public float getBand(int band) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
        }
        return eq;
    }

    private float limit(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return eq;
        }
        if (eq > 1.0f) {
            return 1.0f;
        }
        if (eq < -1.0f) {
            return -1.0f;
        }
        return eq;
    }

    float[] getBandFactors() {
        float[] factors = new float[32];
        int maxCount = 32;
        for (int i = 0; i < maxCount; ++i) {
            factors[i] = this.getBandFactor(this.settings[i]);
        }
        return factors;
    }

    float getBandFactor(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        float f = (float)Math.pow(2.0, eq);
        return f;
    }

    static {
        \u4f60\u5c31\u662f\u6211\u7406\u60f3\u4e2d\u7684\u90a3\u4e2a\u4eba\u4e00\u4e00\u6b38 = new NMSLException("\u9aec\uf0b1\ud4bd\ubb73\u8858\u3d2a\uf570\uca48\ua7fc\u7eea\u52e3\u7cc9\u688c\u428f\u7ec1\u8a36\u86ab\ue5f9\u2dac\u29c6\ua8c8\uc758\ucb67\u2a33\ua2f6\u8a16\ua551\ubbc1\uae1c\ue6c8\ue9bc\u2167\uf78b\ue9f5\u6fa6\u8288\u9426");
        PASS_THRU_EQ = new Equalizer();
    }

    public static abstract class EQFunction {
        public float getBand(int band) {
            return 0.0f;
        }
    }
}

