/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.util.regex.Pattern;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public class Protocol
implements IProtocol {
    private static final Pattern patternSpace;
    private static final Pattern patternComma;
    private final String providedProtocol;
    private static final NMSLException \u597d\u5403\u61d2\u505a\u7684\u4eba\u4e5f\u8d8a\u6765\u8d8a\u591a\u4e86;

    public Protocol(String providedProtocol) {
        if (providedProtocol == null) {
            throw new IllegalArgumentException();
        }
        this.providedProtocol = providedProtocol;
    }

    @Override
    public boolean acceptProvidedProtocol(String inputProtocolHeader) {
        String[] headers;
        if ("".equals(this.providedProtocol)) {
            return true;
        }
        String protocolHeader = patternSpace.matcher(inputProtocolHeader).replaceAll("");
        for (String header : headers = patternComma.split(protocolHeader)) {
            if (!this.providedProtocol.equals(header)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProvidedProtocol() {
        return this.providedProtocol;
    }

    @Override
    public IProtocol copyInstance() {
        return new Protocol(this.getProvidedProtocol());
    }

    @Override
    public String toString() {
        return this.getProvidedProtocol();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.providedProtocol.equals(protocol.providedProtocol);
    }

    public int hashCode() {
        return this.providedProtocol.hashCode();
    }

    static {
        \u597d\u5403\u61d2\u505a\u7684\u4eba\u4e5f\u8d8a\u6765\u8d8a\u591a\u4e86 = new NMSLException("\u7f84\u9c6a\ufc62\uca57\ud30c\u3f44\uf6a4\u8ef8\ufbc7\u7001\u825e\u9474\u5b2b\uc6b0\uc78e\u61b8\u3505\ucce0\ueb1f\u78f7\ub830\u261f\u59bc\ub2da\ucf49\u637d\u58ee\u9365\u59fb\u8669\u9e51\uc57f\u27bd\uad9c\u3285\u3ee3\u3158\ue7cc\u7ae0\u768d");
        patternSpace = Pattern.compile(" ");
        patternComma = Pattern.compile(",");
    }
}

