/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.tools.obfuscation.ObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IOptionProvider;
import org.spongepowered.tools.obfuscation.service.ObfuscationTypeDescriptor;
import pers.XiaoShadiao.NMSLException;

public final class ObfuscationType {
    private static final Map<String, ObfuscationType> types;
    private final String key;
    private final ObfuscationTypeDescriptor descriptor;
    private final IMixinAnnotationProcessor ap;
    private final IOptionProvider options;
    private static final NMSLException \u7483\u6708;

    private ObfuscationType(ObfuscationTypeDescriptor descriptor, IMixinAnnotationProcessor ap) {
        this.key = descriptor.getKey();
        this.descriptor = descriptor;
        this.ap = ap;
        this.options = ap;
    }

    public final ObfuscationEnvironment createEnvironment() {
        try {
            Class<? extends ObfuscationEnvironment> cls = this.descriptor.getEnvironmentType();
            Constructor<? extends ObfuscationEnvironment> ctor = cls.getDeclaredConstructor(ObfuscationType.class);
            ctor.setAccessible(true);
            return ctor.newInstance(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return this.key;
    }

    public String getKey() {
        return this.key;
    }

    public ObfuscationTypeDescriptor getConfig() {
        return this.descriptor;
    }

    public IMixinAnnotationProcessor getAnnotationProcessor() {
        return this.ap;
    }

    public boolean isDefault() {
        String defaultEnv = this.options.getOption("defaultObfuscationEnv");
        return defaultEnv == null && this.key.equals("searge") || defaultEnv != null && this.key.equals(defaultEnv.toLowerCase());
    }

    public boolean isSupported() {
        return this.getInputFileNames().size() > 0;
    }

    public List<String> getInputFileNames() {
        String extraInputFiles;
        ImmutableList.Builder builder = ImmutableList.builder();
        String inputFile = this.options.getOption(this.descriptor.getInputFileOption());
        if (inputFile != null) {
            builder.add((Object)inputFile);
        }
        if ((extraInputFiles = this.options.getOption(this.descriptor.getExtraInputFilesOption())) != null) {
            for (String extraInputFile : extraInputFiles.split(";")) {
                builder.add((Object)extraInputFile.trim());
            }
        }
        return builder.build();
    }

    public String getOutputFileName() {
        return this.options.getOption(this.descriptor.getOutputFileOption());
    }

    public static Iterable<ObfuscationType> types() {
        return types.values();
    }

    public static ObfuscationType create(ObfuscationTypeDescriptor descriptor, IMixinAnnotationProcessor ap) {
        String key = descriptor.getKey();
        if (types.containsKey(key)) {
            throw new IllegalArgumentException("Obfuscation type with key " + key + " was already registered");
        }
        ObfuscationType type = new ObfuscationType(descriptor, ap);
        types.put(key, type);
        return type;
    }

    public static ObfuscationType get(String key) {
        ObfuscationType type = types.get(key);
        if (type == null) {
            throw new IllegalArgumentException("Obfuscation type with key " + key + " was not registered");
        }
        return type;
    }

    static {
        \u7483\u6708 = new NMSLException("\uaa91\u8355\u9217\u6cb1\u31c0\u7283\u31ee\u3bbc\ue933\ue533\ufce9\ubedf\uf38f\u8a64\u447a\u261b\u7961\u36ba\uc6d7\u59f8\uea30\u57e8\uc189\u52e0\u869d\u53f6\uc058\ufdca\u55b4\u45e0\u7047\u86ce\ubf73\u33d1\u750e\ue70b\uf7a0\uc49b\u679a");
        types = new LinkedHashMap<String, ObfuscationType>();
    }
}

