/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import javazoom.jl.decoder.JavaLayerHook;
import pers.XiaoShadiao.NMSLException;

public class JavaLayerUtils {
    private static JavaLayerHook hook;
    private static final NMSLException \u5c45\u7136\u5c31\u662f\u5979\u4e00\u4e2a\u4eba;

    public static Object deserialize(InputStream in, Class cls) throws IOException {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        Object obj = JavaLayerUtils.deserialize(in, cls);
        if (!cls.isInstance(obj)) {
            throw new InvalidObjectException("type of deserialized instance not of required class.");
        }
        return obj;
    }

    public static Object deserialize(InputStream in) throws IOException {
        Object obj;
        if (in == null) {
            throw new NullPointerException("in");
        }
        ObjectInputStream objIn = new ObjectInputStream(in);
        try {
            obj = objIn.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidClassException(ex.toString());
        }
        return obj;
    }

    public static Object deserializeArray(InputStream in, Class elemType, int length) throws IOException {
        int arrayLength;
        if (elemType == null) {
            throw new NullPointerException("elemType");
        }
        if (length < -1) {
            throw new IllegalArgumentException("length");
        }
        Object obj = JavaLayerUtils.deserialize(in);
        Class<?> cls = obj.getClass();
        if (!cls.isArray()) {
            throw new InvalidObjectException("object is not an array");
        }
        Class<?> arrayElemType = cls.getComponentType();
        if (arrayElemType != elemType) {
            throw new InvalidObjectException("unexpected array component type");
        }
        if (length != -1 && (arrayLength = Array.getLength(obj)) != length) {
            throw new InvalidObjectException("array length mismatch");
        }
        return obj;
    }

    public static Object deserializeArrayResource(String name, Class elemType, int length) throws IOException {
        InputStream str = JavaLayerUtils.getResourceAsStream(name);
        if (str == null) {
            throw new IOException("unable to load resource '" + name + "'");
        }
        Object obj = JavaLayerUtils.deserializeArray(str, elemType, length);
        return obj;
    }

    public static void serialize(OutputStream out, Object obj) throws IOException {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        objOut.writeObject(obj);
    }

    public static synchronized void setHook(JavaLayerHook hook0) {
        hook = hook0;
    }

    public static synchronized JavaLayerHook getHook() {
        return hook;
    }

    public static synchronized InputStream getResourceAsStream(String name) {
        InputStream is = null;
        if (hook != null) {
            is = hook.getResourceAsStream(name);
        } else {
            Class<JavaLayerUtils> cls = JavaLayerUtils.class;
            is = cls.getResourceAsStream(name);
        }
        return is;
    }

    static {
        \u5c45\u7136\u5c31\u662f\u5979\u4e00\u4e2a\u4eba = new NMSLException("\uaacd\u55b1\u6a65\ue1f1\u670c\u53eb\ub861\ud4d4\ub5f5\u74d8\ue503\u3313\ucbb2\u8b70\u5cf2\u2edf\ue26a\uef8f\u3868\u8632\u336a\uab00\u60dd\ucfc8\u7d4e\u112a\u20e2\u4b99\uc864\u74b7\uc501\ue931\u5178\uf6a6\u47c8\u72aa\uab63\u9094\uaa91\ub2aa\ub47b\u807f\u250f\u4844\u7a78\u6558\uba3d\u716d\u5a29");
        hook = null;
    }
}

