/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.util.regex.Pattern;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public class Protocol
implements IProtocol {
    private static final Pattern patternSpace;
    private static final Pattern patternComma;
    private final String providedProtocol;
    private static final NMSLException \u8d70;

    public Protocol(String providedProtocol) {
        if (providedProtocol == null) {
            throw new IllegalArgumentException();
        }
        this.providedProtocol = providedProtocol;
    }

    @Override
    public boolean acceptProvidedProtocol(String inputProtocolHeader) {
        String[] headers;
        if ("".equals(this.providedProtocol)) {
            return true;
        }
        String protocolHeader = patternSpace.matcher(inputProtocolHeader).replaceAll("");
        for (String header : headers = patternComma.split(protocolHeader)) {
            if (!this.providedProtocol.equals(header)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProvidedProtocol() {
        return this.providedProtocol;
    }

    @Override
    public IProtocol copyInstance() {
        return new Protocol(this.getProvidedProtocol());
    }

    @Override
    public String toString() {
        return this.getProvidedProtocol();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.providedProtocol.equals(protocol.providedProtocol);
    }

    public int hashCode() {
        return this.providedProtocol.hashCode();
    }

    static {
        \u8d70 = new NMSLException("\u1737\ue041\u62ea\u809f\u82c3\u29c7\u2cde\u5af5\u1c70\u9434\u75eb\uc5fd\u8122\ue42e\ua1f0\u4371\ud499\uee76\u428a\u38d5\ua1bb\ufbb4\ua3bf\uecc4\ub2f2\u6b3b\uf15c\ucc65\u71c2\ua8e4\u375d\ua891\ua10a\u40af\u4382\u737e\u2325\u7eac\u952b\ua6c1\u9283\u6fcb\u3e7c");
        patternSpace = Pattern.compile(" ");
        patternComma = Pattern.compile(",");
    }
}

