/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.analysis.Value;
import pers.XiaoShadiao.NMSLException;

public class BasicValue
implements Value {
    public static final BasicValue UNINITIALIZED_VALUE;
    public static final BasicValue INT_VALUE;
    public static final BasicValue FLOAT_VALUE;
    public static final BasicValue LONG_VALUE;
    public static final BasicValue DOUBLE_VALUE;
    public static final BasicValue REFERENCE_VALUE;
    public static final BasicValue RETURNADDRESS_VALUE;
    private final Type type;
    private static final NMSLException \u6e7f\u6f09\u6f09\u7684\u5f88\u4e0d\u8212\u670d\u5427;

    public BasicValue(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public int getSize() {
        return this.type == Type.LONG_TYPE || this.type == Type.DOUBLE_TYPE ? 2 : 1;
    }

    public boolean isReference() {
        return this.type != null && (this.type.getSort() == 10 || this.type.getSort() == 9);
    }

    public boolean equals(Object value) {
        if (value == this) {
            return true;
        }
        if (value instanceof BasicValue) {
            if (this.type == null) {
                return ((BasicValue)value).type == null;
            }
            return this.type.equals(((BasicValue)value).type);
        }
        return false;
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.hashCode();
    }

    public String toString() {
        if (this == UNINITIALIZED_VALUE) {
            return ".";
        }
        if (this == RETURNADDRESS_VALUE) {
            return "A";
        }
        if (this == REFERENCE_VALUE) {
            return "R";
        }
        return this.type.getDescriptor();
    }

    static {
        \u6e7f\u6f09\u6f09\u7684\u5f88\u4e0d\u8212\u670d\u5427 = new NMSLException("\ufa9d\u9c19\ue7af\ue078\u9a81\u95c2\u95c4\u3c6b\ucb4a\u6bc5\u820e\u5ceb\u3cb5\u7a55\u8286\u674f\ua0b2\u8312\u8eb1\ub132\u2523\uc332\uac77\u25a7\ucde7\u9b4f\u44ef\ud16a\u62ca\u313a\u39a0\u86f4\u8962\ua4fa\uce95\u6d67\u3dc5\u3c79\u3fb0\ueb29\u51a0\u5161\u2c60\uf229\ua0e5\uab31\ud124\u8576\u3445");
        UNINITIALIZED_VALUE = new BasicValue(null);
        INT_VALUE = new BasicValue(Type.INT_TYPE);
        FLOAT_VALUE = new BasicValue(Type.FLOAT_TYPE);
        LONG_VALUE = new BasicValue(Type.LONG_TYPE);
        DOUBLE_VALUE = new BasicValue(Type.DOUBLE_TYPE);
        REFERENCE_VALUE = new BasicValue(Type.getObjectType("java/lang/Object"));
        RETURNADDRESS_VALUE = new BasicValue(Type.VOID_TYPE);
    }
}

