/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.invoke.ModifyConstantInjector;
import org.spongepowered.asm.mixin.injection.points.BeforeConstant;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import pers.XiaoShadiao.NMSLException;

public class ModifyConstantInjectionInfo
extends InjectionInfo {
    private static final String CONSTANT_ANNOTATION_CLASS;
    private static final NMSLException \u6211\u6ca1\u6709\u4e0d\u559c\u6b22\u7684\u98df\u6750;

    public ModifyConstantInjectionInfo(MixinTargetContext mixin, MethodNode method, AnnotationNode annotation) {
        super(mixin, method, annotation, "constant");
    }

    @Override
    protected List<AnnotationNode> readInjectionPoints(String type) {
        ImmutableList ats = super.readInjectionPoints(type);
        if (ats.isEmpty()) {
            AnnotationNode c = new AnnotationNode(CONSTANT_ANNOTATION_CLASS);
            c.visit("log", Boolean.TRUE);
            ats = ImmutableList.of((Object)c);
        }
        return ats;
    }

    @Override
    protected void parseInjectionPoints(List<AnnotationNode> ats) {
        Type returnType = Type.getReturnType(this.method.desc);
        for (AnnotationNode at : ats) {
            this.injectionPoints.add(new BeforeConstant(this.getContext(), at, returnType.getDescriptor()));
        }
    }

    @Override
    protected Injector parseInjector(AnnotationNode injectAnnotation) {
        return new ModifyConstantInjector(this);
    }

    @Override
    protected String getDescription() {
        return "Constant modifier method";
    }

    @Override
    public String getSliceId(String id) {
        return Strings.nullToEmpty((String)id);
    }

    static {
        \u6211\u6ca1\u6709\u4e0d\u559c\u6b22\u7684\u98df\u6750 = new NMSLException("\u8464\u3eca\ucf58\u79da\u72b6\u4620\uc69a\u91aa\ucfeb\u4b8c\u67f4\uc9e8\u2314\u5518\u5f1d\u6da9\u71d2\ufa9b\ua640\u7d21\ua765\ua6f1\u8449\u6f15\ucdbf\u6cd8\u7e04\ua468\ua917\u8655\u24f3\ua120\ub80f\uf52e\u1cfc\u6a4c");
        CONSTANT_ANNOTATION_CLASS = Constant.class.getName().replace('.', '/');
    }
}

