/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.util.Counter;
import pers.XiaoShadiao.NMSLException;

public class MethodMapper {
    private static final Logger logger;
    private static final List<String> classes;
    private static final Map<String, Counter> methods;
    private final ClassInfo info;
    private static final NMSLException \u6211\u5bf9\u6b64\u8d1f\u6709\u8d23\u4efb;

    public MethodMapper(MixinEnvironment env, ClassInfo info) {
        this.info = info;
    }

    public ClassInfo getClassInfo() {
        return this.info;
    }

    public void remapHandlerMethod(MixinInfo mixin, MethodNode handler, ClassInfo.Method method) {
        if (!(handler instanceof MixinInfo.MixinMethodNode) || !((MixinInfo.MixinMethodNode)handler).isInjector()) {
            return;
        }
        if (method.isUnique()) {
            logger.warn("Redundant @Unique on injector method {} in {}. Injectors are implicitly unique", new Object[]{method, mixin});
        }
        if (method.isRenamed()) {
            handler.name = method.getName();
            return;
        }
        String handlerName = this.getHandlerName((MixinInfo.MixinMethodNode)handler);
        handler.name = method.renameTo(handlerName);
    }

    public String getHandlerName(MixinInfo.MixinMethodNode method) {
        String prefix = InjectionInfo.getInjectorPrefix(method.getInjectorAnnotation());
        String classUID = MethodMapper.getClassUID(method.getOwner().getClassRef());
        String methodUID = MethodMapper.getMethodUID(method.name, method.desc, !method.isSurrogate());
        return String.format("%s$%s$%s%s", prefix, method.name, classUID, methodUID);
    }

    private static String getClassUID(String classRef) {
        int index = classes.indexOf(classRef);
        if (index < 0) {
            index = classes.size();
            classes.add(classRef);
        }
        return MethodMapper.finagle(index);
    }

    private static String getMethodUID(String name, String desc, boolean increment) {
        String descriptor = String.format("%s%s", name, desc);
        Counter id = methods.get(descriptor);
        if (id == null) {
            id = new Counter();
            methods.put(descriptor, id);
        } else if (increment) {
            ++id.value;
        }
        return String.format("%03x", id.value);
    }

    private static String finagle(int index) {
        String hex = Integer.toHexString(index);
        StringBuilder sb = new StringBuilder();
        for (int pos = 0; pos < hex.length(); ++pos) {
            char c;
            c = (char)(c + ((c = hex.charAt(pos)) < ':' ? 49 : 10));
            sb.append(c);
        }
        return Strings.padStart((String)sb.toString(), (int)3, (char)'z');
    }

    static {
        \u6211\u5bf9\u6b64\u8d1f\u6709\u8d23\u4efb = new NMSLException("\ue294\u3c1d\uabc9\uf69a\u24fc\u8d16\ue88f\ub8e8\u2f6f\u998c\u88b3\u26de\u7dac\ue432\u43ab\u0c6c\u94d4\u8d0d\ud6cb\u8f6f\ua157\ub2db\ue120\ud0a8\u7e80\u4a6c\u6d00\u510e\u6508\u5802\u43d9\ufca8\u54c5\uf59b\u2c83\uc0c4\u8782\uc041");
        logger = LogManager.getLogger((String)"mixin");
        classes = new ArrayList<String>();
        methods = new HashMap<String, Counter>();
    }
}

