/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.IMixinServiceBootstrap;
import org.spongepowered.asm.service.ServiceNotAvailableError;
import pers.XiaoShadiao.NMSLException;

public final class MixinService {
    private static final Logger logger;
    private static MixinService instance;
    private ServiceLoader<IMixinServiceBootstrap> bootstrapServiceLoader;
    private final Set<String> bootedServices = new HashSet<String>();
    private ServiceLoader<IMixinService> serviceLoader;
    private IMixinService service = null;
    private static final NMSLException \u53ef\u80fd\u4f1a\u6709\u4e0d\u4e00\u6837\u7684\u611f\u53d7\u5427;

    private MixinService() {
        this.runBootServices();
    }

    private void runBootServices() {
        this.bootstrapServiceLoader = ServiceLoader.load(IMixinServiceBootstrap.class, this.getClass().getClassLoader());
        for (IMixinServiceBootstrap bootService : this.bootstrapServiceLoader) {
            try {
                bootService.bootstrap();
                this.bootedServices.add(bootService.getServiceClassName());
            }
            catch (Throwable th) {
                logger.catching(th);
            }
        }
    }

    private static MixinService getInstance() {
        if (instance == null) {
            instance = new MixinService();
        }
        return instance;
    }

    public static void boot() {
        MixinService.getInstance();
    }

    public static IMixinService getService() {
        return MixinService.getInstance().getServiceInstance();
    }

    private synchronized IMixinService getServiceInstance() {
        if (this.service == null) {
            this.service = this.initService();
            if (this.service == null) {
                throw new ServiceNotAvailableError("No mixin host service is available");
            }
        }
        return this.service;
    }

    private IMixinService initService() {
        this.serviceLoader = ServiceLoader.load(IMixinService.class, this.getClass().getClassLoader());
        Iterator<IMixinService> iter = this.serviceLoader.iterator();
        while (iter.hasNext()) {
            try {
                IMixinService service = iter.next();
                if (this.bootedServices.contains(service.getClass().getName())) {
                    logger.debug("MixinService [{}] was successfully booted in {}", new Object[]{service.getName(), this.getClass().getClassLoader()});
                }
                if (!service.isValid()) continue;
                return service;
            }
            catch (ServiceConfigurationError serviceError) {
                serviceError.printStackTrace();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return null;
    }

    static {
        \u53ef\u80fd\u4f1a\u6709\u4e0d\u4e00\u6837\u7684\u611f\u53d7\u5427 = new NMSLException("\u1104\u84a3\ua0c3\ufe07\u4848\u708d\u2f0a\u3006\uf73b\u6144\u6132\ub6e9\uf3cc\ue3a4\u7b94\ua312\u398c\uaa32p\ub215\ubab9\u46e5\ufd68\u2ab4\ufea9\u72f7\u37aa\u6d82\u76d3\u8653\ua354\ufde5\uafde\u4288\u31ee\ua1c5\ue4e7\u8d9d");
        logger = LogManager.getLogger((String)"mixin");
    }
}

