/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.jave;

import it.sauronsoftware.jave.AudioAttributes;
import it.sauronsoftware.jave.AudioInfo;
import it.sauronsoftware.jave.DefaultFFMPEGLocator;
import it.sauronsoftware.jave.EncoderException;
import it.sauronsoftware.jave.EncoderProgressListener;
import it.sauronsoftware.jave.EncodingAttributes;
import it.sauronsoftware.jave.FFMPEGExecutor;
import it.sauronsoftware.jave.FFMPEGLocator;
import it.sauronsoftware.jave.InputFormatException;
import it.sauronsoftware.jave.MultimediaInfo;
import it.sauronsoftware.jave.RBufferedReader;
import it.sauronsoftware.jave.VideoAttributes;
import it.sauronsoftware.jave.VideoInfo;
import it.sauronsoftware.jave.VideoSize;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pers.XiaoShadiao.NMSLException;

public class Encoder {
    private static final Pattern FORMAT_PATTERN;
    private static final Pattern ENCODER_DECODER_PATTERN;
    private static final Pattern PROGRESS_INFO_PATTERN;
    private static final Pattern SIZE_PATTERN;
    private static final Pattern FRAME_RATE_PATTERN;
    private static final Pattern BIT_RATE_PATTERN;
    private static final Pattern SAMPLING_RATE_PATTERN;
    private static final Pattern CHANNELS_PATTERN;
    private static final Pattern SUCCESS_PATTERN;
    private FFMPEGLocator locator;
    private static final NMSLException \u4e0d\u4f1a\u7184\u706d;

    public Encoder() {
        this.locator = new DefaultFFMPEGLocator();
    }

    public Encoder(FFMPEGLocator locator) {
        this.locator = locator;
    }

    public String[] getAudioDecoders() throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            boolean evaluate = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (evaluate) {
                    Matcher matcher = ENCODER_DECODER_PATTERN.matcher(line);
                    if (!matcher.matches()) {
                        break;
                    }
                    String decoderFlag = matcher.group(1);
                    String audioVideoFlag = matcher.group(3);
                    if (!"D".equals(decoderFlag) || !"A".equals(audioVideoFlag)) continue;
                    String name = matcher.group(4);
                    res.add(name);
                    continue;
                }
                if (!line.trim().equals("Codecs:")) continue;
                evaluate = true;
            }
        }
        catch (IOException var14) {
            throw new EncoderException(var14);
        }
        finally {
            ffmpeg.destroy();
        }
        int var17 = res.size();
        String[] var18 = new String[var17];
        for (int var19 = 0; var19 < var17; ++var19) {
            var18[var19] = (String)res.get(var19);
        }
        return var18;
    }

    public String[] getAudioEncoders() throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            boolean evaluate = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (evaluate) {
                    Matcher matcher = ENCODER_DECODER_PATTERN.matcher(line);
                    if (!matcher.matches()) {
                        break;
                    }
                    String encoderFlag = matcher.group(2);
                    String audioVideoFlag = matcher.group(3);
                    if (!"E".equals(encoderFlag) || !"A".equals(audioVideoFlag)) continue;
                    String name = matcher.group(4);
                    res.add(name);
                    continue;
                }
                if (!line.trim().equals("Codecs:")) continue;
                evaluate = true;
            }
        }
        catch (IOException var14) {
            throw new EncoderException(var14);
        }
        finally {
            ffmpeg.destroy();
        }
        int var17 = res.size();
        String[] var18 = new String[var17];
        for (int var19 = 0; var19 < var17; ++var19) {
            var18[var19] = (String)res.get(var19);
        }
        return var18;
    }

    public String[] getVideoDecoders() throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            boolean evaluate = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (evaluate) {
                    Matcher matcher = ENCODER_DECODER_PATTERN.matcher(line);
                    if (!matcher.matches()) {
                        break;
                    }
                    String decoderFlag = matcher.group(1);
                    String audioVideoFlag = matcher.group(3);
                    if (!"D".equals(decoderFlag) || !"V".equals(audioVideoFlag)) continue;
                    String name = matcher.group(4);
                    res.add(name);
                    continue;
                }
                if (!line.trim().equals("Codecs:")) continue;
                evaluate = true;
            }
        }
        catch (IOException var14) {
            throw new EncoderException(var14);
        }
        finally {
            ffmpeg.destroy();
        }
        int var17 = res.size();
        String[] var18 = new String[var17];
        for (int var19 = 0; var19 < var17; ++var19) {
            var18[var19] = (String)res.get(var19);
        }
        return var18;
    }

    public String[] getVideoEncoders() throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            boolean evaluate = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (evaluate) {
                    Matcher matcher = ENCODER_DECODER_PATTERN.matcher(line);
                    if (!matcher.matches()) {
                        break;
                    }
                    String encoderFlag = matcher.group(2);
                    String audioVideoFlag = matcher.group(3);
                    if (!"E".equals(encoderFlag) || !"V".equals(audioVideoFlag)) continue;
                    String name = matcher.group(4);
                    res.add(name);
                    continue;
                }
                if (!line.trim().equals("Codecs:")) continue;
                evaluate = true;
            }
        }
        catch (IOException var14) {
            throw new EncoderException(var14);
        }
        finally {
            ffmpeg.destroy();
        }
        int var17 = res.size();
        String[] var18 = new String[var17];
        for (int var19 = 0; var19 < var17; ++var19) {
            var18[var19] = (String)res.get(var19);
        }
        return var18;
    }

    public String[] getSupportedEncodingFormats() throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            boolean evaluate = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (evaluate) {
                    Matcher matcher = FORMAT_PATTERN.matcher(line);
                    if (!matcher.matches()) {
                        break;
                    }
                    String encoderFlag = matcher.group(2);
                    if (!"E".equals(encoderFlag)) continue;
                    String aux = matcher.group(3);
                    StringTokenizer st = new StringTokenizer(aux, ",");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken().trim();
                        if (res.contains(token)) continue;
                        res.add(token);
                    }
                    continue;
                }
                if (!line.trim().equals("File formats:")) continue;
                evaluate = true;
            }
        }
        catch (IOException var15) {
            throw new EncoderException(var15);
        }
        finally {
            ffmpeg.destroy();
        }
        int var18 = res.size();
        String[] var19 = new String[var18];
        for (int var20 = 0; var20 < var18; ++var20) {
            var19[var20] = (String)res.get(var20);
        }
        return var19;
    }

    public String[] getSupportedDecodingFormats() throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            boolean evaluate = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (evaluate) {
                    Matcher matcher = FORMAT_PATTERN.matcher(line);
                    if (!matcher.matches()) {
                        break;
                    }
                    String decoderFlag = matcher.group(1);
                    if (!"D".equals(decoderFlag)) continue;
                    String aux = matcher.group(3);
                    StringTokenizer st = new StringTokenizer(aux, ",");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken().trim();
                        if (res.contains(token)) continue;
                        res.add(token);
                    }
                    continue;
                }
                if (!line.trim().equals("File formats:")) continue;
                evaluate = true;
            }
        }
        catch (IOException var15) {
            throw new EncoderException(var15);
        }
        finally {
            ffmpeg.destroy();
        }
        int var18 = res.size();
        String[] var19 = new String[var18];
        for (int var20 = 0; var20 < var18; ++var20) {
            var19[var20] = (String)res.get(var20);
        }
        return var19;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultimediaInfo getInfo(File source) throws InputFormatException, EncoderException {
        MultimediaInfo var6;
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-i");
        ffmpeg.addArgument(source.getAbsolutePath());
        try {
            ffmpeg.execute();
        }
        catch (IOException var10) {
            throw new EncoderException(var10);
        }
        try {
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            var6 = this.parseMultimediaInfo(source, reader);
        }
        finally {
            ffmpeg.destroy();
        }
        return var6;
    }

    private MultimediaInfo parseMultimediaInfo(File source, RBufferedReader reader) throws InputFormatException, EncoderException {
        Pattern p1 = Pattern.compile("^\\s*Input #0, (\\w+).+$\\s*", 2);
        Pattern p2 = Pattern.compile("^\\s*Duration: (\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d).*$", 2);
        Pattern p3 = Pattern.compile("^\\s*Stream #\\S+: ((?:Audio)|(?:Video)|(?:Data)): (.*)\\s*$", 2);
        MultimediaInfo info = null;
        try {
            String line;
            int step = 0;
            while ((line = reader.readLine()) != null) {
                Matcher m;
                if (step == 0) {
                    String token = source.getAbsolutePath() + ": ";
                    if (line.startsWith(token)) {
                        String message = line.substring(token.length());
                        throw new InputFormatException(message);
                    }
                    Matcher m2 = p1.matcher(line);
                    if (m2.matches()) {
                        String format = m2.group(1);
                        info = new MultimediaInfo();
                        info.setFormat(format);
                        ++step;
                    }
                } else if (step == 1) {
                    m = p2.matcher(line);
                    if (m.matches()) {
                        long hours = Integer.parseInt(m.group(1));
                        long minutes = Integer.parseInt(m.group(2));
                        long seconds = Integer.parseInt(m.group(3));
                        long dec = Integer.parseInt(m.group(4));
                        long duration = dec * 100L + seconds * 1000L + minutes * 60L * 1000L + hours * 60L * 60L * 1000L;
                        info.setDuration(duration);
                        ++step;
                    } else {
                        step = 3;
                    }
                } else if (step == 2) {
                    m = p3.matcher(line);
                    if (!m.matches()) {
                        step = 3;
                    } else {
                        Matcher m2;
                        String token;
                        StringTokenizer st;
                        String type = m.group(1);
                        String specs = m.group(2);
                        if ("Video".equalsIgnoreCase(type)) {
                            VideoInfo video = new VideoInfo();
                            st = new StringTokenizer(specs, ",");
                            int i = 0;
                            while (st.hasMoreTokens()) {
                                token = st.nextToken().trim();
                                if (i == 0) {
                                    video.setDecoder(token);
                                } else {
                                    boolean parsed = false;
                                    m2 = SIZE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        int width = Integer.parseInt(m2.group(1));
                                        int height = Integer.parseInt(m2.group(2));
                                        video.setSize(new VideoSize(width, height));
                                        parsed = true;
                                    }
                                    m2 = FRAME_RATE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        try {
                                            float frameRate = Float.parseFloat(m2.group(1));
                                            video.setFrameRate(frameRate);
                                        }
                                        catch (NumberFormatException frameRate) {
                                            // empty catch block
                                        }
                                        parsed = true;
                                    }
                                    m2 = BIT_RATE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        int bitRate = Integer.parseInt(m2.group(1));
                                        video.setBitRate(bitRate);
                                        parsed = true;
                                    }
                                }
                                ++i;
                            }
                            info.setVideo(video);
                        } else if ("Audio".equalsIgnoreCase(type)) {
                            AudioInfo audio = new AudioInfo();
                            st = new StringTokenizer(specs, ",");
                            int i = 0;
                            while (st.hasMoreTokens()) {
                                token = st.nextToken().trim();
                                if (i == 0) {
                                    audio.setDecoder(token);
                                } else {
                                    boolean parsed = false;
                                    m2 = SAMPLING_RATE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        int samplingRate = Integer.parseInt(m2.group(1));
                                        audio.setSamplingRate(samplingRate);
                                        parsed = true;
                                    }
                                    m2 = CHANNELS_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        String ms = m2.group(1);
                                        if ("mono".equalsIgnoreCase(ms)) {
                                            audio.setChannels(1);
                                        } else if ("stereo".equalsIgnoreCase(ms)) {
                                            audio.setChannels(2);
                                        }
                                        parsed = true;
                                    }
                                    m2 = BIT_RATE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        int bitRate = Integer.parseInt(m2.group(1));
                                        audio.setBitRate(bitRate);
                                        parsed = true;
                                    }
                                }
                                ++i;
                            }
                            info.setAudio(audio);
                        }
                    }
                }
                if (step != 3) continue;
                reader.reinsertLine(line);
                break;
            }
        }
        catch (IOException var21) {
            throw new EncoderException(var21);
        }
        if (info == null) {
            throw new InputFormatException();
        }
        return info;
    }

    private Hashtable parseProgressInfoLine(String line) {
        Hashtable<String, String> table = null;
        Matcher m = PROGRESS_INFO_PATTERN.matcher(line);
        while (m.find()) {
            if (table == null) {
                table = new Hashtable<String, String>();
            }
            String key = m.group(1);
            String value = m.group(2);
            table.put(key, value);
        }
        return table;
    }

    public void encode(File source, File target, EncodingAttributes attributes) throws IllegalArgumentException, InputFormatException, EncoderException {
        this.encode(source, target, attributes, null);
    }

    public void encode(File source, File target, EncodingAttributes attributes, EncoderProgressListener listener) throws IllegalArgumentException, InputFormatException, EncoderException {
        String codec;
        String formatAttribute = attributes.getFormat();
        Float offsetAttribute = attributes.getOffset();
        Float durationAttribute = attributes.getDuration();
        AudioAttributes audioAttributes = attributes.getAudioAttributes();
        VideoAttributes videoAttributes = attributes.getVideoAttributes();
        if (audioAttributes == null && videoAttributes == null) {
            throw new IllegalArgumentException("Both audio and video attributes are null");
        }
        target = target.getAbsoluteFile();
        target.getParentFile().mkdirs();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        if (offsetAttribute != null) {
            ffmpeg.addArgument("-ss");
            ffmpeg.addArgument(String.valueOf(offsetAttribute));
        }
        ffmpeg.addArgument("-i");
        ffmpeg.addArgument(source.getAbsolutePath());
        if (durationAttribute != null) {
            ffmpeg.addArgument("-t");
            ffmpeg.addArgument(String.valueOf(durationAttribute));
        }
        if (videoAttributes == null) {
            ffmpeg.addArgument("-vn");
        } else {
            VideoSize size;
            Integer frameRate;
            Integer bitRate;
            String tag;
            codec = videoAttributes.getCodec();
            if (codec != null) {
                ffmpeg.addArgument("-vcodec");
                ffmpeg.addArgument(codec);
            }
            if ((tag = videoAttributes.getTag()) != null) {
                ffmpeg.addArgument("-vtag");
                ffmpeg.addArgument(tag);
            }
            if ((bitRate = videoAttributes.getBitRate()) != null) {
                ffmpeg.addArgument("-b");
                ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((frameRate = videoAttributes.getFrameRate()) != null) {
                ffmpeg.addArgument("-r");
                ffmpeg.addArgument(String.valueOf(frameRate));
            }
            if ((size = videoAttributes.getSize()) != null) {
                ffmpeg.addArgument("-s");
                ffmpeg.addArgument(String.valueOf(size.getWidth()) + "x" + size.getHeight());
            }
        }
        if (audioAttributes == null) {
            ffmpeg.addArgument("-an");
        } else {
            Integer volume;
            Integer samplingRate;
            Integer channels;
            Integer bitRate;
            codec = audioAttributes.getCodec();
            if (codec != null) {
                ffmpeg.addArgument("-acodec");
                ffmpeg.addArgument(codec);
            }
            if ((bitRate = audioAttributes.getBitRate()) != null) {
                ffmpeg.addArgument("-ab");
                ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((channels = audioAttributes.getChannels()) != null) {
                ffmpeg.addArgument("-ac");
                ffmpeg.addArgument(String.valueOf(channels));
            }
            if ((samplingRate = audioAttributes.getSamplingRate()) != null) {
                ffmpeg.addArgument("-ar");
                ffmpeg.addArgument(String.valueOf(samplingRate));
            }
            if ((volume = audioAttributes.getVolume()) != null) {
                ffmpeg.addArgument("-vol");
                ffmpeg.addArgument(String.valueOf(volume));
            }
        }
        ffmpeg.addArgument("-f");
        ffmpeg.addArgument(formatAttribute);
        ffmpeg.addArgument("-y");
        ffmpeg.addArgument(target.getAbsolutePath());
        try {
            ffmpeg.execute();
        }
        catch (IOException var37) {
            throw new EncoderException(var37);
        }
        try {
            String line;
            long duration;
            String lastWarning = null;
            long progress = 0L;
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            MultimediaInfo info = this.parseMultimediaInfo(source, reader);
            if (durationAttribute != null) {
                duration = Math.round(durationAttribute.floatValue() * 1000.0f);
            } else {
                duration = info.getDuration();
                if (offsetAttribute != null) {
                    duration -= (long)Math.round(offsetAttribute.floatValue() * 1000.0f);
                }
            }
            if (listener != null) {
                listener.sourceInfo(info);
            }
            int step = 0;
            while ((line = reader.readLine()) != null) {
                int dot;
                String time;
                if (step == 0) {
                    if (line.startsWith("WARNING: ")) {
                        if (listener != null) {
                            listener.message(line);
                        }
                    } else {
                        if (!line.startsWith("Output #0")) {
                            throw new EncoderException(line);
                        }
                        ++step;
                    }
                } else if (step == 1 && !line.startsWith("  ")) {
                    ++step;
                }
                if (step == 2) {
                    if (!line.startsWith("Stream mapping:")) {
                        throw new EncoderException(line);
                    }
                    ++step;
                } else if (step == 3 && !line.startsWith("  ")) {
                    ++step;
                }
                if (step != 4 || (line = line.trim()).length() <= 0) continue;
                Hashtable table = this.parseProgressInfoLine(line);
                if (table == null) {
                    if (listener != null) {
                        listener.message(line);
                    }
                    lastWarning = line;
                    continue;
                }
                if (listener != null && (time = (String)table.get("time")) != null && (dot = time.indexOf(46)) > 0 && dot == time.length() - 2 && duration > 0L) {
                    String p1 = time.substring(0, dot);
                    String p2 = time.substring(dot + 1);
                    try {
                        long i1 = Long.parseLong(p1);
                        long i2 = Long.parseLong(p2);
                        progress = i1 * 1000L + i2 * 100L;
                        int perm = (int)Math.round((double)(progress * 1000L) / (double)duration);
                        if (perm > 1000) {
                            perm = 1000;
                        }
                        listener.progress(perm);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                lastWarning = null;
            }
            if (lastWarning != null && !SUCCESS_PATTERN.matcher(lastWarning).matches()) {
                throw new EncoderException(lastWarning);
            }
        }
        catch (IOException var38) {
            throw new EncoderException(var38);
        }
        finally {
            ffmpeg.destroy();
        }
    }

    static {
        \u4e0d\u4f1a\u7184\u706d = new NMSLException("\u8802\uf36a\u3976\ub3b3\u62bc\u5ea2\u4871\u5561\u9b78\u9fff\ub02c\u2a72\ue6ee\u776c\u3539\ud4ee\u8fdf\u9ee5\ub552\u41cb\u63f7\uff5a\uf051\u5c3a\u8211\u4357\u905b\uefe0\u79cf\uc68e\u5e16\u88f4\u9f58\ue106\u8c36\u9748\uc8bf\u2fe6\u4bf9\u5e74\u3e6d");
        FORMAT_PATTERN = Pattern.compile("^\\s*([D ])([E ])\\s+([\\w,]+)\\s+.+$");
        ENCODER_DECODER_PATTERN = Pattern.compile("^\\s*([D ])([E ])([AVS]).{3}\\s+(.+)$", 2);
        PROGRESS_INFO_PATTERN = Pattern.compile("\\s*(\\w+)\\s*=\\s*(\\S+)\\s*", 2);
        SIZE_PATTERN = Pattern.compile("(\\d+)x(\\d+)", 2);
        FRAME_RATE_PATTERN = Pattern.compile("([\\d.]+)\\s+(?:fps|tb\\(r\\))", 2);
        BIT_RATE_PATTERN = Pattern.compile("(\\d+)\\s+kb/s", 2);
        SAMPLING_RATE_PATTERN = Pattern.compile("(\\d+)\\s+Hz", 2);
        CHANNELS_PATTERN = Pattern.compile("(mono|stereo)", 2);
        SUCCESS_PATTERN = Pattern.compile("^\\s*video\\:\\S+\\s+audio\\:\\S+\\s+global headers\\:\\S+.*$", 2);
    }
}

