/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.util.regex.Pattern;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public class Protocol
implements IProtocol {
    private static final Pattern patternSpace;
    private static final Pattern patternComma;
    private final String providedProtocol;
    private static final NMSLException \u8fd9\u6837\u4f60\u5c31\u4f1a\u62e5\u6709\u4e00\u4efd\u6765\u81ea\u81ea\u5df1\u7684\u751f\u65e5\u793c\u7269;

    public Protocol(String providedProtocol) {
        if (providedProtocol == null) {
            throw new IllegalArgumentException();
        }
        this.providedProtocol = providedProtocol;
    }

    @Override
    public boolean acceptProvidedProtocol(String inputProtocolHeader) {
        String[] headers;
        if ("".equals(this.providedProtocol)) {
            return true;
        }
        String protocolHeader = patternSpace.matcher(inputProtocolHeader).replaceAll("");
        for (String header : headers = patternComma.split(protocolHeader)) {
            if (!this.providedProtocol.equals(header)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProvidedProtocol() {
        return this.providedProtocol;
    }

    @Override
    public IProtocol copyInstance() {
        return new Protocol(this.getProvidedProtocol());
    }

    @Override
    public String toString() {
        return this.getProvidedProtocol();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.providedProtocol.equals(protocol.providedProtocol);
    }

    public int hashCode() {
        return this.providedProtocol.hashCode();
    }

    static {
        \u8fd9\u6837\u4f60\u5c31\u4f1a\u62e5\u6709\u4e00\u4efd\u6765\u81ea\u81ea\u5df1\u7684\u751f\u65e5\u793c\u7269 = new NMSLException("\u73eb\u95f8\uf7c3\u9a9a\u9551\u4945\ubed3\u5930\ub8f1\uc9ed\u85be\u6d5f\u2bfc\u77d3\u40f9\u6445\u954d\uf71c\uac2f\ub5ff\u8c5b\ueeb6\u4443\u7fed\ue18c\ua5d6\ua8c0\ud1f8\u8704\u67f9\u8b90");
        patternSpace = Pattern.compile(" ");
        patternComma = Pattern.compile(",");
    }
}

