/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.Config;
import pers.XiaoShadiao.NMSLException;

public final class Mixins {
    private static final Logger logger;
    private static final String CONFIGS_KEY = "mixin.configs.queue";
    private static final Set<String> errorHandlers;
    private static final NMSLException \u8fd9\u4e00\u573a\u4e5f\u5f88\u6709\u6548\u679c;

    private Mixins() {
    }

    public static void addConfigurations(String ... configFiles) {
        MixinEnvironment fallback = MixinEnvironment.getDefaultEnvironment();
        for (String configFile : configFiles) {
            Mixins.createConfiguration(configFile, fallback);
        }
    }

    public static void addConfiguration(String configFile) {
        Mixins.createConfiguration(configFile, MixinEnvironment.getDefaultEnvironment());
    }

    @Deprecated
    static void addConfiguration(String configFile, MixinEnvironment fallback) {
        Mixins.createConfiguration(configFile, fallback);
    }

    private static void createConfiguration(String configFile, MixinEnvironment fallback) {
        Config config = null;
        try {
            config = Config.create(configFile, fallback);
        }
        catch (Exception ex) {
            logger.error("Error encountered reading mixin config " + configFile + ": " + ex.getClass().getName() + " " + ex.getMessage(), (Throwable)ex);
        }
        Mixins.registerConfiguration(config);
    }

    private static void registerConfiguration(Config config) {
        if (config == null) {
            return;
        }
        MixinEnvironment env = config.getEnvironment();
        if (env != null) {
            env.registerConfig(config.getName());
        }
        Mixins.getConfigs().add(config);
    }

    public static int getUnvisitedCount() {
        int count = 0;
        for (Config config : Mixins.getConfigs()) {
            if (config.isVisited()) continue;
            ++count;
        }
        return count;
    }

    public static Set<Config> getConfigs() {
        LinkedHashSet mixinConfigs = (LinkedHashSet)GlobalProperties.get(CONFIGS_KEY);
        if (mixinConfigs == null) {
            mixinConfigs = new LinkedHashSet();
            GlobalProperties.put(CONFIGS_KEY, mixinConfigs);
        }
        return mixinConfigs;
    }

    public static void registerErrorHandlerClass(String handlerName) {
        if (handlerName != null) {
            errorHandlers.add(handlerName);
        }
    }

    public static Set<String> getErrorHandlerClasses() {
        return Collections.unmodifiableSet(errorHandlers);
    }

    static {
        \u8fd9\u4e00\u573a\u4e5f\u5f88\u6709\u6548\u679c = new NMSLException("\ub45f\uad90\u717d\u71e5\u4bf9\u899d\u6562\uec36\ub140\ub83b\u4f84\ud441\ueaa3\u5a9e\u58a7\u41e0\u437a\u9fd7\ue5c3\u62a2\uff92\u9594\ud512\u9608\u8b81\uef7d\ufb7b\ub9ba\uc40e\u460b\uc331\u36a4\u49cc\ue8ed\u6e65\ub199\uca0a\u304f\u3d32\u81b7\u4b25\ua0ff\u879d\u63c3\u49f4\uef93\u646c\u4455\u7521");
        logger = LogManager.getLogger((String)"mixin");
        errorHandlers = new LinkedHashSet<String>();
    }
}

