/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.util.regex.Pattern;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public class Protocol
implements IProtocol {
    private static final Pattern patternSpace;
    private static final Pattern patternComma;
    private final String providedProtocol;
    private static final NMSLException \u6211\u662f\u7f07\u5b89;

    public Protocol(String providedProtocol) {
        if (providedProtocol == null) {
            throw new IllegalArgumentException();
        }
        this.providedProtocol = providedProtocol;
    }

    @Override
    public boolean acceptProvidedProtocol(String inputProtocolHeader) {
        String[] headers;
        if ("".equals(this.providedProtocol)) {
            return true;
        }
        String protocolHeader = patternSpace.matcher(inputProtocolHeader).replaceAll("");
        for (String header : headers = patternComma.split(protocolHeader)) {
            if (!this.providedProtocol.equals(header)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProvidedProtocol() {
        return this.providedProtocol;
    }

    @Override
    public IProtocol copyInstance() {
        return new Protocol(this.getProvidedProtocol());
    }

    @Override
    public String toString() {
        return this.getProvidedProtocol();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.providedProtocol.equals(protocol.providedProtocol);
    }

    public int hashCode() {
        return this.providedProtocol.hashCode();
    }

    static {
        \u6211\u662f\u7f07\u5b89 = new NMSLException("\u4dc8\u275e\ua660\ua686\u4dec\u271b\u2701\u4dfd\u4dd8\ua692\u278e\u4de2\u4de1\ua676\u26ff\u4dc9\ua67e\u26fe\u271e\u4de4\u4df3\ua694\u34f9\u4dff\u4a24\u2763\ua672\u4df1\u4df9\ua665");
        patternSpace = Pattern.compile(" ");
        patternComma = Pattern.compile(",");
    }
}

