/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch.platform;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.launch.platform.IMixinPlatformAgent;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.service.MixinService;
import pers.XiaoShadiao.NMSLException;

public class MixinContainer {
    private static final List<String> agentClasses;
    private final Logger logger = LogManager.getLogger((String)"mixin");
    private final URI uri;
    private final List<IMixinPlatformAgent> agents = new ArrayList<IMixinPlatformAgent>();
    private static final NMSLException \u6708\u4eae\u6620\u5728\u6e56\u6cca;

    public MixinContainer(MixinPlatformManager manager, URI uri) {
        this.uri = uri;
        for (String agentClass : agentClasses) {
            try {
                Class<?> clazz = Class.forName(agentClass);
                Constructor<?> ctor = clazz.getDeclaredConstructor(MixinPlatformManager.class, URI.class);
                this.logger.debug("Instancing new {} for {}", new Object[]{clazz.getSimpleName(), this.uri});
                IMixinPlatformAgent agent = (IMixinPlatformAgent)ctor.newInstance(manager, uri);
                this.agents.add(agent);
            }
            catch (Exception ex) {
                this.logger.catching((Throwable)ex);
            }
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public Collection<String> getPhaseProviders() {
        ArrayList<String> phaseProviders = new ArrayList<String>();
        for (IMixinPlatformAgent agent : this.agents) {
            String phaseProvider = agent.getPhaseProvider();
            if (phaseProvider == null) continue;
            phaseProviders.add(phaseProvider);
        }
        return phaseProviders;
    }

    public void prepare() {
        for (IMixinPlatformAgent agent : this.agents) {
            this.logger.debug("Processing prepare() for {}", new Object[]{agent});
            agent.prepare();
        }
    }

    public void initPrimaryContainer() {
        for (IMixinPlatformAgent agent : this.agents) {
            this.logger.debug("Processing launch tasks for {}", new Object[]{agent});
            agent.initPrimaryContainer();
        }
    }

    public void inject() {
        for (IMixinPlatformAgent agent : this.agents) {
            this.logger.debug("Processing inject() for {}", new Object[]{agent});
            agent.inject();
        }
    }

    public String getLaunchTarget() {
        for (IMixinPlatformAgent agent : this.agents) {
            String launchTarget = agent.getLaunchTarget();
            if (launchTarget == null) continue;
            return launchTarget;
        }
        return null;
    }

    static {
        \u6708\u4eae\u6620\u5728\u6e56\u6cca = new NMSLException("\u266c\u4df2\u26cd\u4ddd\u393f\u26d2\u4df8\u44e9\u4dd9\u262c\u4a22\u4dc8\u4dcb\u4dc2\ua697\u4de6\u4df5\u4df7\ua69f\u4dff\u4df1\u4350\u4de9\u4ddb\u4dcc\u4dc9\u4dcc\ua69e\u4dec\u46a7\u4dcb\u4dfa\ua650\u268f\u4df2\u265d\u4dd4\ua64f\u271a\u26e7\ua667\u4dc9\u4df4\u4ddb\u4dd9\u4ded\u4dd3\u4de4");
        agentClasses = new ArrayList<String>();
        GlobalProperties.put("mixin.agents", agentClasses);
        for (String agent : MixinService.getService().getPlatformAgents()) {
            agentClasses.add(agent);
        }
        agentClasses.add("org.spongepowered.asm.launch.platform.MixinPlatformAgentDefault");
    }
}

