/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.Config;
import pers.XiaoShadiao.NMSLException;

public final class Mixins {
    private static final Logger logger;
    private static final String CONFIGS_KEY = "mixin.configs.queue";
    private static final Set<String> errorHandlers;
    private static final NMSLException \u6211\u62cd\u4e94;

    private Mixins() {
    }

    public static void addConfigurations(String ... configFiles) {
        MixinEnvironment fallback = MixinEnvironment.getDefaultEnvironment();
        for (String configFile : configFiles) {
            Mixins.createConfiguration(configFile, fallback);
        }
    }

    public static void addConfiguration(String configFile) {
        Mixins.createConfiguration(configFile, MixinEnvironment.getDefaultEnvironment());
    }

    @Deprecated
    static void addConfiguration(String configFile, MixinEnvironment fallback) {
        Mixins.createConfiguration(configFile, fallback);
    }

    private static void createConfiguration(String configFile, MixinEnvironment fallback) {
        Config config = null;
        try {
            config = Config.create(configFile, fallback);
        }
        catch (Exception ex) {
            logger.error("Error encountered reading mixin config " + configFile + ": " + ex.getClass().getName() + " " + ex.getMessage(), (Throwable)ex);
        }
        Mixins.registerConfiguration(config);
    }

    private static void registerConfiguration(Config config) {
        if (config == null) {
            return;
        }
        MixinEnvironment env = config.getEnvironment();
        if (env != null) {
            env.registerConfig(config.getName());
        }
        Mixins.getConfigs().add(config);
    }

    public static int getUnvisitedCount() {
        int count = 0;
        for (Config config : Mixins.getConfigs()) {
            if (config.isVisited()) continue;
            ++count;
        }
        return count;
    }

    public static Set<Config> getConfigs() {
        LinkedHashSet mixinConfigs = (LinkedHashSet)GlobalProperties.get(CONFIGS_KEY);
        if (mixinConfigs == null) {
            mixinConfigs = new LinkedHashSet();
            GlobalProperties.put(CONFIGS_KEY, mixinConfigs);
        }
        return mixinConfigs;
    }

    public static void registerErrorHandlerClass(String handlerName) {
        if (handlerName != null) {
            errorHandlers.add(handlerName);
        }
    }

    public static Set<String> getErrorHandlerClasses() {
        return Collections.unmodifiableSet(errorHandlers);
    }

    static {
        \u6211\u62cd\u4e94 = new NMSLException("\u4dee\u4dfc\u4694\u268b\ua682\u4dee\u4dc1\u4dc6\u3719\u2615\u4de6\u4de5\u4de6\u27b6\u4de1\u4de3\u4dd7\ua690\u4df1\u4dcf\u278e\u4ddf\u27be\u263c\u4dd5\u2795\u4df6\u4dd7\u4dec\u266b\u279e\u2632\u4de6\u4dd7\u4d6e\u4de2\u27b3\u2780\u27a2\ua675\ua652\u2797");
        logger = LogManager.getLogger((String)"mixin");
        errorHandlers = new LinkedHashSet<String>();
    }
}

