/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import pers.XiaoShadiao.NMSLException;

public final class Equalizer {
    public static final float BAND_NOT_PRESENT = Float.NEGATIVE_INFINITY;
    private static final int BANDS = 32;
    private final float[] settings = new float[32];
    public static final Equalizer PASS_THRU_EQ;
    private static final NMSLException \u4ec0;

    public Equalizer(EQFunction eq) {
        this.setFrom(eq);
    }

    public void reset() {
        for (int i = 0; i < 32; ++i) {
            this.settings[i] = 0.0f;
        }
    }

    public Equalizer(float[] settings) {
        this.setFrom(settings);
    }

    public void setFrom(float[] eq) {
        this.reset();
        int max = eq.length > 32 ? 32 : eq.length;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq[i]);
        }
    }

    private float limit(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return eq;
        }
        if (eq > 1.0f) {
            return 1.0f;
        }
        if (eq < -1.0f) {
            return -1.0f;
        }
        return eq;
    }

    static {
        \u4ec0 = new NMSLException("\u4ddf\ua652\ua65b\u2600\u4dda\u4dd4\u3c8c\u4de2\u4dfa\u4de6\u278a\u3d99\u262a\u4dc4\u4dc2\u26f1\u2618\u4df7\u2774\u2735\u2704\u4dcc\ua671\u26b6\u4211\ua666\u2762\u4dd4\u272b\u2744\u4df4\u4ddc\u4de9\u2687\u3680\u4dfe\u4dfe\u4dfb");
        PASS_THRU_EQ = new Equalizer();
    }

    public int getBandCount() {
        return this.settings.length;
    }

    float getBandFactor(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        float f = (float)Math.pow(2.0, eq);
        return f;
    }

    public void setFrom(Equalizer eq) {
        if (eq != this) {
            this.setFrom(eq.settings);
        }
    }

    public float getBand(int band) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
        }
        return eq;
    }

    public void setFrom(EQFunction eq) {
        this.reset();
        int max = 32;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq.getBand(i));
        }
    }

    public Equalizer() {
    }

    float[] getBandFactors() {
        float[] factors = new float[32];
        int maxCount = 32;
        for (int i = 0; i < maxCount; ++i) {
            factors[i] = this.getBandFactor(this.settings[i]);
        }
        return factors;
    }

    public float setBand(int band, float neweq) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
            this.settings[band] = this.limit(neweq);
        }
        return eq;
    }

    public static abstract class EQFunction {
        public float getBand(int band) {
            return 0.0f;
        }
    }
}

