/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.util.regex.Pattern;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public class Protocol
implements IProtocol {
    private static final Pattern patternSpace;
    private static final Pattern patternComma;
    private final String providedProtocol;
    private static final NMSLException \u8d77\u98de\u54af;

    public int hashCode() {
        return this.providedProtocol.hashCode();
    }

    @Override
    public boolean acceptProvidedProtocol(String inputProtocolHeader) {
        String[] headers;
        if ("".equals(this.providedProtocol)) {
            return true;
        }
        String protocolHeader = patternSpace.matcher(inputProtocolHeader).replaceAll("");
        for (String header : headers = patternComma.split(protocolHeader)) {
            if (!this.providedProtocol.equals(header)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IProtocol copyInstance() {
        return new Protocol(this.getProvidedProtocol());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.providedProtocol.equals(protocol.providedProtocol);
    }

    @Override
    public String toString() {
        return this.getProvidedProtocol();
    }

    static {
        \u8d77\u98de\u54af = new NMSLException("\u27a0\u4def\u27a7\u4dc4\u4dcb\ua67f\u3a69\u3ce8\u4dc8\u4df4\u2740\u4cfa\u269d\u26d5\u4dc9\u4dc2\u4dcc\u26a0\u4df3\u26c0\u4dc7\u4dd3\u2759\u266f\u4dcf\u272e\u4de0\u4dd0\u4dc8\u4dfc\u4dea\u4dcf\u278d\u4de8\u4deb");
        patternSpace = Pattern.compile(" ");
        patternComma = Pattern.compile(",");
    }

    @Override
    public String getProvidedProtocol() {
        return this.providedProtocol;
    }

    public Protocol(String providedProtocol) {
        if (providedProtocol == null) {
            throw new IllegalArgumentException();
        }
        this.providedProtocol = providedProtocol;
    }
}

