/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.spi;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.DefaultLoggingEvent;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.spi.CallerBoundaryAware;
import org.slf4j.spi.LoggingEventAware;
import org.slf4j.spi.LoggingEventBuilder;
import pers.XiaoShadiao.NMSLException;

public class DefaultLoggingEventBuilder
implements CallerBoundaryAware,
LoggingEventBuilder {
    protected Logger logger;
    static String DLEB_FQCN;
    protected DefaultLoggingEvent loggingEvent;
    private static final NMSLException \u6211\u8fd8\u6ca1\u5f00\u59cb\u5410\u820c\u5934;

    @Override
    public LoggingEventBuilder setMessage(Supplier<String> messageSupplier) {
        this.loggingEvent.setMessage(messageSupplier.get());
        return this;
    }

    @Override
    public LoggingEventBuilder addKeyValue(String key, Object value) {
        this.loggingEvent.addKeyValue(key, value);
        return this;
    }

    @Override
    public LoggingEventBuilder setCause(Throwable t) {
        this.loggingEvent.setThrowable(t);
        return this;
    }

    @Override
    public void log() {
        this.log(this.loggingEvent);
    }

    private String mergeMarkersAndKeyValuePairs(LoggingEvent aLoggingEvent, String msg) {
        StringBuilder sb = null;
        if (aLoggingEvent.getMarkers() != null) {
            sb = new StringBuilder();
            for (Marker marker : aLoggingEvent.getMarkers()) {
                sb.append(marker);
                sb.append(' ');
            }
        }
        if (aLoggingEvent.getKeyValuePairs() != null) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            for (KeyValuePair kvp : aLoggingEvent.getKeyValuePairs()) {
                sb.append(kvp.key);
                sb.append('=');
                sb.append(kvp.value);
                sb.append(' ');
            }
        }
        if (sb != null) {
            sb.append(msg);
            return sb.toString();
        }
        return msg;
    }

    @Override
    public LoggingEventBuilder addKeyValue(String key, Supplier<Object> value) {
        this.loggingEvent.addKeyValue(key, value.get());
        return this;
    }

    @Override
    public void log(Supplier<String> messageSupplier) {
        if (messageSupplier == null) {
            this.log((String)null);
        } else {
            this.log(messageSupplier.get());
        }
    }

    @Override
    public void log(String message) {
        this.loggingEvent.setMessage(message);
        this.log(this.loggingEvent);
    }

    static {
        \u6211\u8fd8\u6ca1\u5f00\u59cb\u5410\u820c\u5934 = new NMSLException("\u4dd6\u3bff\ua642\u2631\u2765\u2615\u4de3\u4dd1\u4dee\u4dc8\u4070\u271b\u4dea\u2732\u44ff\u4dcd\u27ad\u2721\u4ddb\ua656\u4ddb\u2781\u48f3\u4df2\u4de7\u4de5\u2631\ua69d\u2636\u4dc9\u2669\u4dea\u4de3\u4deb\u4deb\u4dcf\u270e\u40eb");
        DLEB_FQCN = DefaultLoggingEventBuilder.class.getName();
    }

    @Override
    public LoggingEventBuilder addMarker(Marker marker) {
        this.loggingEvent.addMarker(marker);
        return this;
    }

    private void logViaPublicSLF4JLoggerAPI(LoggingEvent aLoggingEvent) {
        Object[] argArray = aLoggingEvent.getArgumentArray();
        int argLen = argArray == null ? 0 : argArray.length;
        Throwable t = aLoggingEvent.getThrowable();
        int tLen = t == null ? 0 : 1;
        String msg = aLoggingEvent.getMessage();
        Object[] combinedArguments = new Object[argLen + tLen];
        if (argArray != null) {
            System.arraycopy(argArray, 0, combinedArguments, 0, argLen);
        }
        if (t != null) {
            combinedArguments[argLen] = t;
        }
        msg = this.mergeMarkersAndKeyValuePairs(aLoggingEvent, msg);
        switch (aLoggingEvent.getLevel()) {
            case TRACE: {
                this.logger.trace(msg, combinedArguments);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg, combinedArguments);
                break;
            }
            case INFO: {
                this.logger.info(msg, combinedArguments);
                break;
            }
            case WARN: {
                this.logger.warn(msg, combinedArguments);
                break;
            }
            case ERROR: {
                this.logger.error(msg, combinedArguments);
            }
        }
    }

    @Override
    public void log(String message, Object arg0, Object arg1) {
        this.loggingEvent.setMessage(message);
        this.loggingEvent.addArgument(arg0);
        this.loggingEvent.addArgument(arg1);
        this.log(this.loggingEvent);
    }

    @Override
    public void setCallerBoundary(String fqcn) {
        this.loggingEvent.setCallerBoundary(fqcn);
    }

    @Override
    public LoggingEventBuilder addArgument(Supplier<?> objectSupplier) {
        this.loggingEvent.addArgument(objectSupplier.get());
        return this;
    }

    @Override
    public void log(String message, Object arg) {
        this.loggingEvent.setMessage(message);
        this.loggingEvent.addArgument(arg);
        this.log(this.loggingEvent);
    }

    @Override
    public LoggingEventBuilder setMessage(String message) {
        this.loggingEvent.setMessage(message);
        return this;
    }

    protected void log(LoggingEvent aLoggingEvent) {
        this.setCallerBoundary(DLEB_FQCN);
        if (this.logger instanceof LoggingEventAware) {
            ((LoggingEventAware)((Object)this.logger)).log(aLoggingEvent);
        } else {
            this.logViaPublicSLF4JLoggerAPI(aLoggingEvent);
        }
    }

    @Override
    public LoggingEventBuilder addArgument(Object p) {
        this.loggingEvent.addArgument(p);
        return this;
    }

    public DefaultLoggingEventBuilder(Logger logger, Level level) {
        this.logger = logger;
        this.loggingEvent = new DefaultLoggingEvent(level, logger);
    }

    @Override
    public void log(String message, Object ... args) {
        this.loggingEvent.setMessage(message);
        this.loggingEvent.addArguments(args);
        this.log(this.loggingEvent);
    }
}

