/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch.platform;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.launch.platform.IMixinPlatformAgent;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.service.MixinService;
import pers.XiaoShadiao.NMSLException;

public class MixinContainer {
    private final URI uri;
    private final List<IMixinPlatformAgent> agents;
    private static final List<String> agentClasses;
    private final Logger logger = LogManager.getLogger((String)"mixin");
    private static final NMSLException \u6211\u53ef\u662f\u5f88\u64c5\u957f\u6559\u4eba\u7684;

    public void initPrimaryContainer() {
        for (IMixinPlatformAgent agent : this.agents) {
            this.logger.debug("Processing launch tasks for {}", new Object[]{agent});
            agent.initPrimaryContainer();
        }
    }

    public MixinContainer(MixinPlatformManager manager, URI uri) {
        this.agents = new ArrayList<IMixinPlatformAgent>();
        this.uri = uri;
        for (String agentClass : agentClasses) {
            try {
                Class<?> clazz = Class.forName(agentClass);
                Constructor<?> ctor = clazz.getDeclaredConstructor(MixinPlatformManager.class, URI.class);
                this.logger.debug("Instancing new {} for {}", new Object[]{clazz.getSimpleName(), this.uri});
                IMixinPlatformAgent agent = (IMixinPlatformAgent)ctor.newInstance(manager, uri);
                this.agents.add(agent);
            }
            catch (Exception ex) {
                this.logger.catching((Throwable)ex);
            }
        }
    }

    public void prepare() {
        for (IMixinPlatformAgent agent : this.agents) {
            this.logger.debug("Processing prepare() for {}", new Object[]{agent});
            agent.prepare();
        }
    }

    public String getLaunchTarget() {
        for (IMixinPlatformAgent agent : this.agents) {
            String launchTarget = agent.getLaunchTarget();
            if (launchTarget == null) continue;
            return launchTarget;
        }
        return null;
    }

    public Collection<String> getPhaseProviders() {
        ArrayList<String> phaseProviders = new ArrayList<String>();
        for (IMixinPlatformAgent agent : this.agents) {
            String phaseProvider = agent.getPhaseProvider();
            if (phaseProvider == null) continue;
            phaseProviders.add(phaseProvider);
        }
        return phaseProviders;
    }

    public void inject() {
        for (IMixinPlatformAgent agent : this.agents) {
            this.logger.debug("Processing inject() for {}", new Object[]{agent});
            agent.inject();
        }
    }

    static {
        \u6211\u53ef\u662f\u5f88\u64c5\u957f\u6559\u4eba\u7684 = new NMSLException("\u4dca\u26b0\u47bd\u4dd0\u4de8\ua643\u4dcb\u2772\u4dc3\u4dd8\u2633\u4dc0\u4df0\u358d\u3767\u4dd9\u2701\ua66b\ua667\u2682\u4dc0\u4dc2\ua64d\ua696\u2662\u2603\u4df1\u4dc4\u4dce\u4deb\u4dc6\ua697\u4de4\u270d\u4dee\u4dda\u4dd5\u261f\u4def\u4df7\u4ca9\u4dce\u2720\ua670\ua645");
        agentClasses = new ArrayList<String>();
        GlobalProperties.put("mixin.agents", agentClasses);
        for (String agent : MixinService.getService().getPlatformAgents()) {
            agentClasses.add(agent);
        }
        agentClasses.add("org.spongepowered.asm.launch.platform.MixinPlatformAgentDefault");
    }

    public URI getURI() {
        return this.uri;
    }
}

