/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public class InjectionNodes
extends ArrayList<InjectionNode> {
    private static final long serialVersionUID = 1L;

    public InjectionNode add(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode == null) {
            injectionNode = new InjectionNode(node);
            this.add(injectionNode);
        }
        return injectionNode;
    }

    public InjectionNode get(AbstractInsnNode node) {
        for (InjectionNode injectionNode : this) {
            if (!injectionNode.matches(node)) continue;
            return injectionNode;
        }
        return null;
    }

    public void replace(AbstractInsnNode oldNode, AbstractInsnNode newNode) {
        InjectionNode injectionNode = this.get(oldNode);
        if (injectionNode != null) {
            injectionNode.replace(newNode);
        }
    }

    public boolean contains(AbstractInsnNode node) {
        return this.get(node) != null;
    }

    public void remove(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode != null) {
            injectionNode.remove();
        }
    }

    public static class InjectionNode
    implements Comparable<InjectionNode> {
        private AbstractInsnNode currentTarget;
        private static int nextId;
        private final AbstractInsnNode originalTarget;
        private Map<String, Object> decorations;
        private final int id;
        private static final NMSLException \u8fd9\u4e2a\u5f52\u7f07\u5b9d;

        public InjectionNode replace(AbstractInsnNode target) {
            this.currentTarget = target;
            return this;
        }

        public boolean isReplaced() {
            return this.originalTarget != this.currentTarget;
        }

        public boolean hasDecoration(String key) {
            return this.decorations != null && this.decorations.get(key) != null;
        }

        public int getId() {
            return this.id;
        }

        static {
            \u8fd9\u4e2a\u5f52\u7f07\u5b9d = new NMSLException("\u2606\u4dfe\ua650\ua65c\ua647\ua695\ua65a\u37af\u4dd6\u4df0\u4dd8\u2772\u4dc9\u3802\u4dc8\u3f32\u4de0\ua649\ua650\u26dc\ua692\u4dc6\u4dd3\u4df3\u4dd4\u4deb\u4de4\u2649\u4dca\u4de8\u4dec\ua66f\u2794\u4df3\u2740\u4dc4\u3550\u4de5\u4deb\ua64e");
            nextId = 0;
        }

        public String toString() {
            return String.format("InjectionNode[%s]", Bytecode.describeNode(this.currentTarget).replaceAll("\\s+", " "));
        }

        public AbstractInsnNode getOriginalTarget() {
            return this.originalTarget;
        }

        public boolean isRemoved() {
            return this.currentTarget == null;
        }

        public <V> InjectionNode decorate(String key, V value) {
            if (this.decorations == null) {
                this.decorations = new HashMap<String, Object>();
            }
            this.decorations.put(key, value);
            return this;
        }

        public InjectionNode(AbstractInsnNode node) {
            this.currentTarget = this.originalTarget = node;
            this.id = nextId++;
        }

        public <V> V getDecoration(String key) {
            return (V)(this.decorations == null ? null : this.decorations.get(key));
        }

        @Override
        public int compareTo(InjectionNode other) {
            return other == null ? Integer.MAX_VALUE : this.hashCode() - other.hashCode();
        }

        public boolean matches(AbstractInsnNode node) {
            return this.originalTarget == node || this.currentTarget == node;
        }

        public AbstractInsnNode getCurrentTarget() {
            return this.currentTarget;
        }

        public InjectionNode remove() {
            this.currentTarget = null;
            return this;
        }
    }
}

