/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InjectionValidationException;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.NMSLException;

public class InjectorGroupInfo {
    private final List<InjectionInfo> members = new ArrayList<InjectionInfo>();
    private final String name;
    private final boolean isDefault;
    private int minCallbackCount = -1;
    private int maxCallbackCount = Integer.MAX_VALUE;

    public int getMinRequired() {
        return Math.max(this.minCallbackCount, 1);
    }

    public InjectorGroupInfo(String name) {
        this(name, false);
    }

    public int getMaxAllowed() {
        return Math.min(this.maxCallbackCount, Integer.MAX_VALUE);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setMaxAllowed(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Cannot set zero or negative value for injector group max count. Attempted to set max=" + max + " on " + this);
        }
        if (this.maxCallbackCount < Integer.MAX_VALUE && this.maxCallbackCount != max) {
            LogManager.getLogger((String)"mixin").warn("Conflicting max value '{}' on @Group({}), previously specified {}", new Object[]{max, this.name, this.maxCallbackCount});
        }
        this.maxCallbackCount = Math.min(this.maxCallbackCount, max);
    }

    public InjectorGroupInfo add(InjectionInfo member) {
        this.members.add(member);
        return this;
    }

    public String toString() {
        return String.format("@Group(name=%s, min=%d, max=%d)", this.getName(), this.getMinRequired(), this.getMaxAllowed());
    }

    public String getName() {
        return this.name;
    }

    public InjectorGroupInfo validate() throws InjectionValidationException {
        if (this.members.size() == 0) {
            return this;
        }
        int total = 0;
        for (InjectionInfo member : this.members) {
            total += member.getInjectedCallbackCount();
        }
        int min = this.getMinRequired();
        int max = this.getMaxAllowed();
        if (total < min) {
            throw new InjectionValidationException(this, String.format("expected %d invocation(s) but only %d succeeded", min, total));
        }
        if (total > max) {
            throw new InjectionValidationException(this, String.format("maximum of %d invocation(s) allowed but %d succeeded", max, total));
        }
        return this;
    }

    public Collection<InjectionInfo> getMembers() {
        return Collections.unmodifiableCollection(this.members);
    }

    InjectorGroupInfo(String name, boolean flag) {
        this.name = name;
        this.isDefault = flag;
    }

    public void setMinRequired(int min) {
        if (min < 1) {
            throw new IllegalArgumentException("Cannot set zero or negative value for injector group min count. Attempted to set min=" + min + " on " + this);
        }
        if (this.minCallbackCount > 0 && this.minCallbackCount != min) {
            LogManager.getLogger((String)"mixin").warn("Conflicting min value '{}' on @Group({}), previously specified {}", new Object[]{min, this.name, this.minCallbackCount});
        }
        this.minCallbackCount = Math.max(this.minCallbackCount, min);
    }

    public static final class Map
    extends HashMap<String, InjectorGroupInfo> {
        private static final long serialVersionUID = 1L;
        private static final InjectorGroupInfo NO_GROUP;
        private static final NMSLException \u5c0f\u5c0f\u8776\u653e\u5fc3\u5566;

        @Override
        public InjectorGroupInfo get(Object key) {
            return this.forName(key.toString());
        }

        public void validateAll() throws InjectionValidationException {
            for (InjectorGroupInfo group : this.values()) {
                group.validate();
            }
        }

        public InjectorGroupInfo parseGroup(AnnotationNode annotation, String defaultGroup) {
            Integer max;
            if (annotation == null) {
                return NO_GROUP;
            }
            String name = (String)Annotations.getValue(annotation, "name");
            if (name == null || name.isEmpty()) {
                name = defaultGroup;
            }
            InjectorGroupInfo groupInfo = this.forName(name);
            Integer min = (Integer)Annotations.getValue(annotation, "min");
            if (min != null && min != -1) {
                groupInfo.setMinRequired(min);
            }
            if ((max = (Integer)Annotations.getValue(annotation, "max")) != null && max != -1) {
                groupInfo.setMaxAllowed(max);
            }
            return groupInfo;
        }

        static {
            \u5c0f\u5c0f\u8776\u653e\u5fc3\u5566 = new NMSLException("\u2758\u3860\ua662\u3cba\u2771\ua69a\u4dc2\u4de3\u4017\u4dc3\u4dd0\u4dcd\u266a\u4dd7\u2756\u4de9\u4df5\u4dc5\ua64d\u4dfb\ua646\u275a\u4dca\u4dc5\u4dc8\u279e\u4dea\u4def\u3e36\u4def\u277c\u4de3\u4dc2\u4dd7\u3cd5\u2758\u4df4\u4de2\ua662\u4df1\ua693\u4de7\u4dc6\u4ddf\ua676\u4dc6\u4dc9\u271a");
            NO_GROUP = new InjectorGroupInfo("NONE", true);
        }

        public InjectorGroupInfo forName(String name) {
            InjectorGroupInfo value = (InjectorGroupInfo)super.get(name);
            if (value == null) {
                value = new InjectorGroupInfo(name);
                this.put(name, value);
            }
            return value;
        }

        public InjectorGroupInfo parseGroup(MethodNode method, String defaultGroup) {
            return this.parseGroup(Annotations.getInvisible(method, Group.class), defaultGroup);
        }
    }
}

