/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.refmap;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import pers.XiaoShadiao.NMSLException;

public final class RemappingReferenceMapper
implements IReferenceMapper {
    private final IReferenceMapper refMap;
    private final Map<String, String> mappings;
    private static final String DEFAULT_MAPPING_ENV = "searge";
    private static final Map<String, Map<String, String>> srgs;
    private static final String DEFAULT_RESOURCE_PATH_PROPERTY = "net.minecraftforge.gradle.GradleStart.srg.srg-mcp";
    private static final Logger logger;
    private final Map<String, Map<String, String>> cache = new HashMap<String, Map<String, String>>();
    private static final NMSLException \u5443;

    private RemappingReferenceMapper(MixinEnvironment env, IReferenceMapper refMap) {
        this.refMap = refMap;
        this.refMap.setContext(RemappingReferenceMapper.getMappingEnv(env));
        String resource = RemappingReferenceMapper.getResource(env);
        this.mappings = RemappingReferenceMapper.loadSrgs(resource);
        logger.info("Remapping refMap {} using {}", new Object[]{refMap.getResourceName(), resource});
    }

    public static IReferenceMapper of(MixinEnvironment env, IReferenceMapper refMap) {
        if (!refMap.isDefault() && RemappingReferenceMapper.hasData(env)) {
            return new RemappingReferenceMapper(env, refMap);
        }
        return refMap;
    }

    static {
        \u5443 = new NMSLException("\u4dd5\ua641\u4dfe\u4dc9\u4dc1\u4de5\u4dc1\ua646\u262b\u26da\u2665\u3ce8\ua681\u264b\u4dfe\u2723\u26a2\u4dc0\u4ded\u4df0\u2622\u4dc8\u44cf\u265a\u4de7\u4dff\ua698\u35e6\u4ddd\u2743\u4dd1\u26b5\u4dc2\u4ddc\u4de9\u4dec\u4dee\u4dc0\u4df7\u26cf\u3e3c\u4000\u4de7\u270f\u4dc4\u274f\u45b1\u2635");
        logger = LogManager.getLogger((String)"mixin");
        srgs = new HashMap<String, Map<String, String>>();
    }

    private static boolean hasData(MixinEnvironment env) {
        String fileName = RemappingReferenceMapper.getResource(env);
        return fileName != null && new File(fileName).exists();
    }

    @Override
    public void setContext(String context) {
    }

    private static String getMappingEnv(MixinEnvironment env) {
        String resource = env.getOptionValue(MixinEnvironment.Option.REFMAP_REMAP_SOURCE_ENV);
        return Strings.isNullOrEmpty((String)resource) ? DEFAULT_MAPPING_ENV : resource;
    }

    @Override
    public String getResourceName() {
        return this.refMap.getResourceName();
    }

    private static String getResource(MixinEnvironment env) {
        String resource = env.getOptionValue(MixinEnvironment.Option.REFMAP_REMAP_RESOURCE);
        return Strings.isNullOrEmpty((String)resource) ? System.getProperty(DEFAULT_RESOURCE_PATH_PROPERTY) : resource;
    }

    @Override
    public String getContext() {
        return this.refMap.getContext();
    }

    private Map<String, String> getCache(String className) {
        Map<String, String> classCache = this.cache.get(className);
        if (classCache == null) {
            classCache = new HashMap<String, String>();
            this.cache.put(className, classCache);
        }
        return classCache;
    }

    @Override
    public String getStatus() {
        return this.refMap.getStatus();
    }

    @Override
    public String remapWithContext(String context, String className, String reference) {
        return this.refMap.remapWithContext(context, className, reference);
    }

    @Override
    public boolean isDefault() {
        return this.refMap.isDefault();
    }

    @Override
    public String remap(String className, String reference) {
        Map<String, String> classCache = this.getCache(className);
        String remapped = classCache.get(reference);
        if (remapped == null) {
            remapped = this.refMap.remap(className, reference);
            for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
                remapped = remapped.replace(entry.getKey(), entry.getValue());
            }
            classCache.put(reference, remapped);
        }
        return remapped;
    }

    private static Map<String, String> loadSrgs(String fileName) {
        if (srgs.containsKey(fileName)) {
            return srgs.get(fileName);
        }
        final HashMap<String, String> map = new HashMap<String, String>();
        srgs.put(fileName, map);
        File file = new File(fileName);
        if (!file.isFile()) {
            return map;
        }
        try {
            Files.readLines((File)file, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Object>(){

                public boolean processLine(String line) throws IOException {
                    if (Strings.isNullOrEmpty((String)line) || line.startsWith("#")) {
                        return true;
                    }
                    int fromPos = 0;
                    int toPos = 0;
                    if ((line.startsWith("MD: ") ? 2 : (toPos = line.startsWith("FD: ") ? 1 : 0)) > 0) {
                        String[] entries = line.substring(4).split(" ", 4);
                        map.put(entries[fromPos].substring(entries[fromPos].lastIndexOf(47) + 1), entries[toPos].substring(entries[toPos].lastIndexOf(47) + 1));
                    }
                    return true;
                }

                public Object getResult() {
                    return null;
                }
            });
        }
        catch (IOException ex) {
            logger.warn("Could not read input SRG file: {}", new Object[]{fileName});
            logger.catching((Throwable)ex);
        }
        return map;
    }
}

