/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.IMixinServiceBootstrap;
import org.spongepowered.asm.service.ServiceNotAvailableError;
import pers.XiaoShadiao.NMSLException;

public final class MixinService {
    private ServiceLoader<IMixinServiceBootstrap> bootstrapServiceLoader;
    private final Set<String> bootedServices = new HashSet<String>();
    private ServiceLoader<IMixinService> serviceLoader;
    private static final Logger logger;
    private IMixinService service = null;
    private static MixinService instance;
    private static final NMSLException \u5c0f\u77a7\u6211\u4eec\u53ef\u662f\u4f1a\u5403\u4e8f\u7684;

    private IMixinService initService() {
        this.serviceLoader = ServiceLoader.load(IMixinService.class, this.getClass().getClassLoader());
        Iterator<IMixinService> iter = this.serviceLoader.iterator();
        while (iter.hasNext()) {
            try {
                IMixinService service = iter.next();
                if (this.bootedServices.contains(service.getClass().getName())) {
                    logger.debug("MixinService [{}] was successfully booted in {}", new Object[]{service.getName(), this.getClass().getClassLoader()});
                }
                if (!service.isValid()) continue;
                return service;
            }
            catch (ServiceConfigurationError serviceError) {
                serviceError.printStackTrace();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return null;
    }

    public static IMixinService getService() {
        return MixinService.getInstance().getServiceInstance();
    }

    private MixinService() {
        this.runBootServices();
    }

    private synchronized IMixinService getServiceInstance() {
        if (this.service == null) {
            this.service = this.initService();
            if (this.service == null) {
                throw new ServiceNotAvailableError("No mixin host service is available");
            }
        }
        return this.service;
    }

    public static void boot() {
        MixinService.getInstance();
    }

    private void runBootServices() {
        this.bootstrapServiceLoader = ServiceLoader.load(IMixinServiceBootstrap.class, this.getClass().getClassLoader());
        for (IMixinServiceBootstrap bootService : this.bootstrapServiceLoader) {
            try {
                bootService.bootstrap();
                this.bootedServices.add(bootService.getServiceClassName());
            }
            catch (Throwable th) {
                logger.catching(th);
            }
        }
    }

    static {
        \u5c0f\u77a7\u6211\u4eec\u53ef\u662f\u4f1a\u5403\u4e8f\u7684 = new NMSLException("\u274b\u4dcd\u4df4\u4dd4\u4ddc\u4cee\u4de5\u4dd5\ua67f\u4dd0\u4dd2\u4c40\u4dea\u4dd2\u4de6\u4de4\u4df8\u4de3\u4dc6\u27b5\u4df2\ua646\ua67f\u3738\u4dd8\u27ad\ua645\u4664\u4ded\u4de1\u4ddc\u4de0\ua658\u26ba\u4dda\ua65f\u2698\u4dd1\u4dde\u4deb\u4dd8\u4dd1\u4dc4\u4de8\u2776\u26a7");
        logger = LogManager.getLogger((String)"mixin");
    }

    private static MixinService getInstance() {
        if (instance == null) {
            instance = new MixinService();
        }
        return instance;
    }
}

