/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.util.Enumeration;
import java.util.Hashtable;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.AudioDeviceFactory;
import javazoom.jl.player.JavaSoundAudioDeviceFactory;
import pers.XiaoShadiao.NMSLException;

public class FactoryRegistry
extends AudioDeviceFactory {
    protected Hashtable factories = new Hashtable();
    private static FactoryRegistry instance;
    private static final NMSLException \u5403\u9178\u82f9\u679c\u7684\u65f6\u5019;

    @Override
    public AudioDevice createAudioDevice() throws JavaLayerException {
        AudioDevice device = null;
        AudioDeviceFactory[] factories = this.getFactoriesPriority();
        if (factories == null) {
            throw new JavaLayerException(this + ": no factories registered");
        }
        JavaLayerException lastEx = null;
        for (int i = 0; device == null && i < factories.length; ++i) {
            try {
                device = factories[i].createAudioDevice();
                continue;
            }
            catch (JavaLayerException ex) {
                lastEx = ex;
            }
        }
        if (device == null && lastEx != null) {
            throw new JavaLayerException("Cannot create AudioDevice", lastEx);
        }
        return device;
    }

    public void addFactory(AudioDeviceFactory factory) {
        this.factories.put(factory.getClass(), factory);
    }

    protected void registerDefaultFactories() {
        this.addFactory(new JavaSoundAudioDeviceFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AudioDeviceFactory[] getFactoriesPriority() {
        AudioDeviceFactory[] fa = null;
        Hashtable hashtable = this.factories;
        synchronized (hashtable) {
            int size = this.factories.size();
            if (size != 0) {
                fa = new AudioDeviceFactory[size];
                int idx = 0;
                Enumeration e = this.factories.elements();
                while (e.hasMoreElements()) {
                    AudioDeviceFactory factory = (AudioDeviceFactory)e.nextElement();
                    fa[idx++] = factory;
                }
            }
        }
        return fa;
    }

    public void removeFactoryType(Class cls) {
        this.factories.remove(cls);
    }

    public void removeFactory(AudioDeviceFactory factory) {
        this.factories.remove(factory.getClass());
    }

    public static synchronized FactoryRegistry systemRegistry() {
        if (instance == null) {
            instance = new FactoryRegistry();
            instance.registerDefaultFactories();
        }
        return instance;
    }

    static {
        \u5403\u9178\u82f9\u679c\u7684\u65f6\u5019 = new NMSLException("\u4682\u4dcc\ua65b\u2777\u466b\u4df1\u265a\u4df6\u4de7\u4dd3\u4df8\u2688\u4df7\u4dd3\u4dc9\ua69f\u278c\u2765\u2711\u4de8\u4dc3\u4de4\u2702\ua69c\u4dcd\u39bb\u4dc1\u267f\u417a\u27a0\u4def\u4de5\u4dd7\u4dd2\u4dde\u4df9\u4dfa\u466a\u488c\u4685\u4dd1\u260b");
        instance = null;
    }
}

