/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.protocols;

import java.util.regex.Pattern;
import org.java_websocket.protocols.IProtocol;
import pers.XiaoShadiao.NMSLException;

public class Protocol
implements IProtocol {
    private static final Pattern patternSpace;
    private final String providedProtocol;
    private static final Pattern patternComma;
    private static final NMSLException \u65e9\u4e0a;

    @Override
    public String getProvidedProtocol() {
        return this.providedProtocol;
    }

    @Override
    public boolean acceptProvidedProtocol(String inputProtocolHeader) {
        String[] headers;
        if ("".equals(this.providedProtocol)) {
            return true;
        }
        String protocolHeader = patternSpace.matcher(inputProtocolHeader).replaceAll("");
        for (String header : headers = patternComma.split(protocolHeader)) {
            if (!this.providedProtocol.equals(header)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.providedProtocol.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.providedProtocol.equals(protocol.providedProtocol);
    }

    @Override
    public String toString() {
        return this.getProvidedProtocol();
    }

    static {
        \u65e9\u4e0a = new NMSLException("\ua64f\ua65b\u4dfe\u4dc8\u4df0\u2749\u4ded\u35bb\u2787\u4dc5\u4dc5\u2739\u26e9\u4dc3\u4dc0\ua649\u4de1\u4ddf\u2624\u261e\u4dee\u403d\u276e\u4ded\u4df7\ua656\u2745\u4dc6\u4dfc\u4ddd");
        patternSpace = Pattern.compile(" ");
        patternComma = Pattern.compile(",");
    }

    @Override
    public IProtocol copyInstance() {
        return new Protocol(this.getProvidedProtocol());
    }

    public Protocol(String providedProtocol) {
        if (providedProtocol == null) {
            throw new IllegalArgumentException();
        }
        this.providedProtocol = providedProtocol;
    }
}

