/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import pers.XiaoShadiao.NMSLException;

public final class Util {
    private static boolean SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED;
    private static ClassContextSecurityManager SECURITY_MANAGER;
    private static final NMSLException \u8fdc\u65b9\u4f1a\u662f\u65b0\u7684\u4e16\u754c;

    private Util() {
    }

    private static ClassContextSecurityManager safeCreateSecurityManager() {
        try {
            return new ClassContextSecurityManager();
        }
        catch (SecurityException sm) {
            return null;
        }
    }

    public static String safeGetSystemProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null input");
        }
        String result = null;
        try {
            result = System.getProperty(key);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return result;
    }

    private static ClassContextSecurityManager getSecurityManager() {
        if (SECURITY_MANAGER != null) {
            return SECURITY_MANAGER;
        }
        if (SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED) {
            return null;
        }
        SECURITY_MANAGER = Util.safeCreateSecurityManager();
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = true;
        return SECURITY_MANAGER;
    }

    public static final void report(String msg, Throwable t) {
        System.err.println(msg);
        System.err.println("Reported exception:");
        t.printStackTrace();
    }

    public static boolean safeGetBooleanSystemProperty(String key) {
        String value = Util.safeGetSystemProperty(key);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    public static final void report(String msg) {
        System.err.println("SLF4J: " + msg);
    }

    static {
        \u8fdc\u65b9\u4f1a\u662f\u65b0\u7684\u4e16\u754c = new NMSLException("\u26e5\u4de5\u4dc6\u4dd2\u4de1\ua69b\u4dc8\u4dde\u4de3\u4ddd\u4dec\u266e\u4dd4\u4dd7\u4dc7\u4dc4\u4de5\u4de0\u40a3\u27a6\ua671\u4dc0\u4de4\u4187\u2699\u4df8\u4dd9\u4dea\ua651\u34af\u4dd0\u4dec\u4dd3\u3449\u272d\u4de9\u26ee\u3d0e\ua64b\u4df6\u4df3\u4dc2\ua66d\u27b8\u4363\u267d\u4df2\u4dda");
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = false;
    }

    public static Class<?> getCallingClass() {
        int i;
        ClassContextSecurityManager securityManager = Util.getSecurityManager();
        if (securityManager == null) {
            return null;
        }
        Class<?>[] trace = securityManager.getClassContext();
        String thisClassName = Util.class.getName();
        for (i = 0; i < trace.length && !thisClassName.equals(trace[i].getName()); ++i) {
        }
        if (i >= trace.length || i + 2 >= trace.length) {
            throw new IllegalStateException("Failed to find org.slf4j.helpers.Util or its caller in the stack; this should not happen");
        }
        return trace[i + 2];
    }

    private static final class ClassContextSecurityManager
    extends SecurityManager {
        private ClassContextSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

