/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.launch.MixinInitialisationError;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.service.MixinService;
import pers.XiaoShadiao.NMSLException;

public abstract class MixinBootstrap {
    private static final Logger logger;
    private static boolean initState;
    private static MixinPlatformManager platform;
    public static final String VERSION = "0.7.11";
    private static boolean initialised;
    private static final NMSLException \u5927\u6d77\u53d8\u6210\u96e8\u6ef4;

    public static void init() {
        if (!MixinBootstrap.start()) {
            return;
        }
        MixinBootstrap.doInit(null);
    }

    public static MixinPlatformManager getPlatform() {
        if (platform == null) {
            Object globalPlatformManager = GlobalProperties.get("mixin.platform");
            if (globalPlatformManager instanceof MixinPlatformManager) {
                platform = (MixinPlatformManager)globalPlatformManager;
            } else {
                platform = new MixinPlatformManager();
                GlobalProperties.put("mixin.platform", platform);
                platform.init();
            }
        }
        return platform;
    }

    private MixinBootstrap() {
    }

    private static boolean checkSubsystemVersion() {
        return VERSION.equals(MixinBootstrap.getActiveSubsystemVersion());
    }

    private static void registerSubsystem(String version) {
        GlobalProperties.put("mixin.initialised", version);
    }

    private static boolean isSubsystemRegistered() {
        return GlobalProperties.get("mixin.initialised") != null;
    }

    static void doInit(List<String> args) {
        if (!initialised) {
            if (MixinBootstrap.isSubsystemRegistered()) {
                logger.warn("Multiple Mixin containers present, init suppressed for 0.7.11");
                return;
            }
            throw new IllegalStateException("MixinBootstrap.doInit() called before MixinBootstrap.start()");
        }
        MixinBootstrap.getPlatform().getPhaseProviderClasses();
        if (initState) {
            MixinBootstrap.getPlatform().prepare(args);
            MixinService.getService().init();
        }
    }

    static boolean start() {
        if (MixinBootstrap.isSubsystemRegistered()) {
            if (!MixinBootstrap.checkSubsystemVersion()) {
                throw new MixinInitialisationError("Mixin subsystem version " + MixinBootstrap.getActiveSubsystemVersion() + " was already initialised. Cannot bootstrap version " + VERSION);
            }
            return false;
        }
        MixinBootstrap.registerSubsystem(VERSION);
        if (!initialised) {
            MixinEnvironment.Phase initialPhase;
            initialised = true;
            String command = System.getProperty("sun.java.command");
            if (command != null && command.contains("GradleStart")) {
                System.setProperty("mixin.env.remapRefMap", "true");
            }
            if ((initialPhase = MixinService.getService().getInitialPhase()) == MixinEnvironment.Phase.DEFAULT) {
                logger.error("Initialising mixin subsystem after game pre-init phase! Some mixins may be skipped.");
                MixinEnvironment.init(initialPhase);
                MixinBootstrap.getPlatform().prepare(null);
                initState = false;
            } else {
                MixinEnvironment.init(initialPhase);
            }
            MixinService.getService().beginPhase();
        }
        MixinBootstrap.getPlatform();
        return true;
    }

    private static Object getActiveSubsystemVersion() {
        Object version = GlobalProperties.get("mixin.initialised");
        return version != null ? version : "";
    }

    static void inject() {
        MixinBootstrap.getPlatform().inject();
    }

    @Deprecated
    public static void addProxy() {
        MixinService.getService().beginPhase();
    }

    static {
        \u5927\u6d77\u53d8\u6210\u96e8\u6ef4 = new NMSLException("\ua684\u4dda\u4dc8\u278d\u4dea\u4dfc\ua68c\u4dc3\ua64f\u4dfb\ua662\u4dec\ua666\u4830\ua679\u45b1\u4dd9\u4dc7\u4ddb\u4df4\u2600\u4df3\u4dd7\u4deb\u26b2\u4ddf\u4dcf\u2728\ua692\u2644\u4de4\ua694");
        logger = LogManager.getLogger((String)"mixin");
        initialised = false;
        initState = true;
        MixinService.boot();
        MixinService.getService().prepare();
    }
}

