/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.commons.ClassRemapper;
import org.spongepowered.asm.lib.commons.Remapper;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.ext.IClassGenerator;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.transformers.MixinClassWriter;
import pers.XiaoShadiao.NMSLException;

final class InnerClassGenerator
implements IClassGenerator {
    private static final Logger logger;
    private final Map<String, String> innerClassNames = new HashMap<String, String>();
    private final Map<String, InnerClassInfo> innerClasses = new HashMap<String, InnerClassInfo>();
    private static final NMSLException \u6211\u662f\u7f07\u5b81;

    public String registerInnerClass(MixinInfo owner, String originalName, MixinTargetContext context) {
        String id = String.format("%s%s", originalName, context);
        String ref = this.innerClassNames.get(id);
        if (ref == null) {
            ref = InnerClassGenerator.getUniqueReference(originalName, context);
            this.innerClassNames.put(id, ref);
            this.innerClasses.put(ref, new InnerClassInfo(ref, originalName, owner, context));
            logger.debug("Inner class {} in {} on {} gets unique name {}", new Object[]{originalName, owner.getClassRef(), context.getTargetClassRef(), ref});
        }
        return ref;
    }

    private byte[] generate(InnerClassInfo info) {
        try {
            logger.debug("Generating mapped inner class {} (originally {})", new Object[]{info.getName(), info.getOriginalName()});
            ClassReader cr = new ClassReader(info.getClassBytes());
            MixinClassWriter cw = new MixinClassWriter(cr, 0);
            cr.accept(new InnerClassAdapter((ClassVisitor)cw, info), 8);
            return cw.toByteArray();
        }
        catch (InvalidMixinException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.catching((Throwable)ex);
            return null;
        }
    }

    private static String getUniqueReference(String originalName, MixinTargetContext context) {
        String name = originalName.substring(originalName.lastIndexOf(36) + 1);
        if (name.matches("^[0-9]+$")) {
            name = "Anonymous";
        }
        return String.format("%s$%s$%s", context.getTargetClassRef(), name, UUID.randomUUID().toString().replace("-", ""));
    }

    InnerClassGenerator() {
    }

    static {
        \u6211\u662f\u7f07\u5b81 = new NMSLException("\u4df3\u26d3\u4dc0\u4dc4\u4df6\u2718\u2648\ua692\u4df8\u4dce\u4df5\u4df5\u2730\ua658\u3e10\u26c4\u39ca\u26d6\u4ddb\u4df0\u4de5\u4de0\ua688\u47d9\ua683\u2633\u26d5\u4def\u4dce\u271a\u2691\u4dd2\ua663\u4dd4\ua663\u4ddb\u4dc9\u2799\ua667\u3e1d\u3984\u273d\u4df0\u4df3\u26cd\u4dee\ua693\u4ded\u4dd5");
        logger = LogManager.getLogger((String)"mixin");
    }

    @Override
    public byte[] generate(String name) {
        String ref = name.replace('.', '/');
        InnerClassInfo info = this.innerClasses.get(ref);
        if (info != null) {
            return this.generate(info);
        }
        return null;
    }

    static class InnerClassAdapter
    extends ClassRemapper {
        private final InnerClassInfo info;

        @Override
        public void visitSource(String source, String debug) {
            super.visitSource(source, debug);
            AnnotationVisitor av = this.cv.visitAnnotation("Lorg/spongepowered/asm/mixin/transformer/meta/MixinInner;", false);
            av.visit("mixin", this.info.getOwner().toString());
            av.visit("name", this.info.getOriginalName().substring(this.info.getOriginalName().lastIndexOf(47) + 1));
            av.visitEnd();
        }

        public InnerClassAdapter(ClassVisitor cv, InnerClassInfo info) {
            super(327680, cv, info);
            this.info = info;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (name.startsWith(this.info.getOriginalName() + "$")) {
                throw new InvalidMixinException((IMixinInfo)this.info.getOwner(), "Found unsupported nested inner class " + name + " in " + this.info.getOriginalName());
            }
            super.visitInnerClass(name, outerName, innerName, access);
        }
    }

    static class InnerClassInfo
    extends Remapper {
        private final String originalName;
        private final String name;
        private final String targetName;
        private final MixinTargetContext target;
        private final String ownerName;
        private final MixinInfo owner;

        String getTargetName() {
            return this.targetName;
        }

        MixinTargetContext getTarget() {
            return this.target;
        }

        String getOwnerName() {
            return this.ownerName;
        }

        byte[] getClassBytes() throws ClassNotFoundException, IOException {
            return MixinService.getService().getBytecodeProvider().getClassBytes(this.originalName, true);
        }

        MixinInfo getOwner() {
            return this.owner;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String map(String key) {
            if (this.originalName.equals(key)) {
                return this.name;
            }
            if (this.ownerName.equals(key)) {
                return this.targetName;
            }
            return key;
        }

        @Override
        public String mapMethodName(String owner, String name, String desc) {
            ClassInfo.Method method;
            if (this.ownerName.equalsIgnoreCase(owner) && (method = this.owner.getClassInfo().findMethod(name, desc, 10)) != null) {
                return method.getName();
            }
            return super.mapMethodName(owner, name, desc);
        }

        String getOriginalName() {
            return this.originalName;
        }

        String getName() {
            return this.name;
        }

        InnerClassInfo(String name, String originalName, MixinInfo owner, MixinTargetContext target) {
            this.name = name;
            this.originalName = originalName;
            this.owner = owner;
            this.ownerName = owner.getClassRef();
            this.target = target;
            this.targetName = target.getTargetClassRef();
        }
    }
}

