/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.debug;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.spongepowered.asm.mixin.transformer.ext.IDecompiler;
import pers.XiaoShadiao.NMSLException;

public class RuntimeDecompiler
extends IFernflowerLogger
implements IResultSaver,
IDecompiler {
    private static final Level[] SEVERITY_LEVELS;
    private final Map<String, Object> options = ImmutableMap.builder().put((Object)"din", (Object)"0").put((Object)"rbr", (Object)"0").put((Object)"dgs", (Object)"1").put((Object)"asc", (Object)"1").put((Object)"den", (Object)"1").put((Object)"hdc", (Object)"1").put((Object)"ind", (Object)"    ").build();
    protected final Logger logger = LogManager.getLogger((String)"fernflower");
    private final File outputPath;
    private static final NMSLException \u5fc5\u987b\u652f\u6301;

    public RuntimeDecompiler(File outputPath) {
        this.outputPath = outputPath;
        if (this.outputPath.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.outputPath);
            }
            catch (IOException ex) {
                this.logger.warn("Error cleaning output directory: {}", new Object[]{ex.getMessage()});
            }
        }
    }

    public void startReadingClass(String className) {
        this.logger.info("Decompiling {}", new Object[]{className});
    }

    @Override
    public void decompile(File file) {
        try {
            Fernflower fernflower = new Fernflower(new IBytecodeProvider(){
                private byte[] byteCode;

                public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
                    if (this.byteCode == null) {
                        this.byteCode = InterpreterUtil.getBytes((File)new File(externalPath));
                    }
                    return this.byteCode;
                }
            }, (IResultSaver)this, this.options, (IFernflowerLogger)this);
            fernflower.getStructContext().addSpace(file, true);
            fernflower.decompileContext();
        }
        catch (Throwable ex) {
            this.logger.warn("Decompilation error while processing {}", new Object[]{file.getName()});
        }
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity) {
        this.logger.log(SEVERITY_LEVELS[severity.ordinal()], message);
    }

    public void copyFile(String source, String path, String entryName) {
    }

    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content) {
    }

    public void saveFolder(String path) {
    }

    public void saveDirEntry(String path, String archiveName, String entryName) {
    }

    public void writeMessage(String message, Throwable t) {
        this.logger.warn("{} {}: {}", new Object[]{message, t.getClass().getSimpleName(), t.getMessage()});
    }

    public void createArchive(String path, String archiveName, Manifest manifest) {
    }

    public void closeArchive(String path, String archiveName) {
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t) {
        this.logger.log(SEVERITY_LEVELS[severity.ordinal()], message, t);
    }

    static {
        \u5fc5\u987b\u652f\u6301 = new NMSLException("\u4dd9\u2652\u46d6\u2760\u3665\u4d31\u4dd4\ua69c\u4dc5\u4df7\u4708\u4de9\u3a4a\u4dea\u4de5\u3814\u4ddd\u4903\u277b\u4ddf\u271e\u4de9\u4dce\u4dd0\u275e\u4dd7\u4de9\u4de5\u2776\u2719\u26f1\u2751\u2793");
        SEVERITY_LEVELS = new Level[]{Level.TRACE, Level.INFO, Level.WARN, Level.ERROR};
    }

    public void copyEntry(String source, String path, String archiveName, String entry) {
    }

    public void saveClassFile(String path, String qualifiedName, String entryName, String content, int[] mapping) {
        File file = new File(this.outputPath, qualifiedName + ".java");
        file.getParentFile().mkdirs();
        try {
            this.logger.info("Writing {}", new Object[]{file.getAbsolutePath()});
            Files.write((CharSequence)content, (File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException ex) {
            this.writeMessage("Cannot write source file " + file, ex);
        }
    }
}

