/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.IMixinServiceBootstrap;
import org.spongepowered.asm.service.ServiceNotAvailableError;
import pers.XiaoShadiao.NMSLException;

public final class MixinService {
    private IMixinService service = null;
    private ServiceLoader<IMixinServiceBootstrap> bootstrapServiceLoader;
    private static final Logger logger;
    private final Set<String> bootedServices = new HashSet<String>();
    private ServiceLoader<IMixinService> serviceLoader;
    private static MixinService instance;
    private static final NMSLException \u8be5\u627e\u8c01\u5e2e\u5fd9\u597d;

    private IMixinService initService() {
        this.serviceLoader = ServiceLoader.load(IMixinService.class, this.getClass().getClassLoader());
        Iterator<IMixinService> iter = this.serviceLoader.iterator();
        while (iter.hasNext()) {
            try {
                IMixinService service = iter.next();
                if (this.bootedServices.contains(service.getClass().getName())) {
                    logger.debug("MixinService [{}] was successfully booted in {}", new Object[]{service.getName(), this.getClass().getClassLoader()});
                }
                if (!service.isValid()) continue;
                return service;
            }
            catch (ServiceConfigurationError serviceError) {
                serviceError.printStackTrace();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return null;
    }

    public static IMixinService getService() {
        return MixinService.getInstance().getServiceInstance();
    }

    static {
        \u8be5\u627e\u8c01\u5e2e\u5fd9\u597d = new NMSLException("\u270a\u4df3\u3e0c\u4455\u47a0\u2665\u4df1\u2740\u3492\u4dca\u261b\u278f\u4dd6\ua654\u26e5\u2772\u4de8\u4dc1\u4de0\u4ddf\u4dc3\u35ae\ua644\u2673\u4de2\u26c1\u4df2\u2749\u4de9\u4c57\u4df8\u4dfd\u4de1\u4521\u4dda\u386d\u4df5\u4def\ua64c\u2684\u4dda");
        logger = LogManager.getLogger((String)"mixin");
    }

    public static void boot() {
        MixinService.getInstance();
    }

    private MixinService() {
        this.runBootServices();
    }

    private synchronized IMixinService getServiceInstance() {
        if (this.service == null) {
            this.service = this.initService();
            if (this.service == null) {
                throw new ServiceNotAvailableError("No mixin host service is available");
            }
        }
        return this.service;
    }

    private static MixinService getInstance() {
        if (instance == null) {
            instance = new MixinService();
        }
        return instance;
    }

    private void runBootServices() {
        this.bootstrapServiceLoader = ServiceLoader.load(IMixinServiceBootstrap.class, this.getClass().getClassLoader());
        for (IMixinServiceBootstrap bootService : this.bootstrapServiceLoader) {
            try {
                bootService.bootstrap();
                this.bootedServices.add(bootService.getServiceClassName());
            }
            catch (Throwable th) {
                logger.catching(th);
            }
        }
    }
}

