/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.util.ITokenProvider;
import org.spongepowered.tools.obfuscation.AnnotatedMixin;
import org.spongepowered.tools.obfuscation.ObfuscationManager;
import org.spongepowered.tools.obfuscation.TargetMap;
import org.spongepowered.tools.obfuscation.interfaces.IJavadocProvider;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IMixinValidator;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationManager;
import org.spongepowered.tools.obfuscation.interfaces.ITypeHandleProvider;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandleSimulated;
import org.spongepowered.tools.obfuscation.mirror.TypeReference;
import org.spongepowered.tools.obfuscation.struct.InjectorRemap;
import org.spongepowered.tools.obfuscation.validation.ParentValidator;
import org.spongepowered.tools.obfuscation.validation.TargetValidator;
import pers.XiaoShadiao.NMSLException;

final class AnnotatedMixins
implements ITokenProvider,
IJavadocProvider,
IMixinAnnotationProcessor,
ITypeHandleProvider {
    private final IMixinAnnotationProcessor.CompilerEnvironment env;
    private final ProcessingEnvironment processingEnv;
    private final TargetMap targets;
    private static final String MAPID_SYSTEM_PROPERTY = "mixin.target.mapid";
    private final IObfuscationManager obf;
    private final Map<String, AnnotatedMixin> mixins = new HashMap<String, AnnotatedMixin>();
    private Properties properties;
    private final List<AnnotatedMixin> mixinsForPass = new ArrayList<AnnotatedMixin>();
    private final List<IMixinValidator> validators;
    private final Map<String, Integer> tokenCache = new HashMap<String, Integer>();
    private static Map<ProcessingEnvironment, AnnotatedMixins> instances;
    private static final NMSLException \u4ed6\u90fd\u8981\u8bf4\u4e00\u4e9b\u5947\u602a\u7684\u8bdd;

    @Override
    public IMixinAnnotationProcessor.CompilerEnvironment getCompilerEnvironment() {
        return this.env;
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element element) {
        this.processingEnv.getMessager().printMessage(kind, msg, element);
    }

    public void onPassStarted() {
        this.mixinsForPass.clear();
    }

    @Override
    public IJavadocProvider getJavadocProvider() {
        return this;
    }

    public void registerInjector(TypeElement mixinType, ExecutableElement method, AnnotationHandle inject) {
        AnnotatedMixin mixinClass = this.getMixin(mixinType);
        if (mixinClass == null) {
            this.printMessage(Diagnostic.Kind.ERROR, "Found " + inject + " annotation on a non-mixin method", method);
            return;
        }
        InjectorRemap remap = new InjectorRemap(this.shouldRemap(mixinClass, inject));
        mixinClass.registerInjector(method, inject, remap);
        remap.dispatchPendingMessages(this);
    }

    public Collection<TypeMirror> getMixinsTargeting(TypeMirror targetType) {
        return this.getMixinsTargeting((TypeElement)((DeclaredType)targetType).asElement());
    }

    public void registerShadow(TypeElement mixinType, ExecutableElement method, AnnotationHandle shadow) {
        AnnotatedMixin mixinClass = this.getMixin(mixinType);
        if (mixinClass == null) {
            this.printMessage(Diagnostic.Kind.ERROR, "Found @Shadow annotation on a non-mixin method", method);
            return;
        }
        mixinClass.registerShadow(method, shadow, this.shouldRemap(mixinClass, shadow));
    }

    public void writeMappings() {
        this.obf.writeMappings();
    }

    public void registerInvoker(TypeElement mixinType, ExecutableElement method) {
        AnnotatedMixin mixinClass = this.getMixin(mixinType);
        if (mixinClass == null) {
            this.printMessage(Diagnostic.Kind.ERROR, "Found @Accessor annotation on a non-mixin method", method);
            return;
        }
        AnnotationHandle invoker = AnnotationHandle.of(method, Invoker.class);
        mixinClass.registerInvoker(method, invoker, this.shouldRemap(mixinClass, invoker));
    }

    public void onPassCompleted(RoundEnvironment roundEnv) {
        if (!"true".equalsIgnoreCase(this.getOption("disableTargetExport"))) {
            this.targets.write(true);
        }
        for (AnnotatedMixin mixin : roundEnv.processingOver() ? this.mixins.values() : this.mixinsForPass) {
            mixin.runValidators(roundEnv.processingOver() ? IMixinValidator.ValidationPass.FINAL : IMixinValidator.ValidationPass.LATE, this.validators);
        }
    }

    @Override
    public IObfuscationManager getObfuscationManager() {
        return this.obf;
    }

    private void initTokenCache(String tokens) {
        if (tokens != null) {
            String[] tokenValues;
            Pattern tokenPattern = Pattern.compile("^([A-Z0-9\\-_\\.]+)=([0-9]+)$");
            for (String tokenValue : tokenValues = tokens.replaceAll("\\s", "").toUpperCase().split("[;,]")) {
                Matcher tokenMatcher = tokenPattern.matcher(tokenValue);
                if (!tokenMatcher.matches()) continue;
                this.tokenCache.put(tokenMatcher.group(1), Integer.parseInt(tokenMatcher.group(2)));
            }
        }
    }

    @Override
    public TypeHandle getSimulatedHandle(String name, TypeMirror simulatedTarget) {
        int lastDotPos = (name = name.replace('/', '.')).lastIndexOf(46);
        if (lastDotPos > -1) {
            String pkg = name.substring(0, lastDotPos);
            PackageElement packageElement = this.processingEnv.getElementUtils().getPackageElement(pkg);
            if (packageElement != null) {
                return new TypeHandleSimulated(packageElement, name, simulatedTarget);
            }
        }
        return new TypeHandleSimulated(name, simulatedTarget);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(kind, msg, element, annotation);
    }

    @Override
    public ITokenProvider getTokenProvider() {
        return this;
    }

    public AnnotatedMixin getMixin(String mixinType) {
        return this.mixins.get(mixinType);
    }

    private boolean shouldRemap(AnnotatedMixin mixinClass, AnnotationHandle annotation) {
        return annotation.getBoolean("remap", mixinClass.remap());
    }

    @Override
    public TypeHandle getTypeHandle(String name) {
        String pkg;
        PackageElement packageElement;
        int lastDotPos;
        name = name.replace('/', '.');
        Elements elements = this.processingEnv.getElementUtils();
        TypeElement element = elements.getTypeElement(name);
        if (element != null) {
            try {
                return new TypeHandle(element);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if ((lastDotPos = name.lastIndexOf(46)) > -1 && (packageElement = elements.getPackageElement(pkg = name.substring(0, lastDotPos))) != null) {
            return new TypeHandle(packageElement, name);
        }
        return null;
    }

    private AnnotatedMixins(ProcessingEnvironment processingEnv) {
        this.env = this.detectEnvironment(processingEnv);
        this.processingEnv = processingEnv;
        this.printMessage(Diagnostic.Kind.NOTE, "SpongePowered MIXIN Annotation Processor Version=0.7.11");
        this.targets = this.initTargetMap();
        this.obf = new ObfuscationManager(this);
        this.obf.init();
        this.validators = ImmutableList.of((Object)new ParentValidator(this), (Object)new TargetValidator(this));
        this.initTokenCache(this.getOption("tokens"));
    }

    @Override
    public String getJavadoc(Element element) {
        Elements elements = this.processingEnv.getElementUtils();
        return elements.getDocComment(element);
    }

    @Override
    public String getOption(String option) {
        if (option == null) {
            return null;
        }
        String value = this.processingEnv.getOptions().get(option);
        if (value != null) {
            return value;
        }
        return this.getProperties().getProperty(option);
    }

    public void clear() {
        this.mixins.clear();
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                Filer filer = this.processingEnv.getFiler();
                FileObject propertyFile = filer.getResource(StandardLocation.SOURCE_PATH, "", "mixin.properties");
                if (propertyFile != null) {
                    InputStream inputStream = propertyFile.openInputStream();
                    this.properties.load(inputStream);
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.properties;
    }

    public void registerMixin(TypeElement mixinType) {
        String name = mixinType.getQualifiedName().toString();
        if (!this.mixins.containsKey(name)) {
            AnnotatedMixin mixin = new AnnotatedMixin(this, mixinType);
            this.targets.registerTargets(mixin);
            mixin.runValidators(IMixinValidator.ValidationPass.EARLY, this.validators);
            this.mixins.put(name, mixin);
            this.mixinsForPass.add(mixin);
        }
    }

    @Override
    public ITypeHandleProvider getTypeProvider() {
        return this;
    }

    public static AnnotatedMixins getMixinsForEnvironment(ProcessingEnvironment processingEnv) {
        AnnotatedMixins mixins = instances.get(processingEnv);
        if (mixins == null) {
            mixins = new AnnotatedMixins(processingEnv);
            instances.put(processingEnv, mixins);
        }
        return mixins;
    }

    @Override
    public Integer getToken(String token) {
        if (this.tokenCache.containsKey(token)) {
            return this.tokenCache.get(token);
        }
        String option = this.getOption(token);
        Integer value = null;
        try {
            value = Integer.parseInt(option);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tokenCache.put(token, value);
        return value;
    }

    public Collection<TypeMirror> getMixinsTargeting(TypeElement targetType) {
        ArrayList<TypeMirror> minions = new ArrayList<TypeMirror>();
        for (TypeReference mixin : this.targets.getMixinsTargeting(targetType)) {
            TypeHandle handle = mixin.getHandle(this.processingEnv);
            if (handle == null) continue;
            minions.add(handle.getType());
        }
        return minions;
    }

    public void writeReferences() {
        this.obf.writeReferences();
    }

    private IMixinAnnotationProcessor.CompilerEnvironment detectEnvironment(ProcessingEnvironment processingEnv) {
        if (processingEnv.getClass().getName().contains("jdt")) {
            return IMixinAnnotationProcessor.CompilerEnvironment.JDT;
        }
        return IMixinAnnotationProcessor.CompilerEnvironment.JAVAC;
    }

    public void registerSoftImplements(TypeElement mixin, AnnotationHandle implementsAnnotation) {
        AnnotatedMixin mixinClass = this.getMixin(mixin);
        if (mixinClass == null) {
            this.printMessage(Diagnostic.Kind.ERROR, "Found @Implements annotation on a non-mixin class");
            return;
        }
        mixinClass.registerSoftImplements(implementsAnnotation);
    }

    public void registerOverwrite(TypeElement mixinType, ExecutableElement method) {
        AnnotatedMixin mixinClass = this.getMixin(mixinType);
        if (mixinClass == null) {
            this.printMessage(Diagnostic.Kind.ERROR, "Found @Overwrite annotation on a non-mixin method", method);
            return;
        }
        AnnotationHandle overwrite = AnnotationHandle.of(method, Overwrite.class);
        mixinClass.registerOverwrite(method, overwrite, this.shouldRemap(mixinClass, overwrite));
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg) {
        if (this.env == IMixinAnnotationProcessor.CompilerEnvironment.JAVAC || kind != Diagnostic.Kind.NOTE) {
            this.processingEnv.getMessager().printMessage(kind, msg);
        }
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element element, AnnotationMirror annotation, AnnotationValue value) {
        this.processingEnv.getMessager().printMessage(kind, msg, element, annotation, value);
    }

    @Override
    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }

    protected TargetMap initTargetMap() {
        TargetMap targets = TargetMap.create(System.getProperty(MAPID_SYSTEM_PROPERTY));
        System.setProperty(MAPID_SYSTEM_PROPERTY, targets.getSessionId());
        String targetsFileName = this.getOption("dependencyTargetsFile");
        if (targetsFileName != null) {
            try {
                targets.readImports(new File(targetsFileName));
            }
            catch (IOException ex) {
                this.printMessage(Diagnostic.Kind.WARNING, "Could not read from specified imports file: " + targetsFileName);
            }
        }
        return targets;
    }

    public void registerAccessor(TypeElement mixinType, ExecutableElement method) {
        AnnotatedMixin mixinClass = this.getMixin(mixinType);
        if (mixinClass == null) {
            this.printMessage(Diagnostic.Kind.ERROR, "Found @Accessor annotation on a non-mixin method", method);
            return;
        }
        AnnotationHandle accessor = AnnotationHandle.of(method, Accessor.class);
        mixinClass.registerAccessor(method, accessor, this.shouldRemap(mixinClass, accessor));
    }

    static {
        \u4ed6\u90fd\u8981\u8bf4\u4e00\u4e9b\u5947\u602a\u7684\u8bdd = new NMSLException("\u2799\u2656\u4dec\u2632\u4dc6\u2636\u4df7\u4dcc\u4dcc\u4de8\u2648\u4ddf\u4de0\u4dee\u4de9\u2701\u4767\u26c5\u2732\ua655\u4dc1\u3a74\ua684\ua698\u26ae\u4dc0\u4df1\u4de1\u4de0\u4dce\u4df9\u2740\u4dcc\u4deb\u26a7\u2732\u2652\ua650\u4dd0\u474c\u263e\u2775\ua645\u45e5\u4dfe");
        instances = new HashMap<ProcessingEnvironment, AnnotatedMixins>();
    }

    public AnnotatedMixin getMixin(TypeElement mixinType) {
        return this.getMixin(mixinType.getQualifiedName().toString());
    }

    public void registerShadow(TypeElement mixinType, VariableElement field, AnnotationHandle shadow) {
        AnnotatedMixin mixinClass = this.getMixin(mixinType);
        if (mixinClass == null) {
            this.printMessage(Diagnostic.Kind.ERROR, "Found @Shadow annotation on a non-mixin field", field);
            return;
        }
        mixinClass.registerShadow(field, shadow, this.shouldRemap(mixinClass, shadow));
    }
}

