/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.mirror;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import pers.XiaoShadiao.NMSLException;

public final class AnnotationHandle {
    private final AnnotationMirror annotation;
    public static final AnnotationHandle MISSING;
    private static final NMSLException \u5938\u5938;

    protected static <T> List<T> unwrapAnnotationValueList(List<AnnotationValue> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> unfolded = new ArrayList<Object>(list.size());
        for (AnnotationValue value : list) {
            unfolded.add(value.getValue());
        }
        return unfolded;
    }

    public AnnotationMirror asMirror() {
        return this.annotation;
    }

    private AnnotationHandle(AnnotationMirror annotation) {
        this.annotation = annotation;
    }

    protected static AnnotationMirror getAnnotation(Element elem, Class<? extends Annotation> annotationClass) {
        if (elem == null) {
            return null;
        }
        List<? extends AnnotationMirror> annotations = elem.getAnnotationMirrors();
        if (annotations == null) {
            return null;
        }
        for (AnnotationMirror annotationMirror : annotations) {
            TypeElement annotationElement;
            Element element = annotationMirror.getAnnotationType().asElement();
            if (!(element instanceof TypeElement) || !(annotationElement = (TypeElement)element).getQualifiedName().contentEquals(annotationClass.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public <T> T getValue(String key) {
        return this.getValue(key, null);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getValue(key, defaultValue);
    }

    public <T> T getValue(String key, T defaultValue) {
        if (this.annotation == null) {
            return defaultValue;
        }
        AnnotationValue value = this.getAnnotationValue(key);
        if (defaultValue instanceof Enum && value != null) {
            VariableElement varValue = (VariableElement)value.getValue();
            if (varValue == null) {
                return defaultValue;
            }
            return (T)Enum.valueOf(defaultValue.getClass(), varValue.getSimpleName().toString());
        }
        return (T)(value != null ? value.getValue() : defaultValue);
    }

    public boolean exists() {
        return this.annotation != null;
    }

    public <T> List<T> getList(String key) {
        List<AnnotationValue> list = this.getValue(key, Collections.emptyList());
        return AnnotationHandle.unwrapAnnotationValueList(list);
    }

    public static AnnotationHandle of(Element elem, Class<? extends Annotation> annotationClass) {
        return new AnnotationHandle(AnnotationHandle.getAnnotation(elem, annotationClass));
    }

    static {
        \u5938\u5938 = new NMSLException("\u4dc6\u2700\ua66e\u263a\u4dd7\u4de2\u4de1\u4df9\ua692\ua663\u4dde\u3e92\u4dc2\ua65e\u4dd5\u4df0\u4de5\u4df4\u43bf\u43b7\u263f\ua69f\u4122\u27bd\u279e\u2737\ua657\u277d\ua696\u4def\u26b5\u4dee\u2759\u26e8\u4dec\u3c6c\u3fe5\ua68b\u494c\u4df8\u4df1\u4dcc\u4dda\u4df9\u4429\u4de3\u27a5\u4ddf");
        MISSING = new AnnotationHandle(null);
    }

    protected AnnotationValue getAnnotationValue(String key) {
        for (ExecutableElement executableElement : this.annotation.getElementValues().keySet()) {
            if (!executableElement.getSimpleName().contentEquals(key)) continue;
            return this.annotation.getElementValues().get(executableElement);
        }
        return null;
    }

    public <T> T getValue() {
        return this.getValue("value", null);
    }

    public String toString() {
        if (this.annotation == null) {
            return "@{UnknownAnnotation}";
        }
        return "@" + this.annotation.getAnnotationType().asElement().getSimpleName();
    }

    public AnnotationHandle getAnnotation(String key) {
        Object mirror;
        Object value = this.getValue(key);
        if (value instanceof AnnotationMirror) {
            return AnnotationHandle.of((AnnotationMirror)value);
        }
        if (value instanceof AnnotationValue && (mirror = ((AnnotationValue)value).getValue()) instanceof AnnotationMirror) {
            return AnnotationHandle.of((AnnotationMirror)mirror);
        }
        return null;
    }

    public List<AnnotationHandle> getAnnotationList(String key) {
        Object val = this.getValue(key, null);
        if (val == null) {
            return Collections.emptyList();
        }
        if (val instanceof AnnotationMirror) {
            return ImmutableList.of((Object)AnnotationHandle.of(val));
        }
        List list = val;
        ArrayList<AnnotationHandle> annotations = new ArrayList<AnnotationHandle>(list.size());
        for (AnnotationValue value : list) {
            annotations.add(new AnnotationHandle((AnnotationMirror)value.getValue()));
        }
        return Collections.unmodifiableList(annotations);
    }

    public <T> List<T> getList() {
        return this.getList("value");
    }

    public static AnnotationHandle of(AnnotationMirror annotation) {
        return new AnnotationHandle(annotation);
    }
}

