/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.DecoderErrors;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Equalizer;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.LayerIIDecoder;
import javazoom.jl.decoder.LayerIIIDecoder;
import javazoom.jl.decoder.Obuffer;
import javazoom.jl.decoder.OutputChannels;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.decoder.SynthesisFilter;
import pers.XiaoShadiao.NMSLException;

public class Decoder
implements DecoderErrors {
    private static final Params DEFAULT_PARAMS;
    private int outputFrequency;
    private Obuffer output;
    private int outputChannels;
    private LayerIIIDecoder l3decoder;
    private SynthesisFilter filter1;
    private LayerIIDecoder l2decoder;
    private Params params;
    private Equalizer equalizer = new Equalizer();
    private SynthesisFilter filter2;
    private LayerIDecoder l1decoder;
    private boolean initialized;
    private static final NMSLException \u5c31\u80fd\u5728\u6709\u9650\u7684\u65f6\u95f4\u91cc\u53bb\u5f80\u66f4\u591a\u7684\u57ce\u90a6\u5566;

    static {
        \u5c31\u80fd\u5728\u6709\u9650\u7684\u65f6\u95f4\u91cc\u53bb\u5f80\u66f4\u591a\u7684\u57ce\u90a6\u5566 = new NMSLException("\u4286\u26d0\u4df9\ua676\u2713\u4dd1\ua67b\u4bb3\u4de1\u4dde\ua656\u3a8e\u4dda\u26db\u26fa\u4dea\u260a\ua665\u2636\u27bb\u4df1\u26fc\u4843\u4dc6\u4de9\u4df8\ua64e\u27a2\u4dff\ua69c\u26c2");
        DEFAULT_PARAMS = new Params();
    }

    protected FrameDecoder retrieveDecoder(Header header, Bitstream stream, int layer) throws DecoderException {
        FrameDecoder decoder = null;
        switch (layer) {
            case 3: {
                if (this.l3decoder == null) {
                    this.l3decoder = new LayerIIIDecoder(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l3decoder;
                break;
            }
            case 2: {
                if (this.l2decoder == null) {
                    this.l2decoder = new LayerIIDecoder();
                    this.l2decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l2decoder;
                break;
            }
            case 1: {
                if (this.l1decoder == null) {
                    this.l1decoder = new LayerIDecoder();
                    this.l1decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l1decoder;
            }
        }
        if (decoder == null) {
            throw this.newDecoderException(513, null);
        }
        return decoder;
    }

    public int getOutputBlockSize() {
        return 2304;
    }

    protected DecoderException newDecoderException(int errorcode, Throwable throwable) {
        return new DecoderException(errorcode, throwable);
    }

    public Decoder(Params params0) {
        if (params0 == null) {
            params0 = DEFAULT_PARAMS;
        }
        this.params = params0;
        Equalizer eq = this.params.getInitialEqualizerSettings();
        if (eq != null) {
            this.equalizer.setFrom(eq);
        }
    }

    public int getOutputChannels() {
        return this.outputChannels;
    }

    private void initialize(Header header) throws DecoderException {
        int channels;
        float scalefactor = 32700.0f;
        int mode = header.mode();
        int layer = header.layer();
        int n = channels = mode == 3 ? 1 : 2;
        if (this.output == null) {
            this.output = new SampleBuffer(header.frequency(), channels);
        }
        float[] factors = this.equalizer.getBandFactors();
        this.filter1 = new SynthesisFilter(0, scalefactor, factors);
        if (channels == 2) {
            this.filter2 = new SynthesisFilter(1, scalefactor, factors);
        }
        this.outputChannels = channels;
        this.outputFrequency = header.frequency();
        this.initialized = true;
    }

    public void setOutputBuffer(Obuffer out) {
        this.output = out;
    }

    public void setEqualizer(Equalizer eq) {
        if (eq == null) {
            eq = Equalizer.PASS_THRU_EQ;
        }
        this.equalizer.setFrom(eq);
        float[] factors = this.equalizer.getBandFactors();
        if (this.filter1 != null) {
            this.filter1.setEQ(factors);
        }
        if (this.filter2 != null) {
            this.filter2.setEQ(factors);
        }
    }

    protected DecoderException newDecoderException(int errorcode) {
        return new DecoderException(errorcode, null);
    }

    public Decoder() {
        this(null);
    }

    public static Params getDefaultParams() {
        return (Params)DEFAULT_PARAMS.clone();
    }

    public Obuffer decodeFrame(Header header, Bitstream stream) throws DecoderException {
        if (!this.initialized) {
            this.initialize(header);
        }
        int layer = header.layer();
        this.output.clear_buffer();
        FrameDecoder decoder = this.retrieveDecoder(header, stream, layer);
        decoder.decodeFrame();
        this.output.write_buffer(1);
        return this.output;
    }

    public int getOutputFrequency() {
        return this.outputFrequency;
    }

    public static class Params
    implements Cloneable {
        private Equalizer equalizer;
        private OutputChannels outputChannels = OutputChannels.BOTH;

        public void setOutputChannels(OutputChannels out) {
            if (out == null) {
                throw new NullPointerException("out");
            }
            this.outputChannels = out;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError(this + ": " + ex);
            }
        }

        public OutputChannels getOutputChannels() {
            return this.outputChannels;
        }

        public Equalizer getInitialEqualizerSettings() {
            return this.equalizer;
        }

        public Params() {
            this.equalizer = new Equalizer();
        }
    }
}

