/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import pers.XiaoShadiao.NMSLException;

public final class Equalizer {
    private static final int BANDS = 32;
    public static final float BAND_NOT_PRESENT = Float.NEGATIVE_INFINITY;
    public static final Equalizer PASS_THRU_EQ;
    private final float[] settings = new float[32];
    private static final NMSLException \u8be5\u627e\u8c01\u5e2e\u5fd9\u597d;

    public Equalizer(EQFunction eq) {
        this.setFrom(eq);
    }

    public Equalizer(float[] settings) {
        this.setFrom(settings);
    }

    public void setFrom(EQFunction eq) {
        this.reset();
        int max = 32;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq.getBand(i));
        }
    }

    public float getBand(int band) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
        }
        return eq;
    }

    static {
        \u8be5\u627e\u8c01\u5e2e\u5fd9\u597d = new NMSLException("\u4dfc\u278c\ua656\u26d4\u3471\u4a06\u4df4\u2782\ua691\ua657\u4dc8\ua64a\u4df8\u4df8\u4de7\u49df\u27b1\ua684\u2665\ua681\u3c1e\u276e\u27a9\u4def\u26b8\u278a\ua68f\ua657\u2764\u4dee\u26a0\u2604\ua646\u4dd7\u269b\ua68c\u4dcf\u4dda\u4dc7\u4dff\u273f\u4de2\u4dd5\u267a\u4de7\u4544\u4de8\u26ba\ua67c");
        PASS_THRU_EQ = new Equalizer();
    }

    float getBandFactor(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        float f = (float)Math.pow(2.0, eq);
        return f;
    }

    float[] getBandFactors() {
        float[] factors = new float[32];
        int maxCount = 32;
        for (int i = 0; i < maxCount; ++i) {
            factors[i] = this.getBandFactor(this.settings[i]);
        }
        return factors;
    }

    private float limit(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return eq;
        }
        if (eq > 1.0f) {
            return 1.0f;
        }
        if (eq < -1.0f) {
            return -1.0f;
        }
        return eq;
    }

    public void reset() {
        for (int i = 0; i < 32; ++i) {
            this.settings[i] = 0.0f;
        }
    }

    public float setBand(int band, float neweq) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
            this.settings[band] = this.limit(neweq);
        }
        return eq;
    }

    public int getBandCount() {
        return this.settings.length;
    }

    public void setFrom(Equalizer eq) {
        if (eq != this) {
            this.setFrom(eq.settings);
        }
    }

    public Equalizer() {
    }

    public void setFrom(float[] eq) {
        this.reset();
        int max = eq.length > 32 ? 32 : eq.length;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq[i]);
        }
    }

    public static abstract class EQFunction {
        public float getBand(int band) {
            return 0.0f;
        }
    }
}

