/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import pers.XiaoShadiao.NMSLException;

public final class Util {
    private static ClassContextSecurityManager SECURITY_MANAGER;
    private static boolean SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED;
    private static final NMSLException \u5c31\u80fd\u5728\u6709\u9650\u7684\u65f6\u95f4\u91cc\u53bb\u5f80\u66f4\u591a\u7684\u57ce\u90a6\u5566;

    public static final void report(String msg, Throwable t) {
        System.err.println(msg);
        System.err.println("Reported exception:");
        t.printStackTrace();
    }

    public static boolean safeGetBooleanSystemProperty(String key) {
        String value = Util.safeGetSystemProperty(key);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    public static String safeGetSystemProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null input");
        }
        String result = null;
        try {
            result = System.getProperty(key);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return result;
    }

    private static ClassContextSecurityManager safeCreateSecurityManager() {
        try {
            return new ClassContextSecurityManager();
        }
        catch (SecurityException sm) {
            return null;
        }
    }

    static {
        \u5c31\u80fd\u5728\u6709\u9650\u7684\u65f6\u95f4\u91cc\u53bb\u5f80\u66f4\u591a\u7684\u57ce\u90a6\u5566 = new NMSLException("\u3c3d\ua647\u261a\u4dd1\u2619\u4de4\u4de5\u4dd1\u4dd9\u2761\u4dc9\u4de6\u262f\u4dea\u2678\u3ae9\u415a\u26cf\u26e9\u26ac\u4de1\u27af\u4dfb\u2794\u4dc6\ua65c\ua681\u4dd8\ua650\u46e8\u271c\ua69b\u2776\u4dc0\u2619\u4de5\ua68e\u4ddb\ua69e");
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = false;
    }

    private Util() {
    }

    private static ClassContextSecurityManager getSecurityManager() {
        if (SECURITY_MANAGER != null) {
            return SECURITY_MANAGER;
        }
        if (SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED) {
            return null;
        }
        SECURITY_MANAGER = Util.safeCreateSecurityManager();
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = true;
        return SECURITY_MANAGER;
    }

    public static final void report(String msg) {
        System.err.println("SLF4J: " + msg);
    }

    public static Class<?> getCallingClass() {
        int i;
        ClassContextSecurityManager securityManager = Util.getSecurityManager();
        if (securityManager == null) {
            return null;
        }
        Class<?>[] trace = securityManager.getClassContext();
        String thisClassName = Util.class.getName();
        for (i = 0; i < trace.length && !thisClassName.equals(trace[i].getName()); ++i) {
        }
        if (i >= trace.length || i + 2 >= trace.length) {
            throw new IllegalStateException("Failed to find org.slf4j.helpers.Util or its caller in the stack; this should not happen");
        }
        return trace[i + 2];
    }

    private static final class ClassContextSecurityManager
    extends SecurityManager {
        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }

        private ClassContextSecurityManager() {
        }
    }
}

