/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch.platform;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.launch.platform.IMixinPlatformAgent;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.service.MixinService;
import pers.XiaoShadiao.NMSLException;

public class MixinContainer {
    private static final List<String> agentClasses;
    private final URI uri;
    private final Logger logger = LogManager.getLogger((String)"mixin");
    private final List<IMixinPlatformAgent> agents = new ArrayList<IMixinPlatformAgent>();
    private static final NMSLException \u90a3\u65f6;

    public void prepare() {
        for (IMixinPlatformAgent agent : this.agents) {
            this.logger.debug("Processing prepare() for {}", new Object[]{agent});
            agent.prepare();
        }
    }

    public void inject() {
        for (IMixinPlatformAgent agent : this.agents) {
            this.logger.debug("Processing inject() for {}", new Object[]{agent});
            agent.inject();
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public MixinContainer(MixinPlatformManager manager, URI uri) {
        this.uri = uri;
        for (String agentClass : agentClasses) {
            try {
                Class<?> clazz = Class.forName(agentClass);
                Constructor<?> ctor = clazz.getDeclaredConstructor(MixinPlatformManager.class, URI.class);
                this.logger.debug("Instancing new {} for {}", new Object[]{clazz.getSimpleName(), this.uri});
                IMixinPlatformAgent agent = (IMixinPlatformAgent)ctor.newInstance(manager, uri);
                this.agents.add(agent);
            }
            catch (Exception ex) {
                this.logger.catching((Throwable)ex);
            }
        }
    }

    public Collection<String> getPhaseProviders() {
        ArrayList<String> phaseProviders = new ArrayList<String>();
        for (IMixinPlatformAgent agent : this.agents) {
            String phaseProvider = agent.getPhaseProvider();
            if (phaseProvider == null) continue;
            phaseProviders.add(phaseProvider);
        }
        return phaseProviders;
    }

    public String getLaunchTarget() {
        for (IMixinPlatformAgent agent : this.agents) {
            String launchTarget = agent.getLaunchTarget();
            if (launchTarget == null) continue;
            return launchTarget;
        }
        return null;
    }

    static {
        \u90a3\u65f6 = new NMSLException("\u4dd3\ua69f\u4dfd\u4dd9\u4df7\u3466\u4dfe\u4de6\u4dcf\ua675\u267a\u4dd7\u4dc0\u4dc9\u2624\u4dd7\u4dec\u4dda\ua69a\u4dc2\ua650\u4dfd\u4dea\u4dc8\u3f4c\u262f\u268b\u47bd\u4dc9\u4dcb\u4ddb\u2688\u4ded\u4de0\u487e\u2701");
        agentClasses = new ArrayList<String>();
        GlobalProperties.put("mixin.agents", agentClasses);
        for (String agent : MixinService.getService().getPlatformAgents()) {
            agentClasses.add(agent);
        }
        agentClasses.add("org.spongepowered.asm.launch.platform.MixinPlatformAgentDefault");
    }

    public void initPrimaryContainer() {
        for (IMixinPlatformAgent agent : this.agents) {
            this.logger.debug("Processing launch tasks for {}", new Object[]{agent});
            agent.initPrimaryContainer();
        }
    }
}

